/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.core.IXaeroMinimapModelRenderer;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconModelFieldResolver;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.ResolvedFieldModelPartsRenderer;
import xaero.common.minimap.render.radar.ResolvedFieldModelRootPathListener;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.misc.Misc;

public class EntityIconPrerenderer {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private static final int ICON_WIDTH = 64;
    private static final ModelRenderer[] ONE_RENDERER_ARRAY = new ModelRenderer[1];
    private static final Object[] ONE_OBJECT_ARRAY = new Object[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private final IXaeroMinimap modMain;
    private ImprovedFramebuffer modelRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private ResolvedFieldModelPartsRenderer modelPartsFieldResolverListener;
    private ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    private final XaeroIconAtlasManager iconAtlasManager;
    public static boolean DETECTING_MODEL_RENDERS;
    private Render modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private Field blendStateField;
    private Field colorMaskStateField;
    private Field depthStateField;
    private Field blendStateSrcFactorField;
    private Field blendStateDestFactorField;
    private Field blendStateAlphaSrcFactorField;
    private Field blendStateAlphaDestFactorField;
    private Field colorMaskStateRedField;
    private Field colorMaskStateGreenField;
    private Field colorMaskStateBlueField;
    private Field colorMaskStateAlphaField;
    private Field depthStateFuncField;
    private Field depthStateMaskField;
    private Field depthStateTestField;
    private Field booleanStateCurrentStateField;
    private Field cullStateField;
    private Field cullStateEnabledField;
    private Field cullStateModeField;
    private Field textureStatesField;
    private Field textureStateIdField;
    private Field activeTextureField;
    private Field colorStateField;
    private Field colorStateRedField;
    private Field colorStateGreenField;
    private Field colorStateBlueField;
    private Field colorStateAlphaField;

    public EntityIconPrerenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_179144_i((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_179144_i((int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
        this.blendStateField = Misc.getFieldReflection(GlStateManager.class, "field_179157_e", "blendState");
        this.colorMaskStateField = Misc.getFieldReflection(GlStateManager.class, "field_179171_s", "colorMaskState");
        this.depthStateField = Misc.getFieldReflection(GlStateManager.class, "field_179154_f", "depthState");
        this.textureStatesField = Misc.getFieldReflection(GlStateManager.class, "field_179174_p", "textureState");
        this.cullStateField = Misc.getFieldReflection(GlStateManager.class, "field_179167_h", "cullState");
        try {
            Class<?> blendStateClass = Class.forName("net.minecraft.client.renderer.GlStateManager$BlendState");
            this.blendStateSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_179211_b", "srcFactor");
            this.blendStateDestFactorField = Misc.getFieldReflection(blendStateClass, "field_179212_c", "dstFactor");
            this.blendStateAlphaSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_179209_d", "srcFactorAlpha");
            this.blendStateAlphaDestFactorField = Misc.getFieldReflection(blendStateClass, "field_179210_e", "dstFactorAlpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> colorMaskStateClass = Class.forName("net.minecraft.client.renderer.GlStateManager$ColorMask");
            this.colorMaskStateRedField = Misc.getFieldReflection(colorMaskStateClass, "field_179188_a", "red");
            this.colorMaskStateGreenField = Misc.getFieldReflection(colorMaskStateClass, "field_179186_b", "green");
            this.colorMaskStateBlueField = Misc.getFieldReflection(colorMaskStateClass, "field_179187_c", "blue");
            this.colorMaskStateAlphaField = Misc.getFieldReflection(colorMaskStateClass, "field_179185_d", "alpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> depthStateClass = Class.forName("net.minecraft.client.renderer.GlStateManager$DepthState");
            this.depthStateTestField = Misc.getFieldReflection(depthStateClass, "field_179052_a", "depthTest");
            this.depthStateFuncField = Misc.getFieldReflection(depthStateClass, "field_179051_c", "depthFunc");
            this.depthStateMaskField = Misc.getFieldReflection(depthStateClass, "field_179050_b", "maskEnabled");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> cullStateClass = Class.forName("net.minecraft.client.renderer.GlStateManager$CullState");
            this.cullStateEnabledField = Misc.getFieldReflection(cullStateClass, "field_179054_a", "cullFace");
            this.cullStateModeField = Misc.getFieldReflection(cullStateClass, "field_179053_b", "mode");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> booleanStateClass = Class.forName("net.minecraft.client.renderer.GlStateManager$BooleanState");
            this.booleanStateCurrentStateField = Misc.getFieldReflection(booleanStateClass, "field_179201_b", "currentState");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> textureStateClass = Class.forName("net.minecraft.client.renderer.GlStateManager$TextureState");
            this.textureStateIdField = Misc.getFieldReflection(textureStateClass, "field_179059_b", "textureName");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.activeTextureField = Misc.getFieldReflection(GlStateManager.class, "field_179162_o", "activeTextureUnit");
        this.colorStateField = Misc.getFieldReflection(GlStateManager.class, "field_179170_t", "colorState");
        try {
            Class<?> colorStateClass = Class.forName("net.minecraft.client.renderer.GlStateManager$Color");
            this.colorStateRedField = Misc.getFieldReflection(colorStateClass, "field_179195_a", "red");
            this.colorStateGreenField = Misc.getFieldReflection(colorStateClass, "field_179193_b", "green");
            this.colorStateBlueField = Misc.getFieldReflection(colorStateClass, "field_179194_c", "blue");
            this.colorStateAlphaField = Misc.getFieldReflection(colorStateClass, "field_179192_d", "alpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.modelPartsFieldResolverListener = new ResolvedFieldModelPartsRenderer();
        this.resolvedFieldModelRootPathListener = new ResolvedFieldModelRootPathListener();
        int maxTextureSize = GlStateManager.func_187397_v((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager.func_179150_h((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
    }

    void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    private XaeroIconAtlas getCurrentAtlas() throws Exception {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        MinimapLogs.LOGGER.info("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public XaeroIcon prerender(String cacheKey, Render entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig, ResourceLocation readySprite, boolean outlined, boolean flipped, boolean debug, ScaledResolution scaledRes) {
        boolean renderedSomething;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        OpenGLException.checkGLError();
        modelRenderFramebuffer.func_147610_a(true);
        int farPlane = 500;
        this.setupMatrices(64, farPlane);
        OpenGLException.checkGLError();
        if (readySprite == null) {
            EntityLivingBase livingEntity;
            GlStateManager.func_179126_j();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            if (Minecraft.func_71410_x().func_175598_ae().field_78734_h != null) {
                DETECTING_MODEL_RENDERS = true;
                this.modelRenderDetectionEntityRenderer = entityRenderer;
                this.modelRenderDetectionEntityModelClass = null;
                this.modelRenderDetectionList.clear();
                this.lastModelRenderDetected = null;
                GlStateManager.func_179094_E();
                try {
                    entityRenderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
                    OpenGLException.checkGLError();
                }
                catch (Exception e) {
                    this.modelRenderDetectionList.clear();
                    MinimapLogs.LOGGER.error("Exception when calling the full entity renderer before rendering the icon. " + EntityList.func_191301_a((Entity)entity), (Throwable)e);
                }
                DETECTING_MODEL_RENDERS = false;
                GlStateManager.func_179121_F();
                while (GL11.glGetError() != 0) {
                }
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + EntityList.func_191301_a((Entity)entity));
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179138_g((int)33985);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)33984);
            RenderHelper.func_74518_a();
            ModelBase entityModel = this.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endModelRendering(modelRenderFramebuffer);
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(helper, defaultFramebuffer, scaledRes);
                return EntityIconManager.FAILED;
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179086_m((int)16640);
            GlStateManager.func_179147_l();
            GlStateManager.func_179126_j();
            GlStateManager.func_179129_p();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            if (debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-65536);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)32.0f, (float)32.0f, (float)-450.0f);
            GlStateManager.func_179109_b((float)modelConfig.offsetX, (float)(-modelConfig.offsetY), (float)0.0f);
            int mainScale = 32;
            GlStateManager.func_179152_a((float)mainScale, (float)(-mainScale), (float)(-mainScale));
            if (scale < 1.0f) {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            }
            GlStateManager.func_179152_a((float)modelConfig.baseScale, (float)modelConfig.baseScale, (float)modelConfig.baseScale);
            GlStateManager.func_179114_b((float)modelConfig.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)modelConfig.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)modelConfig.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
            EntityIconDefinitions.customTransformation(entityModel, entity, this);
            EntityLivingBase entityLivingBase = livingEntity = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
            if (livingEntity != null) {
                this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
            }
            renderedSomething = this.renderIcon(entityRenderer, entityModel, this.modelRenderDetectionList, entity, modelConfig, defaultModelConfig);
            if (livingEntity != null) {
                this.livingEntityRotationResetter.restore(livingEntity);
            }
            EntityIconDefinitions.customPostRenderTransformation(entityModel, entity);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
            if (debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)9.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711936);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179086_m((int)16640);
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            RenderHelper.func_74518_a();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(readySprite);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GlStateManager.func_179109_b((float)32.0f, (float)32.0f, (float)1.0f);
            if (scale < 1.0f) {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(-32.0f, -32.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
            renderedSomething = true;
        }
        this.endModelRendering(modelRenderFramebuffer);
        XaeroIcon icon = EntityIconManager.FAILED;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179086_m((int)16384);
            GlStateManager.func_179084_k();
            if (debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)18.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16776961);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.func_147612_c();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.05f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)1);
            if (outlined) {
                for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                    for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                        if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                        helper.drawMyTexturedModalRect(shadowOffsetX, 64 + shadowOffsetY, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f);
                    }
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            helper.drawMyTexturedModalRect(0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            if (debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)27.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711681);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_179147_l();
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.func_179144_i((int)0);
            try {
                XaeroIconAtlas atlas = this.getCurrentAtlas();
                icon = atlas.createIcon();
                this.atlasRenderFramebuffer.func_147610_a(false);
                GlStateManager.func_179083_b((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
                this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
                this.atlasRenderFramebuffer.func_147611_b();
                iconRenderFramebuffer.func_147612_c();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                if (flipped) {
                    helper.drawMyTexturedModalRect(0.0f, 64.0f, 0, 64, 64.0f, -64.0f, -64.0f, 64.0f);
                } else {
                    helper.drawMyTexturedModalRect(0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f);
                }
                if (debug) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)36.0f, (float)10.0f, (float)-10.0f);
                    GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                    Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-256);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
                }
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error(String.format("Exception rendering to a entity icon atlas for %s!", cacheKey), t);
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179144_i((int)0);
        }
        this.restoreMatrices(helper, defaultFramebuffer, scaledRes);
        this.atlasRenderFramebuffer.func_147609_e();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private void bindDefaultFramebuffer(Framebuffer defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            defaultFramebuffer.func_147610_a(true);
        } else {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        }
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
    }

    private void restoreMatrices(MinimapRendererHelper helper, Framebuffer framebuffer, ScaledResolution scaledRes) {
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        helper.defaultOrtho(framebuffer, scaledRes);
        GlStateManager.func_179128_n((int)5888);
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.func_147609_e();
        GlStateManager.func_179147_l();
        RenderHelper.func_74519_b();
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
    }

    private ModelRenderer renderModel(Render<?> entityRenderer, ModelBase entityModel, Entity entity, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig, ModelRenderer mainPart, ArrayList<ModelRenderer> renderedModels, int entityTexture, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde, List<String> hardcodedMainPartAliases, List<String> hardcodedModelPartsFields) {
        boolean isChildBU = entityModel.field_78091_s;
        entityModel.field_78091_s = false;
        if (entityTexture > 0) {
            Object modelRoot = null;
            if (modelConfig.modelRootPath != null) {
                modelRoot = this.resolveModelRoot(entityModel, modelConfig.modelRootPath, entity);
            }
            if (modelRoot == null) {
                modelRoot = EntityIconDefinitions.getModelRoot(entityRenderer, entityModel);
            }
            this.setupModelRenderType(entityTexture, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(modelRoot, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!fullModelIcon && !forceFieldCheck && modelRoot instanceof ModelBiped) {
                ModelRenderer headRenderer = ((ModelBiped)modelRoot).field_78116_c;
                if (mainPart == null) {
                    mainPart = headRenderer;
                }
                ModelRenderer headWearRenderer = ((ModelBiped)modelRoot).field_178720_f;
                this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                this.entityModelPartsRenderer.renderPart(headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
            } else if (!fullModelIcon && !forceFieldCheck && modelRoot instanceof ModelQuadruped) {
                ModelRenderer headRenderer = ((ModelQuadruped)modelRoot).field_78150_a;
                if (headRenderer != null) {
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else {
                if (modelConfig.modelPartsFields == null) {
                    mainPart = this.searchSuperclassFields(modelRoot, renderedModels, mainPart, hardcodedMainPartAliases, true, modelConfig.modelPartsRotationReset, mrde);
                }
                List<String> headPartsFields = hardcodedModelPartsFields;
                if (fullModelIcon) {
                    headPartsFields = null;
                } else if (modelConfig.modelPartsFields != null) {
                    headPartsFields = modelConfig.modelPartsFields;
                }
                mainPart = this.searchSuperclassFields(modelRoot, renderedModels, mainPart, headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
            }
            this.clearModelRenderType();
        }
        entityModel.field_78091_s = isChildBU;
        return mainPart;
    }

    private void setupModelRenderType(int entityTexture, ModelRenderDetectionElement mrde) {
        int blendAlphaSrcFactor = mrde.blendAlphaSrcFactor;
        int blendAlphaDestFactor = mrde.blendAlphaDestFactor;
        if (mrde.blendDestFactor == 1 && mrde.blendSrcFactor != 0) {
            blendAlphaSrcFactor = 0;
            blendAlphaDestFactor = 1;
        }
        GlStateManager.func_179120_a((int)mrde.blendSrcFactor, (int)mrde.blendDestFactor, (int)blendAlphaSrcFactor, (int)blendAlphaDestFactor);
        GlStateManager.func_179135_a((boolean)mrde.colorMaskR, (boolean)mrde.colorMaskG, (boolean)mrde.colorMaskB, (boolean)mrde.colorMaskA);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)mrde.depthMask);
        GlStateManager.func_179143_c((int)(mrde.depthTest ? mrde.depthFunc : 519));
        if (mrde.cullFace) {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_187407_a((GlStateManager.CullFace)(mrde.cullMode == 1029 ? GlStateManager.CullFace.BACK : (mrde.cullMode == 1028 ? GlStateManager.CullFace.FRONT : GlStateManager.CullFace.FRONT_AND_BACK)));
        GlStateManager.func_179144_i((int)entityTexture);
    }

    private void clearModelRenderType() {
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179097_i();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179129_p();
        GlStateManager.func_179144_i((int)0);
    }

    public ModelRenderer searchSuperclassFields(Object modelRoot, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.searchSuperclassFields(modelRoot, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public ModelRenderer handleFields(Object modelRoot, Field[] declaredModelFields, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.handleFields(modelRoot, declaredModelFields, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    private void onModelRenderDetection(ModelBase model, float red, float green, float blue, float alpha) {
        Object[] TEXTURES = (Object[])Misc.getReflectFieldValue(null, this.textureStatesField);
        int textureId = (Integer)Misc.getReflectFieldValue(TEXTURES[(Integer)Misc.getReflectFieldValue(null, this.activeTextureField)], this.textureStateIdField);
        Object BLEND = Misc.getReflectFieldValue(null, this.blendStateField);
        Object DEPTH = Misc.getReflectFieldValue(null, this.depthStateField);
        Object COLOR_MASK = Misc.getReflectFieldValue(null, this.colorMaskStateField);
        Object CULL = Misc.getReflectFieldValue(null, this.cullStateField);
        int blendSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateSrcFactorField);
        int blendDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateDestFactorField);
        int blendAlphaSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaSrcFactorField);
        int blendAlphaDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaDestFactorField);
        int depthFunc = (Integer)Misc.getReflectFieldValue(DEPTH, this.depthStateFuncField);
        boolean depthTest = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(DEPTH, this.depthStateTestField), this.booleanStateCurrentStateField);
        boolean depthMask = (Boolean)Misc.getReflectFieldValue(DEPTH, this.depthStateMaskField);
        boolean colorMaskR = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateRedField);
        boolean colorMaskG = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateGreenField);
        boolean colorMaskB = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateBlueField);
        boolean colorMaskA = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateAlphaField);
        boolean cullFace = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(CULL, this.cullStateEnabledField), this.booleanStateCurrentStateField);
        int cullMode = (Integer)Misc.getReflectFieldValue(CULL, this.cullStateModeField);
        if (this.lastModelRenderDetected == null || !this.lastModelRenderDetected.hasProperties(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, cullFace, cullMode)) {
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, red, green, blue, alpha, cullFace, cullMode);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer) {
        ModelBase model = ((IXaeroMinimapModelRenderer)modelRenderer).getXaero_model();
        if (this.modelRenderDetectionEntityModelClass == null) {
            ModelBase currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (this.modelRenderDetectionEntityModelClass != model.getClass()) {
            return;
        }
        Object COLOR = Misc.getReflectFieldValue(null, this.colorStateField);
        float red = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateRedField)).floatValue();
        float green = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateGreenField)).floatValue();
        float blue = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateBlueField)).floatValue();
        float alpha = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateAlphaField)).floatValue();
        this.onModelRenderDetection(model, red, green, blue, alpha);
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private boolean renderIcon(Render<?> entityRenderer, ModelBase mainEntityModel, List<ModelRenderDetectionElement> detectedModels, Entity entity, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig) {
        EntityIconCustomRenderer extraLayer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = !(modelConfig.renderingFullModel != null && modelConfig.renderingFullModel != false || modelConfig.modelPartsFields == null && !EntityIconDefinitions.forceFieldCheck(mainEntityModel));
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        ModelRenderer mainPart = null;
        boolean renderedSomething = false;
        ArrayList<ModelRenderer> mainRenderedModels = new ArrayList<ModelRenderer>();
        ResourceLocation mainEntityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (detectedModels.isEmpty() && mainEntityTexture != null) {
            TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
            ITextureObject mainTextureObject = textureManager.func_110581_b(mainEntityTexture);
            detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainTextureObject == null ? 0 : mainTextureObject.func_110552_b(), 770, 771, 1, 771, true, 515, true, true, true, true, true, 1.0f, 1.0f, 1.0f, 1.0f, false, 1029));
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            if (mrde.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement mrde : detectedModels) {
                mrde.allVisible = true;
            }
        }
        List<String> hardcodedMainPartAliases = EntityIconDefinitions.getMainModelPartFields(entityRenderer, mainEntityModel, entity);
        List<String> hardcodedModelPartsFields = EntityIconDefinitions.getSecondaryModelPartsFields(entityRenderer, mainEntityModel, entity);
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            ModelBase detectedModel = mrde.model;
            int detectedTexture = mrde.renderTexture;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(entityRenderer, detectedModel, entity, modelConfig, defaultModelConfig, mainPart, mainRenderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<ModelRenderer> renderedModels = new ArrayList<ModelRenderer>();
                mainPart = this.renderModel(entityRenderer, detectedModel, entity, modelConfig, defaultModelConfig, mainPart, renderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            this.setupModelRenderType(detectedTexture, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, new ArrayList<ModelRenderer>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            this.clearModelRenderType();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (extraLayer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = extraLayer.render(this, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(Entity entity, ModelBase model) {
        try {
            if (entity instanceof EntityLivingBase) {
                model.func_78086_a((EntityLivingBase)entity, 0.0f, 0.0f, 1.0f);
            }
            model.func_78087_a(0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f, entity);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            return false;
        }
    }

    private ModelBase getEntityRendererModel(Render entityRenderer) {
        if (entityRenderer instanceof RenderLivingBase) {
            return ((RenderLivingBase)entityRenderer).func_177087_b();
        }
        return null;
    }

    private Object resolveModelRoot(ModelBase model, ArrayList<ArrayList<String>> rootPath, Entity entity) {
        ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener = this.resolvedFieldModelRootPathListener;
        Object currentChainNode = model;
        for (ArrayList<String> pathStep : rootPath) {
            resolvedFieldModelRootPathListener.prepare();
            EntityIconModelFieldResolver.searchSuperclassFields(currentChainNode, pathStep, resolvedFieldModelRootPathListener, ONE_OBJECT_ARRAY);
            currentChainNode = resolvedFieldModelRootPathListener.getCurrentNode();
            if (currentChainNode != null && !resolvedFieldModelRootPathListener.failed()) continue;
            MinimapLogs.LOGGER.info(String.format("The following entity icon model root path step couldn't be resolved for %s:", EntityList.func_191301_a((Entity)entity)));
            for (String s : pathStep) {
                MinimapLogs.LOGGER.info(pathStep);
            }
            return null;
        }
        return currentChainNode;
    }
}

