/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.CompassRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected IXaeroMinimap modMain;
    protected Minecraft mc;
    protected MinimapInterface minimapInterface;
    protected MinimapRendererHelper helper;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<ITextComponent> underText;
    protected double zoom = 1.0;
    private BlockPos.MutableBlockPos mutableBlockPos;
    protected final CompassRenderer compassRenderer;

    public MinimapRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface, CompassRenderer compassRenderer) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimapInterface = minimapInterface;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        this.compassRenderer = compassRenderer;
    }

    public float getEntityYaw(Entity e, float partial) {
        if (e == this.mc.field_71439_g) {
            return e.field_70177_z;
        }
        if (e instanceof EntityLivingBase) {
            return ((EntityLivingBase)e).field_70758_at + (((EntityLivingBase)e).field_70759_as - ((EntityLivingBase)e).field_70758_at) * partial;
        }
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partial;
    }

    public double getRenderAngle(boolean lockedNorth) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle();
    }

    private double getActualAngle() {
        double rotation = Math.toDegrees(Misc.getYawRadians());
        return -90.0 - rotation;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, MinimapProcessor var2, int var3, int var4, float var5, float var6, int var7, boolean var8, boolean var9, int var10, double var11, double var13, boolean var15, boolean var16, ScaledResolution var17, ModSettings var18);

    public void renderMinimap(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int x, int y, int width, int height, ScaledResolution scaledRes, int size, float partial) {
        WaypointsManager waypointsManager;
        boolean crosshairDisplayed;
        int specW;
        int frameType;
        boolean renderFrame;
        int scale;
        ModSettings settings = this.modMain.getSettings();
        if (settings.getMinimapSize(scale = scaledRes.func_78325_e()) != this.lastMinimapSize) {
            this.lastMinimapSize = settings.getMinimapSize(scale);
            minimap.setToResetImage(true);
        }
        minimap.getEntityRadar().setLastRenderViewEntity(this.mc.func_175606_aa());
        ArrayList<ITextComponent> underText = this.underText;
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize(scale);
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize(mapSize);
        if (this.minimapInterface.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float minimapScale = settings.getMinimapScale(scale);
        float mapScale = (float)scale / minimapScale;
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187425_g((int)3317, (int)4);
        GlStateManager.func_187425_g((int)3316, (int)0);
        GlStateManager.func_187425_g((int)3315, (int)0);
        GlStateManager.func_187425_g((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = settings.minimapShape;
        boolean lockedNorth = settings.getLockNorth(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(lockedNorth));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && minimap.getMinimapWriter().getLoadedCaving() == -1 && minimap.getMinimapWriter().loadedLightOverlayType <= 0;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = !useWorldMap && minimap.getMinimapWriter().getLoadedCaving() != -1;
        boolean circleShape = shape == 1;
        this.renderChunks(minimapSession, minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, scaledRes, settings);
        if (this.minimapInterface.usingFBO()) {
            sizeFix = 1.0f;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0 / 4.0) * 4);
        double circleSeamAngle = -0.7853981633974483;
        int circleSeamWidth = 32;
        int circleFrameThickness = 4;
        double circleStartAngle = 0.0;
        if (!circleShape) {
            this.getHelper().drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            float outerRadius = mapSize / 4 + circleFrameThickness;
            circleStartAngle = circleSeamAngle - (double)((float)(circleSeamWidth / 2) / outerRadius);
            this.getHelper().drawTexturedElipseInsideRectangle(circleStartAngle, circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimapInterface.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean bl = renderFrame = (frameType = settings.minimapFrame) < ModSettings.FRAME_OPTIONS.length - 1;
        if (frameType > 0) {
            int frameColor = ModSettings.COLORS[settings.minimapFrameColor];
            GlStateManager.func_179131_c((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        MinimapRendererHelper helper = this.getHelper();
        if (renderFrame) {
            this.mc.func_110434_K().func_110577_a(InterfaceRenderer.minimapFrameTextures);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 16;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 16;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            int cornerTextureX = frameType == 0 ? 192 : (frameType == 1 ? 208 : 224);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, scaledY + 9 - 4, cornerTextureX, 97, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, rightCornerStartX, scaledY + 9 - 4, cornerTextureX, 113, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, bottomCornerStartY, cornerTextureX, 129, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, rightCornerStartX, bottomCornerStartY, cornerTextureX, 145, 16, 16);
            int horLineStartX = scaledX + 9 - 4 + 16;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horPieceTextureY = frameType == 0 ? 0 : (frameType == 1 ? 32 : 64);
            int horPieceWidth = 226;
            int horLineLength = (int)Math.ceil((double)horLineWidth / (double)horPieceWidth);
            for (int i = 0; i < horLineLength; ++i) {
                int pieceX = scaledX + 9 - 4 + 16 + i * horPieceWidth;
                int pieceW = horPieceWidth;
                if (i == horLineLength - 1 && pieceX + pieceW > rightCornerStartX) {
                    pieceW = rightCornerStartX - pieceX;
                }
                helper.addTexturedRectToExistingBuffer(vertexBuffer, pieceX, scaledY + 9 - 4, 0, horPieceTextureY, pieceW, 16);
                helper.addTexturedRectToExistingBuffer(vertexBuffer, pieceX, scaledY + 9 + mapSize / 2 - 12, 0, horPieceTextureY + 16, pieceW, 16);
            }
            int verLineStartY = scaledY + 9 - 4 + 16;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int verPieceTextureX = frameType == 0 ? 0 : (frameType == 1 ? 64 : 128);
            int verPieceHeight = 113;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / (double)verPieceHeight);
            for (int i = 0; i < vertLineLength; ++i) {
                int pieceY = scaledY + 9 - 4 + 16 + i * verPieceHeight;
                int pieceU = verPieceTextureX + 32 * (i & 1);
                int pieceH = verPieceHeight;
                if (i == vertLineLength - 1 && pieceY + pieceH > bottomCornerStartY) {
                    pieceH = bottomCornerStartY - pieceY;
                }
                helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, pieceY, pieceU, 97, 16, pieceH);
                helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 + mapSize / 2 - 12, pieceY, pieceU + 16, 97, 16, pieceH);
            }
            tessellator.func_78381_a();
        } else if (renderFrame) {
            int frameTextureY = frameType == 0 ? 210 : (frameType == 1 ? 214 : 218);
            double shadeStartAngle = 0.7853981633974483 - circleStartAngle;
            int shadeStartIndex = (int)(shadeStartAngle / 2.0 / Math.PI * (double)circleSides);
            int circleLeftX = scaledX + 9;
            int circleTopY = scaledY + 9;
            int innerCircleDiameter = mapSize / 2;
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, 0, shadeStartIndex, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, false, circleStartAngle, shadeStartIndex, shadeStartIndex + circleSides / 4, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, true, circleStartAngle, shadeStartIndex + circleSides / 4, shadeStartIndex + circleSides / 2, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, shadeStartIndex + circleSides / 2, circleSides, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f / minimapScale), (float)(1.0f / minimapScale), (float)1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        GlStateManager.func_179109_b((float)halfFrame, (float)halfFrame, (float)0.0f);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        boolean safeMode = this instanceof MinimapSafeModeRenderer;
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.func_175606_aa(), partial);
        double playerY = minimap.getEntityRadar().getEntityY(this.mc.func_175606_aa(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.func_175606_aa(), partial);
        double scaledZoom = this.zoom * (double)minimapScale / 2.0;
        if (!this.modMain.getSettings().compassOverEverything) {
            this.renderCompass(settings, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        double overMapFinalDepth = this.minimapInterface.getOverMapRendererHandler().render(this.mc.func_175606_aa(), (EntityPlayer)this.mc.field_71439_g, playerX, playerY, playerZ, ps, pc, scaledZoom, cave, partial, null, this.modMain, helper, this.mc.field_71466_p, scaledRes, specW, specH, halfFrame, halfFrame, circleShape, minimapScale);
        if (this.modMain.getSettings().compassOverEverything) {
            this.renderCompass(settings, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)overMapFinalDepth);
        GlStateManager.func_179147_l();
        boolean bl2 = crosshairDisplayed = settings.mainEntityAs == 0 && !lockedNorth;
        if (crosshairDisplayed) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179109_b((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            GlStateManager.func_179120_a((int)775, (int)0, (int)1, (int)0);
            this.getHelper().drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            MinimapRadar minimapRadar = minimap.getEntityRadar();
            EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), this.mc.func_175606_aa(), this.mc.field_71439_g);
            if (mainEntityCategory == null) {
                mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
            }
            int crosshairColor = minimapRadar.getEntityColour((EntityPlayer)this.mc.field_71439_g, this.mc.func_175606_aa(), 0.0f, false, mainEntityCategory, 100, 100, false, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
            GlStateManager.func_179131_c((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.getHelper().drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179121_F();
        }
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        double centerX = 2 * scaledX + 18 + mapSize / 2;
        double centerY = 2 * scaledY + 18 + mapSize / 2;
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179137_b((double)centerX, (double)centerY, (double)0.0);
        if (!safeMode && !crosshairDisplayed) {
            Entity mainEntity = this.mc.func_175606_aa();
            MinimapRadar radar = minimap.getEntityRadar();
            this.minimapInterface.getMinimapFBORenderer().renderMainEntityDot(minimap, (EntityPlayer)this.mc.field_71439_g, mainEntity, ps, pc, radar.getEntityX(mainEntity, partial), radar.getEntityZ(mainEntity, partial), partial, radar, lockedNorth, settings.getDotsStyle(), true, settings.debugEntityIcons, cave, settings.getDotNameScale(), settings, scaledRes, 2.0f);
        }
        GlStateManager.func_179147_l();
        if (lockedNorth || settings.mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            float arrowAngle = lockedNorth ? this.getEntityYaw(this.mc.func_175606_aa(), partial) : 180.0f;
            float arrowOpacity = (float)settings.playerArrowOpacity / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(arrowAngle, 0.0, 1.0, 0.0f, 0.0f, 0.0f, 0.5f, settings);
            }
            if (settings.arrowColour != -1) {
                float[] c = settings.arrowColours[settings.arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getTeamColour((Entity)this.mc.field_71439_g);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = settings.arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, 0.0, 0.0, r, g, b, a *= arrowOpacity, settings);
        }
        GL11.glPopMatrix();
        GlStateManager.func_179121_F();
        int depthClearerX = scaledX - 25;
        int depthClearerY = scaledY - 25;
        int depthClearerW = 18 + mapSize / 2 + 50;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-999.0f);
        Gui.func_73734_a((int)depthClearerX, (int)depthClearerY, (int)(depthClearerX + depthClearerW), (int)(depthClearerY + depthClearerW), (int)-16777216);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)999.0f);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        int playerBlockX = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70165_t);
        int playerBlockY = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70163_u);
        int playerBlockZ = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70161_v);
        if (settings.getShowCoords()) {
            int interfaceSize = size;
            String coords = playerBlockX + ", " + playerBlockY + ", " + playerBlockZ;
            if (this.mc.field_71466_p.func_78256_a(coords) >= interfaceSize) {
                String stringLevel = "" + playerBlockY;
                coords = playerBlockX + ", " + playerBlockZ;
                underText.add((ITextComponent)new TextComponentString(coords));
                underText.add((ITextComponent)new TextComponentString(stringLevel));
            } else {
                underText.add((ITextComponent)new TextComponentString(coords));
            }
        }
        BlockPos.MutableBlockPos pos = this.mutableBlockPos.func_181079_c(playerBlockX, playerBlockY, playerBlockZ);
        Chunk chunk = this.mc.field_71441_e.func_175726_f((BlockPos)pos);
        if (settings.showDimensionName) {
            int dimensionId = this.mc.field_71441_e.field_73011_w.getDimension();
            DimensionType dimensionType = this.mc.field_71441_e.field_73011_w.func_186058_p();
            if (dimensionType != null) {
                String dimensionName = String.format("%s (%d)", dimensionType.func_186065_b(), dimensionId);
                underText.add((ITextComponent)new TextComponentString(dimensionName));
            }
        }
        if (settings.showBiome) {
            Biome biome = chunk.func_177411_a((BlockPos)pos, this.mc.field_71441_e.func_72959_q());
            String biomeText = biome == null ? I18n.func_135052_a((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : biome.func_185359_l();
            this.addLineWordsUnderMinimap(underText, size, biomeText);
        }
        if (settings.showLightLevel > 0) {
            int skyLight;
            int blockLight;
            int n = blockLight = playerBlockY >= 0 && playerBlockY < 256 ? this.mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, (BlockPos)pos) : 0;
            int n2 = playerBlockY >= 256 ? 15 : (skyLight = playerBlockY < 0 ? 0 : this.mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, (BlockPos)pos));
            if (settings.showLightLevel == 1) {
                underText.add((ITextComponent)new TextComponentTranslation("gui.xaero_block_light_value", new Object[]{blockLight}));
            } else if (settings.showLightLevel == 2) {
                underText.add((ITextComponent)new TextComponentTranslation("gui.xaero_sky_light_value", new Object[]{skyLight}));
            } else if (settings.showLightLevel == 3) {
                underText.add((ITextComponent)new TextComponentTranslation("gui.xaero_all_light_value", new Object[]{Math.max(blockLight, skyLight)}));
            } else {
                underText.add((ITextComponent)new TextComponentTranslation("gui.xaero_both_light_value", new Object[]{blockLight, skyLight}));
            }
        }
        if (settings.showTime != 0) {
            long totalTime = 6000L + this.mc.field_71441_e.func_72820_D();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((settings.showTime - 1) % 2 == 0) {
                if (settings.showTime < 3) {
                    underText.add((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes)));
                } else {
                    underText.add((ITextComponent)new TextComponentString(String.format("%02d:%02d", timeHours, minutes)));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (settings.showTime < 3) {
                    underText.add((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half)));
                } else {
                    underText.add((ITextComponent)new TextComponentString(String.format("%02d:%02d %s", timeHours, minutes, half)));
                }
            }
        }
        if (minimap.getMinimapWriter().getDimensionHighlightHandler() != null) {
            minimap.getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(underText, playerBlockX, playerBlockZ, size, true);
        }
        if (minimap.getMinimapWriter().debugTotalTime) {
            underText.add((ITextComponent)new TextComponentString(String.format("Min Time %d", minimap.getMinimapWriter().minTimeDebug)));
            underText.add((ITextComponent)new TextComponentString(String.format("Average %d", minimap.getMinimapWriter().averageTimeDebug)));
            underText.add((ITextComponent)new TextComponentString(String.format("Max Time %d", minimap.getMinimapWriter().maxTimeDebug)));
        }
        if (settings.showAngles) {
            underText.add((ITextComponent)new TextComponentString(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)this.mc.func_175606_aa().field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)this.mc.func_175606_aa().field_70125_A)))));
        }
        if (settings.lightOverlayType > 0) {
            underText.add((ITextComponent)new TextComponentTranslation("gui.xaero_light_overlay_status", new Object[0]));
        }
        if (minimap.isManualCaveMode()) {
            this.addLineWordsUnderMinimap(underText, size, I18n.func_135052_a((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
        }
        if ((waypointsManager = minimapSession.getWaypointsManager()).getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
            this.addLineWordsUnderMinimap(underText, size, I18n.func_135052_a((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{waypointsManager.getCurrentWorld().getContainer().getSubName()}));
        }
        this.drawTextUnderMinimap(underText, scaledX, scaledY, height, size, mapScale, settings);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void renderCompass(ModSettings settings, int specW, int specH, int halfFrame, double ps, double pc, boolean circleShape, float minimapScale) {
        if (settings.compassLocation == 1) {
            halfFrame = (int)((float)halfFrame - 7.0f * minimapScale / 2.0f);
            int compassScale = (int)Math.ceil((float)settings.getCompassScale() * minimapScale / 2.0f);
            this.compassRenderer.drawCompass(this.getHelper(), halfFrame - 3 * compassScale, halfFrame - 3 * compassScale, ps, pc, 1.0, circleShape, compassScale, true);
        } else if (settings.compassLocation == 2) {
            this.compassRenderer.drawCompass(this.helper, specW, specH, ps, pc, this.zoom, circleShape, minimapScale, false);
        }
    }

    private void addLineWordsUnderMinimap(ArrayList<ITextComponent> underText, int size, String line) {
        if (this.mc.field_71466_p.func_78256_a(line) <= size) {
            underText.add((ITextComponent)new TextComponentString(line));
        } else {
            String[] words = line.split(" ");
            StringBuilder lineBuilder = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                int lineWidth;
                int wordStart = lineBuilder.length();
                if (i > 0) {
                    lineBuilder.append(' ');
                }
                lineBuilder.append(words[i]);
                if (i == 0 || (lineWidth = this.mc.field_71466_p.func_78256_a(lineBuilder.toString())) <= size) continue;
                lineBuilder.delete(wordStart, lineBuilder.length());
                underText.add((ITextComponent)new TextComponentString(lineBuilder.toString()));
                lineBuilder.delete(0, lineBuilder.length());
                lineBuilder.append(words[i]);
            }
            underText.add((ITextComponent)new TextComponentString(lineBuilder.toString()));
        }
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a, ModSettings settings) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)(0.5 * settings.arrowScale), (double)(0.5 * settings.arrowScale), (double)1.0);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        GL11.glTranslated((double)-13.0, (double)offsetY, (double)0.0);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        this.mc.field_71456_v.func_73729_b(0, 0, 49, ty, 26, h);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTextUnderMinimap(ArrayList<ITextComponent> underText, int scaledX, int scaledY, int height, int size, float mapScale, ModSettings settings) {
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        GlStateManager.func_179097_i();
        int align = settings.minimapTextAlign;
        for (int i = 0; i < underText.size(); ++i) {
            ITextComponent s = underText.get(i);
            String formattedS = s.func_150254_d();
            int stringWidth = this.mc.field_71466_p.func_78256_a(formattedS);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
            Minecraft.func_71410_x().field_71466_p.func_175063_a(formattedS, (float)stringX, (float)stringY, -1);
        }
        underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private float getSunBrightness() {
        return MathHelper.func_76131_a((float)this.mc.field_71441_e.getSunBrightnessFactor(1.0f), (float)0.0f, (float)1.0f);
    }

    public MinimapRendererHelper getHelper() {
        return this.helper;
    }
}

