/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.category.setting;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.client.resources.I18n;
import xaero.common.category.setting.ObjectCategorySetting;
import xaero.common.category.ui.setting.CategorySettingsUIEditorSettingType;
import xaero.common.graphics.CursorBox;
import xaero.common.minimap.radar.category.EntityRadarCategoryConstants;
import xaero.common.settings.ModSettings;

public class EntityRadarCategorySettings {
    public static final Map<String, ObjectCategorySetting<?>> SETTINGS = EntityRadarCategoryConstants.MAP_FACTORY.get();
    public static final List<ObjectCategorySetting<?>> SETTINGS_LIST = EntityRadarCategoryConstants.LIST_FACTORY.get();
    public static final ObjectCategorySetting<Boolean> DISPLAYED = ObjectCategorySetting.Builder.getDefault().setId("displayed").setDefaultValue(true).setDisplayName("gui.xaero_radar_displayed").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, String>(){

        @Override
        public String apply(Boolean v) {
            return ModSettings.getTranslation(v);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> COLOR = ObjectCategorySetting.Builder.getDefault().setId("color").setDefaultValue(13.0).setDisplayName("gui.xaero_radar_dots_color").setSettingUIType(CategorySettingsUIEditorSettingType.EXPANDING).setUiFirstOption(-1).setUiLastOption(15).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return x == -1.0 ? "# " + I18n.func_135052_a((String)"gui.xaero_radar_dots_color_team_colour", (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[x.intValue()] + "#\u00a7r " + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[x.intValue()], (Object[])new Object[0]);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> ICONS = ObjectCategorySetting.Builder.getDefault().setId("icons").setDefaultValue(1.0).setDisplayName("gui.xaero_radar_icons_displayed").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(2).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return I18n.func_135052_a((String)ModSettings.ENTITY_ICONS_OPTIONS[x.intValue()], (Object[])new Object[0]);
        }
    }).setTooltip(new CursorBox("gui.xaero_box_entity_radar_icons")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> NAMES = ObjectCategorySetting.Builder.getDefault().setId("names").setDefaultValue(0.0).setDisplayName("gui.xaero_radar_names_displayed").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(2).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return I18n.func_135052_a((String)ModSettings.ENTITY_NAMES_OPTIONS[x.intValue()], (Object[])new Object[0]);
        }
    }).setTooltip(new CursorBox("gui.xaero_box_entity_radar_names")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> DOT_SIZE = ObjectCategorySetting.Builder.getDefault().setId("dotSize").setDefaultValue(2.0).setDisplayName("gui.xaero_dots_size").setSettingUIType(CategorySettingsUIEditorSettingType.SLIDER).setUiFirstOption(1).setUiLastOption(4).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return x.intValue() + "";
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> ICON_SCALE = ObjectCategorySetting.Builder.getDefault().setId("iconScale").setDefaultValue(1.0).setDisplayName("gui.xaero_entity_heads_scale").setSettingUIType(CategorySettingsUIEditorSettingType.SLIDER).setUiFirstOption(5).setUiLastOption(40).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return (double)x * 0.05;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)(x / 0.05);
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return String.format("%.2f", x);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> HEIGHT_LIMIT = ObjectCategorySetting.Builder.getDefault().setId("heightLimit").setDefaultValue(20.0).setDisplayName("gui.xaero_height_limit").setSettingUIType(CategorySettingsUIEditorSettingType.SLIDER).setUiFirstOption(2).setUiLastOption(410).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return (double)x * 5.0;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)(x / 5.0);
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return x.intValue() + "";
        }
    }).setTooltip(new CursorBox("gui.xaero_box_height_limit")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Boolean> HEIGHT_FADE = ObjectCategorySetting.Builder.getDefault().setId("heightBasedFade").setDefaultValue(true).setDisplayName("gui.xaero_entity_depth").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, String>(){

        @Override
        public String apply(Boolean v) {
            return ModSettings.getTranslation(v);
        }
    }).setTooltip(new CursorBox("gui.xaero_box_entity_depth")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Boolean> DISPLAY_Y = ObjectCategorySetting.Builder.getDefault().setId("displayY").setDefaultValue(false).setDisplayName("gui.xaero_entity_display_y").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, String>(){

        @Override
        public String apply(Boolean v) {
            return ModSettings.getTranslation(v);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> START_FADING_AT = ObjectCategorySetting.Builder.getDefault().setId("startFadingAt").setDefaultValue(0.0).setDisplayName("gui.xaero_start_fading_at").setSettingUIType(CategorySettingsUIEditorSettingType.SLIDER).setUiFirstOption(0).setUiLastOption(256).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)x.doubleValue();
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return x.intValue() == 0 ? I18n.func_135052_a((String)"gui.xaero_start_fading_at_auto", (Object[])new Object[0]) : x.intValue() + "";
        }
    }).setTooltip(new CursorBox("gui.xaero_box_start_fading_at")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> ENTITY_NUMBER = ObjectCategorySetting.Builder.getDefault().setId("entityNumber").setDefaultValue(1000.0).setDisplayName("gui.xaero_entity_amount").setSettingUIType(CategorySettingsUIEditorSettingType.SLIDER).setUiFirstOption(0).setUiLastOption(10).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return (double)x * 100.0;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)(x / 100.0);
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return x.intValue() == 0 ? I18n.func_135052_a((String)"gui.xaero_unlimited", (Object[])new Object[0]) : x.intValue() + "";
        }
    }).setTooltip(new CursorBox("gui.xaero_box_entity_amount")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Boolean> ALWAYS_NAMETAGS = ObjectCategorySetting.Builder.getDefault().setId("alwaysDisplayNametags").setDefaultValue(false).setDisplayName("gui.xaero_always_entity_nametags").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, String>(){

        @Override
        public String apply(Boolean v) {
            return ModSettings.getTranslation(v);
        }
    }).setTooltip(new CursorBox("gui.xaero_box_always_entity_nametags2")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Boolean> ICON_NAME_FALLBACK = ObjectCategorySetting.Builder.getDefault().setId("displayNameWhenIconFails").setDefaultValue(true).setDisplayName("gui.xaero_entity_icon_name_fallback").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, String>(){

        @Override
        public String apply(Boolean v) {
            return ModSettings.getTranslation(v);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> RENDER_OVER_MINIMAP = ObjectCategorySetting.Builder.getDefault().setId("renderOverMinimapFrame").setDefaultValue(1.0).setDisplayName("gui.xaero_radar_render_over_minimap").setSettingUIType(CategorySettingsUIEditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(2).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return I18n.func_135052_a((String)ModSettings.RADAR_OVER_MAP_OPTIONS[x.intValue()], (Object[])new Object[0]);
        }
    }).setTooltip(new CursorBox("gui.xaero_box_radar_render_over_minimap")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> RENDER_ORDER = ObjectCategorySetting.Builder.getDefault().setId("renderOrder").setDefaultValue(0.0).setDisplayName("gui.xaero_radar_render_order").setSettingUIType(CategorySettingsUIEditorSettingType.SLIDER).setUiFirstOption(0).setUiLastOption(1000).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, String>(){

        @Override
        public String apply(Double x) {
            return x.intValue() + "";
        }
    }).setTooltip(new CursorBox("gui.xaero_box_radar_render_order")).build(SETTINGS, SETTINGS_LIST);
}

