/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.controls;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class ControlsHandler {
    protected IXaeroMinimap modMain;
    protected XaeroMinimapSession minimapSession;
    protected WaypointsManager waypointsManager;
    protected MinimapProcessor minimap;

    public ControlsHandler(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.minimap = minimapSession.getMinimapProcessor();
    }

    public void setKeyState(KeyBinding kb, boolean pressed) {
        KeyBinding.func_74510_a((int)kb.func_151463_i(), (boolean)pressed);
    }

    public boolean isDown(KeyBinding kb) {
        return GameSettings.func_100015_a((KeyBinding)kb);
    }

    public void keyDownPre(KeyBinding kb) {
    }

    public void keyDownPost(KeyBinding kb) {
    }

    public void keyDown(KeyBinding kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!tickEnd) {
            WaypointWorld currentWorld;
            GuiScreen currentEscScreen;
            GuiScreen current;
            this.keyDownPre(kb);
            if (kb == ModSettings.newWaypoint && this.modMain.getSettings().waypointsGUI(this.waypointsManager)) {
                mc.func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, this.waypointsManager, null, new ArrayList<Waypoint>(), this.waypointsManager.getCurrentContainerID().split("/")[0], this.waypointsManager.getCurrentWorld(), true));
            }
            if (kb == ModSettings.keyWaypoints && this.modMain.getSettings().waypointsGUI(this.waypointsManager)) {
                current = mc.field_71462_r;
                currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                mc.func_147108_a((GuiScreen)new GuiWaypoints(this.modMain, this.minimapSession, current, currentEscScreen));
            }
            if (kb == ModSettings.keyLargeMap) {
                this.minimapSession.getMinimapProcessor().setEnlargedMap(this.modMain.getSettings().enlargedMinimapAToggle ? !this.minimapSession.getMinimapProcessor().isEnlargedMap() : true);
                this.minimap.setToResetImage(true);
                this.minimap.instantZoom();
            }
            if (kb == ModSettings.keyToggleMap && !mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP) && !mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP_HARMFUL)) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.MINIMAP, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleWaypoints) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.INGAME_WAYPOINTS, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleMapWaypoints) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.WAYPOINTS, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleSlimes) {
                try {
                    if (this.modMain.getSettings().customSlimeSeedNeeded(this.minimapSession) && this.modMain.getSettings().getBooleanValue(ModOptions.OPEN_SLIME_SETTINGS)) {
                        current = mc.field_71462_r;
                        currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSlimeSeed(this.modMain, this.waypointsManager, current, currentEscScreen));
                    } else {
                        this.modMain.getSettings().slimeChunks = !this.modMain.getSettings().slimeChunks;
                        this.modMain.getSettings().saveSettings();
                    }
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleGrid) {
                try {
                    this.modMain.getSettings().chunkGrid = -this.modMain.getSettings().chunkGrid - 1;
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyInstantWaypoint && !mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) && !mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL)) {
                this.waypointsManager.createTemporaryWaypoints(this.waypointsManager.getCurrentWorld(), OptimizedMath.myFloor(mc.field_71439_g.field_70165_t), OptimizedMath.myFloor(mc.field_71439_g.field_70163_u), OptimizedMath.myFloor(mc.field_71439_g.field_70161_v));
            }
            if (kb == ModSettings.keySwitchSet && (currentWorld = this.waypointsManager.getCurrentWorld()) != null) {
                String[] keys = currentWorld.getSets().keySet().toArray(new String[0]);
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null || !keys[i].equals(currentWorld.getCurrent())) continue;
                    currentWorld.setCurrent(keys[(i + 1) % keys.length]);
                    break;
                }
                this.waypointsManager.updateWaypoints();
                this.waypointsManager.setChanged = System.currentTimeMillis();
                try {
                    this.modMain.getSettings().saveWaypoints(currentWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyAllSets) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.WAYPOINTS_ALL_SETS, 0);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyLightOverlay) {
                this.modMain.getSettings().lightOverlayType = this.modMain.getSettings().lightOverlayType == 0 ? 1 : (this.modMain.getSettings().lightOverlayType *= -1);
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (!this.minimapSession.getMinimapProcessor().isEnlargedMap() || !this.modMain.getSettings().zoomedOutEnlarged) {
                if (kb == ModSettings.keyBindZoom) {
                    try {
                        this.modMain.getSettings().setOptionValue(ModOptions.ZOOM, 1);
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
                if (kb == ModSettings.keyBindZoom1) {
                    this.modMain.getSettings().changeZoom(-1);
                    try {
                        this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            }
            if (kb == ModSettings.keyToggleRadar) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.RADAR_DISPLAYED, 0);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyManualCaveMode) {
                this.minimapSession.getMinimapProcessor().toggleManualCaveMode();
            }
            this.keyDownPost(kb);
        }
    }

    public void keyUpPre(KeyBinding kb) {
    }

    public void keyUpPost(KeyBinding kb) {
    }

    public void keyUp(KeyBinding kb, boolean tickEnd) {
        if (!tickEnd) {
            this.keyUpPre(kb);
            if (!this.modMain.getSettings().enlargedMinimapAToggle && kb == ModSettings.keyLargeMap) {
                this.minimapSession.getMinimapProcessor().setEnlargedMap(false);
                this.minimap.setToResetImage(true);
                this.minimap.instantZoom();
            }
            this.keyUpPost(kb);
        }
    }
}

