/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import de.maxhenkel.camera.entities.EntityImage;
import de.maxhenkel.camera.gui.ContainerResizeFrame;
import de.maxhenkel.camera.net.MessageResizeFrame;
import de.maxhenkel.camera.proxy.CommonProxy;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiResizeFrame
extends GuiContainer {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/camera.png");
    private static final int FONT_COLOR = 0x404040;
    private UUID uuid;
    private long lastCheck;

    public GuiResizeFrame(UUID uuid) {
        super((Container)new ContainerResizeFrame());
        this.uuid = uuid;
        this.field_146999_f = 248;
        this.field_147000_g = 109;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int padding = 10;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.func_189646_b(new GuiButton(0, left + padding, this.field_146295_m / 2 - buttonHeight / 2, buttonWidth, buttonHeight, new TextComponentTranslation("button.frame.left", new Object[0]).func_150254_d()));
        this.func_189646_b(new GuiButton(1, left + this.field_146999_f - buttonWidth - padding, this.field_146295_m / 2 - buttonHeight / 2, buttonWidth, buttonHeight, new TextComponentTranslation("button.frame.right", new Object[0]).func_150254_d()));
        this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 - buttonWidth / 2, this.field_147009_r + padding, buttonWidth, buttonHeight, new TextComponentTranslation("button.frame.up", new Object[0]).func_150254_d()));
        this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 - buttonWidth / 2, this.field_147009_r + this.field_147000_g - padding - buttonHeight, buttonWidth, buttonHeight, new TextComponentTranslation("button.frame.down", new Object[0]).func_150254_d()));
    }

    private void sendMoveImage(MessageResizeFrame.Direction direction) {
        CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageResizeFrame(this.uuid, direction, !GuiScreen.func_146272_n()));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.sendMoveImage(MessageResizeFrame.Direction.LEFT);
        } else if (button.field_146127_k == 1) {
            this.sendMoveImage(MessageResizeFrame.Direction.RIGHT);
        } else if (button.field_146127_k == 2) {
            this.sendMoveImage(MessageResizeFrame.Direction.UP);
        } else if (button.field_146127_k == 3) {
            this.sendMoveImage(MessageResizeFrame.Direction.DOWN);
        }
        super.func_146284_a(button);
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        String title = new TextComponentTranslation("gui.frame.resize", new Object[0]).func_150254_d();
        int titleWidth = this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - titleWidth / 2, this.field_147000_g / 2 - this.field_146289_q.field_78288_b / 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CAMERA_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (System.currentTimeMillis() - this.lastCheck > 500L) {
            if (!this.isImagePresent()) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public boolean isImagePresent() {
        return this.field_146297_k.field_71439_g.field_70170_p.func_175644_a(EntityImage.class, image -> image.func_110124_au().equals(this.uuid)).size() > 0;
    }
}

