/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.net.MessageRequestImage;
import de.maxhenkel.camera.proxy.CommonProxy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureCache {
    private Map<UUID, CameraTextureObject> clientImageCache = new HashMap<UUID, CameraTextureObject>();
    private Map<UUID, ResourceLocation> clientResourceCache = new HashMap<UUID, ResourceLocation>();
    private Map<UUID, Long> awaitingImages = new HashMap<UUID, Long>();
    public static TextureCache instance;

    public void addImage(UUID uuid, BufferedImage image) {
        if (this.awaitingImages.containsKey(uuid)) {
            this.awaitingImages.remove(uuid);
        }
        ResourceLocation resourceLocation = new ResourceLocation("camera", "textures/camera/" + uuid.toString());
        CameraTextureObject cameraTextureObject = new CameraTextureObject(resourceLocation, image);
        this.clientImageCache.put(uuid, cameraTextureObject);
        this.clientResourceCache.put(uuid, resourceLocation);
        Minecraft.func_71410_x().field_71446_o.func_110579_a(resourceLocation, (ITextureObject)cameraTextureObject);
    }

    public ResourceLocation getImage(UUID uuid) {
        CameraTextureObject cameraTextureObject = this.clientImageCache.get(uuid);
        if (cameraTextureObject == null) {
            if (this.awaitingImages.containsKey(uuid) && this.awaitingImages.get(uuid) + 10000L > System.currentTimeMillis()) {
                return null;
            }
            this.awaitingImages.put(uuid, System.currentTimeMillis());
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageRequestImage(uuid));
            return null;
        }
        return this.clientResourceCache.get(uuid);
    }

    public BufferedImage getBufferedImage(UUID uuid) {
        CameraTextureObject cameraTextureObject = this.clientImageCache.get(uuid);
        if (cameraTextureObject == null) {
            if (this.awaitingImages.containsKey(uuid) && this.awaitingImages.get(uuid) + 10000L > System.currentTimeMillis()) {
                return null;
            }
            this.awaitingImages.put(uuid, System.currentTimeMillis());
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageRequestImage(uuid));
            return null;
        }
        return cameraTextureObject.image;
    }

    public static TextureCache instance() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    public class CameraTextureObject
    extends SimpleTexture {
        private BufferedImage image;

        public CameraTextureObject(ResourceLocation textureResourceLocation, BufferedImage image) {
            super(textureResourceLocation);
            this.image = image;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.image);
        }
    }
}

