/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays;

import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.FactorLimit;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayDynamicPosition
extends FactorLimit.Ray {
    public Type type;

    public RayDynamicPosition() {
        this(null, Type.BEDROCK);
    }

    public RayDynamicPosition(Float weight, Type type) {
        super(weight);
        this.type = type;
    }

    @Override
    public OptionalInt cast(WorldCache cache, StructurePlaceContext context, IvBlockCollection collection, Set<BlockPos> surface, int y) {
        switch (this.type) {
            case BEDROCK: {
                return OptionalInt.of(0);
            }
            case SEALEVEL: {
                return OptionalInt.of(cache.world.func_181545_F());
            }
            case WORLD_HEIGHT: {
                return OptionalInt.of(cache.world.func_72800_K() - 1 - collection.height);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String displayString() {
        return String.format("%s %s", RayDynamicPosition.directionArrow(null), IvTranslations.get("reccomplex.placer.factors.limit.rays.dynpos.type." + IvGsonHelper.serializedName(this.type)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceSegmented(this.rayTableDataSource(navigator, delegate), new TableDataSourceSupplied(() -> {
            TableCellEnum<Type> cell = new TableCellEnum<Type>(null, this.type, TableCellEnum.options((Enum[])Type.values(), (String)"reccomplex.placer.factors.limit.rays.dynpos.type.", (boolean)true));
            cell.addListener(v -> {
                this.type = v;
            });
            return new TitledCell(IvTranslations.get("reccomplex.placer.factors.limit.rays.dynpos.type"), cell);
        }));
    }

    public static enum Type {
        BEDROCK,
        SEALEVEL,
        WORLD_HEIGHT;

    }
}

