/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.maze;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePassages;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.Connector;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazeComponent;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazePath;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazePaths;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SavedMazeReachability
implements NBTCompoundObject {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
    public final List<Set<SavedMazePath>> groups = new ArrayList<Set<SavedMazePath>>();
    public final List<ImmutablePair<SavedMazePath, SavedMazePath>> crossConnections = new ArrayList<ImmutablePair<SavedMazePath, SavedMazePath>>();
    public boolean groupByDefault = true;

    public <T extends Map.Entry<SavedMazePath, SavedMazePath>> SavedMazeReachability(List<Set<SavedMazePath>> groups2, List<T> crossConnections, boolean groupByDefault) {
        this.set(groups2, crossConnections, groupByDefault);
    }

    public SavedMazeReachability() {
    }

    public static Predicate<MazePassage> notBlocked(Collection<Connector> blockedConnections, Map<MazePassage, Connector> connections) {
        return input -> !blockedConnections.contains(connections.get(input));
    }

    public static Set<SavedMazePath> buildExpected(SavedMazeComponent savedMazeComponent) {
        HashSet complete = Sets.newHashSet((Iterable)savedMazeComponent.exitPaths.stream().map(input -> input.path).collect(Collectors.toList()));
        SavedMazeReachability.completeExitPaths(complete, savedMazeComponent.rooms);
        return complete;
    }

    public static void completeExitPaths(Set<SavedMazePath> exits, Selection rooms) {
        Set<MazeRoom> roomSet = rooms.compile(true).keySet();
        for (MazeRoom room : roomSet) {
            SavedMazePaths.neighborPaths(room).filter(connection -> !exits.contains(connection) && (!roomSet.contains(connection.getSourceRoom()) || !roomSet.contains(connection.getDestRoom()))).forEach(exits::add);
        }
    }

    public void set(SavedMazeReachability reachability) {
        this.set(reachability.groups, reachability.crossConnections, reachability.groupByDefault);
    }

    public <T extends Map.Entry<SavedMazePath, SavedMazePath>> void set(List<Set<SavedMazePath>> groups2, List<T> crossConnections, boolean groupByDefault) {
        this.groups.clear();
        for (Set<SavedMazePath> group : groups2) {
            this.groups.add(Sets.newHashSet((Iterable)group.stream().map(SavedMazePath::copy).collect(Collectors.toList())));
        }
        this.crossConnections.clear();
        for (Map.Entry entry : crossConnections) {
            this.crossConnections.add((ImmutablePair<SavedMazePath, SavedMazePath>)ImmutablePair.of((Object)((SavedMazePath)entry.getKey()).copy(), (Object)((SavedMazePath)entry.getValue()).copy()));
        }
        this.groupByDefault = groupByDefault;
    }

    public ImmutableMultimap.Builder<MazePassage, MazePassage> build(ImmutableMultimap.Builder<MazePassage, MazePassage> builder, AxisAlignedTransform2D transform, int[] size, Predicate<MazePassage> filter, Set<MazePassage> connections) {
        filter = ((Predicate<MazePassage>)connections::contains).and(filter);
        HashSet defaultGroup = Sets.newHashSet(connections);
        for (Set<SavedMazePath> set : this.groups) {
            List mazePassages = set.stream().map(savedMazePath -> MazePassages.rotated(savedMazePath.build(), transform, size)).filter(filter).collect(Collectors.toList());
            defaultGroup.removeAll(mazePassages);
            this.addInterconnections(builder, mazePassages.stream());
        }
        if (this.groupByDefault) {
            this.addInterconnections(builder, defaultGroup.stream().filter(filter));
        }
        for (Map.Entry entry : this.crossConnections) {
            MazePassage key = MazePassages.rotated(((SavedMazePath)entry.getKey()).build(), transform, size);
            MazePassage val = MazePassages.rotated(((SavedMazePath)entry.getValue()).build(), transform, size);
            if (!filter.test(key) || !filter.test(val)) continue;
            builder.put((Object)key, (Object)val);
        }
        return builder;
    }

    protected void addInterconnections(ImmutableMultimap.Builder<MazePassage, MazePassage> builder, Stream<MazePassage> existing) {
        existing.reduce((last, current) -> {
            if (last != null) {
                builder.put((Object)last, (Object)current);
                builder.put((Object)current, (Object)last);
            }
            return current;
        });
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.groups.clear();
        this.groups.addAll(Lists.transform(NBTTagLists.listsFrom(compound, "groups"), input -> Sets.newHashSet(NBTCompoundObjects.readList(input, SavedMazePath::new))));
        this.crossConnections.clear();
        this.crossConnections.addAll(Lists.transform(NBTTagLists.compoundsFrom(compound, "crossConnections"), input -> ImmutablePair.of((Object)NBTCompoundObjects.readFrom(input, "key", SavedMazePath::new), (Object)NBTCompoundObjects.readFrom(input, "val", SavedMazePath::new))));
        this.groupByDefault = compound.func_74767_n("groupByDefault");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagLists.writeTo(compound, "groups", Lists.transform(this.groups, NBTCompoundObjects::writeList));
        NBTTagLists.writeTo(compound, "crossConnections", Lists.transform(this.crossConnections, input -> {
            NBTTagCompound compound1 = new NBTTagCompound();
            NBTCompoundObjects.writeTo(compound1, "key", (NBTCompoundObject)input.getKey());
            NBTCompoundObjects.writeTo(compound1, "val", (NBTCompoundObject)input.getValue());
            return compound1;
        }));
        compound.func_74757_a("groupByDefault", this.groupByDefault);
    }

    public static class Serializer
    implements JsonSerializer<SavedMazeReachability>,
    JsonDeserializer<SavedMazeReachability> {
        public SavedMazeReachability deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List crossConnections;
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "MazeReachability");
            List<Set<SavedMazePath>> groups2 = (List<Set<SavedMazePath>>)context.deserialize(jsonObject.get("groups"), new TypeToken<List<Set<SavedMazePath>>>(){}.getType());
            if (groups2 == null) {
                groups2 = Collections.emptyList();
            }
            if ((crossConnections = (List)gson.fromJson((JsonElement)JsonUtils.getJsonArray(jsonObject, "crossConnections", new JsonArray()), new TypeToken<List<ImmutablePair<SavedMazePath, SavedMazePath>>>(){}.getType())) == null) {
                crossConnections = Collections.emptyList();
            }
            boolean groupByDefault = JsonUtils.getBoolean(jsonObject, "groupByDefault", true);
            return new SavedMazeReachability(groups2, crossConnections, groupByDefault);
        }

        public JsonElement serialize(SavedMazeReachability src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("groups", context.serialize(src.groups));
            jsonObject.add("crossConnections", gson.toJsonTree(src.crossConnections));
            jsonObject.addProperty("groupByDefault", Boolean.valueOf(src.groupByDefault));
            return jsonObject;
        }
    }
}

