/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.blocks.IvMutableBlockPos;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.transform.Mover;
import ivorius.ivtoolkit.transform.PosTransformer;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NBTToJson;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.temp.RCMover;
import ivorius.reccomplex.temp.RCPosTransformer;
import ivorius.reccomplex.utils.ItemHandlers;
import ivorius.reccomplex.utils.RCStructureBoundingBoxes;
import ivorius.reccomplex.utils.accessor.RCAccessorEntity;
import ivorius.reccomplex.utils.accessor.RCAccessorWorldServer;
import ivorius.reccomplex.utils.expression.DependencyExpression;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.VariableDomain;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLiveContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericVariableDomain;
import ivorius.reccomplex.world.gen.feature.structure.generic.Metadata;
import ivorius.reccomplex.world.gen.feature.structure.generic.StructureSaveHandler;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerGenerationBehavior;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerMulti;
import ivorius.reccomplex.world.storage.loot.LootGenerationHandler;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;

public class GenericStructure
implements Structure<InstanceData>,
Cloneable {
    public static final int LATEST_VERSION = 3;
    public static final int MAX_GENERATING_LAYERS = 30;
    public final List<GenerationType> generationTypes = new ArrayList<GenerationType>();
    public TransformerMulti transformer = new TransformerMulti();
    public final DependencyExpression dependencies = new DependencyExpression();
    public NBTTagCompound worldDataCompound;
    public boolean rotatable;
    public boolean mirrorable;
    public boolean blocking;
    public GenericVariableDomain variableDomain = new GenericVariableDomain();
    public Metadata metadata = new Metadata();
    public JsonObject customData;

    public static GenericStructure createDefaultStructure() {
        GenericStructure genericStructureInfo = new GenericStructure();
        genericStructureInfo.rotatable = true;
        genericStructureInfo.mirrorable = true;
        genericStructureInfo.blocking = true;
        genericStructureInfo.transformer.getData().setPreset("structure");
        genericStructureInfo.generationTypes.add(new NaturalGeneration());
        return genericStructureInfo;
    }

    private static double[] getEntityPos(NBTTagCompound compound) {
        NBTTagList pos = compound.func_150295_c("Pos", 6);
        return new double[]{pos.func_150309_d(0), pos.func_150309_d(1), pos.func_150309_d(2)};
    }

    public static void setBlock(@Nonnull StructureSpawnContext context, int[] areaSize, @Nonnull BlockPos worldPos, @Nonnull IBlockState state, @Nonnull Supplier<NBTTagCompound> tileEntity) {
        TileEntity worldTileEntity;
        NBTTagCompound tileEntityCompound;
        WorldServer world = context.environment.world;
        if (context.setBlock(worldPos, state, 2) && (tileEntityCompound = tileEntity.get()) != null && world.func_180495_p(worldPos).func_177230_c() == state.func_177230_c() && (worldTileEntity = world.func_175625_s(worldPos)) != null) {
            tileEntityCompound = RCMover.setTileEntityPos(tileEntityCompound, worldPos);
            worldTileEntity.func_145839_a(tileEntityCompound);
            RCPosTransformer.transformAdditionalData(worldTileEntity, context.transform, areaSize);
            RCMover.setAdditionalDataPos(worldTileEntity, worldPos);
            GenericStructure.generateTileEntityContents(context, worldTileEntity);
        }
    }

    public static void generateEntityContents(@Nonnull StructureSpawnContext context, Entity entity) {
        if (!context.generateAsSource && ItemHandlers.hasModifiable((ICapabilityProvider)entity, null)) {
            LootGenerationHandler.generateAllTags(context, ItemHandlers.getModifiable((ICapabilityProvider)entity, null));
        }
    }

    public static void generateTileEntityContents(@Nonnull StructureSpawnContext context, TileEntity tileEntity) {
        if (!context.generateAsSource && ItemHandlers.hasModifiable((ICapabilityProvider)tileEntity, null)) {
            LootGenerationHandler.generateAllTags(context, ItemHandlers.getModifiable((ICapabilityProvider)tileEntity, null));
        }
    }

    @Override
    @Nonnull
    public int[] size() {
        return Structures.size(this.worldDataCompound, new int[]{0, 0, 0});
    }

    @Override
    public boolean isRotatable() {
        return this.rotatable;
    }

    @Override
    public boolean isMirrorable() {
        return this.mirrorable;
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public void generate(@Nonnull StructureSpawnContext context, @Nonnull InstanceData instanceData, @Nonnull TransformerMulti foreignTransformer) {
        StructureBoundingBox relevantSourceArea;
        WorldServer world = context.environment.world;
        IvWorldData worldData = this.constructWorldData();
        boolean asSource = context.generateAsSource;
        RunTransformer transformer = this.getRunTransformer(instanceData, foreignTransformer, asSource);
        instanceData.variableDomain.fill(context.environment.variables);
        RCAccessorWorldServer.ensureBlockEventArray(world);
        IvBlockCollection blockCollection = worldData.blockCollection;
        int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
        BlockPos origin = StructureBoundingBoxes.min(context.boundingBox);
        HashMap<BlockPos, NBTTagCompound> tileEntityCompounds = new HashMap<BlockPos, NBTTagCompound>();
        for (NBTTagCompound tileEntityCompound : worldData.tileEntities) {
            BlockPos src = RCMover.getTileEntityPos(tileEntityCompound);
            tileEntityCompounds.put(src, tileEntityCompound);
        }
        if (transformer != null) {
            transformer.transformer.transform(transformer.instanceData, Transformer.Phase.BEFORE, context, worldData, transformer);
        }
        if ((relevantSourceArea = context.sourceIntersection(BlockAreas.toBoundingBox(blockCollection.area()))) != null) {
            context.freezeHeightMap(relevantSourceArea);
            BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
            for (int pass = 0; pass < 2; ++pass) {
                for (BlockPos blockPos : RCStructureBoundingBoxes.mutablePositions(relevantSourceArea)) {
                    IBlockState state;
                    IvMutableBlockPos.add(context.transform.applyOn(blockPos, worldPos, areaSize), origin);
                    if (!context.includesComplex((Vec3i)worldPos) || pass != this.getPass(state = PosTransformer.transformBlockState(blockCollection.getBlockState(blockPos), context.transform)) || transformer != null && transformer.transformer.skipGeneration(transformer.instanceData, (StructureLiveContext)context, (BlockPos)worldPos, state, worldData, blockPos)) continue;
                    GenericStructure.setBlock(context, areaSize, (BlockPos)worldPos, state, () -> (NBTTagCompound)tileEntityCompounds.get(sourcePos));
                }
            }
            context.meltHeightMap();
        }
        if (transformer != null) {
            transformer.transformer.transform(transformer.instanceData, Transformer.Phase.AFTER, context, worldData, transformer);
        }
        for (NBTTagCompound entityCompound : worldData.entities) {
            double[] transformedEntityPos = context.transform.applyOn(GenericStructure.getEntityPos(entityCompound), areaSize);
            if (!context.includes(new Vec3i(transformedEntityPos[0] + (double)origin.func_177958_n(), transformedEntityPos[1] + (double)origin.func_177956_o(), transformedEntityPos[2] + (double)origin.func_177952_p()))) continue;
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityCompound, (World)world);
            if (entity != null) {
                PosTransformer.transformEntityPos(entity, context.transform, areaSize);
                Mover.moveEntity(entity, origin);
                RCAccessorEntity.setEntityUniqueID(entity, UUID.randomUUID());
                GenericStructure.generateEntityContents(context, entity);
                world.func_72838_d(entity);
                continue;
            }
            RecurrentComplex.logger.error("Error loading entity with ID '" + entityCompound.func_74779_i("id") + "'");
        }
    }

    @Nullable
    public RunTransformer getRunTransformer(@Nonnull InstanceData instanceData, @Nonnull TransformerMulti foreignTransformer, boolean asSource) {
        if (asSource) {
            return null;
        }
        if (instanceData.transformerData == null || instanceData.foreignTransformerData == null) {
            throw new IllegalStateException();
        }
        TransformerGenerationBehavior transformerGenerationBehavior = new TransformerGenerationBehavior();
        TransformerMulti fused = TransformerMulti.fuse(Arrays.asList(transformerGenerationBehavior, this.transformer, foreignTransformer));
        fused.setID("FusedStructureTransformer");
        return new RunTransformer(fused, fused.fuseDatas(Arrays.asList(instanceData.transformerGenerationBehavior, instanceData.transformerData, instanceData.foreignTransformerData)));
    }

    @Override
    @Nullable
    public InstanceData prepareInstanceData(@Nonnull StructurePrepareContext context, @Nonnull TransformerMulti foreignTransformer) {
        InstanceData instanceData = new InstanceData();
        if (!context.generateAsSource) {
            IvWorldData worldData = this.constructWorldData();
            context.environment.variables.fill(instanceData.variableDomain);
            this.variableDomain.fill(instanceData.variableDomain, context.environment, context.random);
            TransformerGenerationBehavior transformerGenerationBehavior = new TransformerGenerationBehavior();
            TransformerMulti fused = TransformerMulti.fuse(Arrays.asList(transformerGenerationBehavior, this.transformer, foreignTransformer));
            TransformerMulti.InstanceData fusedDatas = fused.prepareInstanceData(context, worldData);
            instanceData.transformerGenerationBehavior = (TransformerGenerationBehavior.InstanceData)fusedDatas.pairedTransformers.stream().filter(t -> t.getLeft() instanceof TransformerGenerationBehavior).map(Pair::getRight).findFirst().get();
            instanceData.transformerData = (TransformerMulti.InstanceData)fusedDatas.pairedTransformers.stream().filter(t -> t.getLeft() == this.transformer).map(Pair::getRight).findFirst().get();
            instanceData.foreignTransformerData = (TransformerMulti.InstanceData)fusedDatas.pairedTransformers.stream().filter(t -> t.getLeft() == foreignTransformer).map(Pair::getRight).findFirst().get();
            if (context.generateMaturity.isSuggest() && !fused.mayGenerate(fusedDatas, context, worldData)) {
                return null;
            }
            RunTransformer runTransformer = new RunTransformer(fused, fusedDatas);
            fused.configureInstanceData(fusedDatas, context, worldData, runTransformer);
        }
        return instanceData;
    }

    @Override
    @Nonnull
    public InstanceData loadInstanceData(@Nonnull StructureLoadContext context, @Nonnull NBTBase nbt, @Nonnull TransformerMulti transformer) {
        InstanceData instanceData = new InstanceData();
        instanceData.readFromNBT(context, nbt, this.transformer, transformer, this.constructWorldData());
        return instanceData;
    }

    public IvWorldData constructWorldData() {
        return new IvWorldData(this.worldDataCompound, RecurrentComplex.specialRegistry.itemHidingMode());
    }

    @Override
    @Nonnull
    public <I extends GenerationType> List<I> generationTypes(@Nonnull Class<? extends I> clazz) {
        return this.generationTypes.stream().filter(info -> clazz.isAssignableFrom(info.getClass())).map(info -> info).collect(Collectors.toList());
    }

    @Override
    public GenerationType generationType(@Nonnull String id) {
        for (GenerationType info : this.generationTypes) {
            if (!Objects.equals(info.id(), id)) continue;
            return info;
        }
        return null;
    }

    private int getPass(IBlockState state) {
        return state.func_185915_l() || state.func_185904_a() == Material.field_151579_a ? 0 : 1;
    }

    @Override
    @Nonnull
    public GenericStructure copyAsGenericStructure() {
        return this.copy();
    }

    @Override
    public boolean areDependenciesResolved() {
        return this.dependencies.test(RecurrentComplex.saver);
    }

    @Override
    @Nullable
    public IvBlockCollection blockCollection() {
        return this.constructWorldData().blockCollection;
    }

    @Override
    @Nonnull
    public GenericVariableDomain declaredVariables() {
        return this.variableDomain;
    }

    public String toString() {
        String s = StructureRegistry.INSTANCE.id(this);
        return s != null ? s : "Generic Structure";
    }

    @Override
    public List<TextComponentBase> instanceDataInfo(InstanceData instanceData) {
        if (!instanceData.variableDomain.all().isEmpty()) {
            return Collections.singletonList(new TextComponentString(instanceData.variableDomain.all().toString()));
        }
        return Collections.emptyList();
    }

    public GenericStructure copy() {
        return StructureSaveHandler.INSTANCE.fromJSON(StructureSaveHandler.INSTANCE.toJSON(this), this.worldDataCompound.func_74737_b());
    }

    public static class InstanceData
    implements NBTStorable {
        public static final String KEY_TRANSFORMER = "transformer";
        public static final String KEY_FOREIGN_TRANSFORMER = "foreignTransformer";
        public final VariableDomain variableDomain = new VariableDomain();
        public TransformerMulti.InstanceData transformerData;
        public TransformerMulti.InstanceData foreignTransformerData;
        public TransformerGenerationBehavior.InstanceData transformerGenerationBehavior = new TransformerGenerationBehavior.InstanceData();

        public void readFromNBT(StructureLoadContext context, NBTBase nbt, TransformerMulti transformer, @Nonnull TransformerMulti foreignTransformer, IvWorldData worldData) {
            NBTTagCompound compound = nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound();
            this.variableDomain.readFromNBT(compound.func_74775_l("variables"));
            if (compound.func_74764_b(KEY_TRANSFORMER)) {
                this.transformerData = transformer.loadInstanceData(context, compound.func_74781_a(KEY_TRANSFORMER));
            }
            if (compound.func_74764_b(KEY_FOREIGN_TRANSFORMER)) {
                this.foreignTransformerData = foreignTransformer.loadInstanceData(context, compound.func_74781_a(KEY_FOREIGN_TRANSFORMER));
            }
            this.transformerGenerationBehavior.readFromNBT(context, nbt, worldData);
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = (NBTTagCompound)this.transformerGenerationBehavior.writeToNBT();
            NBTCompoundObjects.writeTo(compound, "variables", this.variableDomain);
            if (this.transformerData != null) {
                compound.func_74782_a(KEY_TRANSFORMER, this.transformerData.writeToNBT());
            }
            if (this.foreignTransformerData != null) {
                compound.func_74782_a(KEY_FOREIGN_TRANSFORMER, this.foreignTransformerData.writeToNBT());
            }
            return compound;
        }
    }

    public static class Serializer
    implements JsonDeserializer<GenericStructure>,
    JsonSerializer<GenericStructure> {
        public GenericStructure deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            Integer version;
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "status");
            GenericStructure structureInfo = new GenericStructure();
            if (jsonObject.has("version")) {
                version = JsonUtils.getInt(jsonObject, "version");
            } else {
                version = 3;
                RecurrentComplex.logger.warn("Structure JSON missing 'version', using latest (3)");
            }
            GenerationType.idRandomizers.push(new Random(-559038737L));
            if (jsonObject.has("generationInfos")) {
                Collections.addAll(structureInfo.generationTypes, (Object[])context.deserialize(jsonObject.get("generationInfos"), GenerationType[].class));
            }
            GenerationType.idRandomizers.pop();
            if (version == 1) {
                structureInfo.generationTypes.add(NaturalGeneration.deserializeFromVersion1(jsonObject, context));
            }
            if (jsonObject.has("naturalGenerationInfo")) {
                structureInfo.generationTypes.add((GenerationType)NaturalGeneration.getGson().fromJson(jsonObject.get("naturalGenerationInfo"), NaturalGeneration.class));
            }
            if (jsonObject.has("mazeGenerationInfo")) {
                structureInfo.generationTypes.add((GenerationType)MazeGeneration.getGson().fromJson(jsonObject.get("mazeGenerationInfo"), MazeGeneration.class));
            }
            Transformer.idRandomizers.push(new Random(-559038737L));
            if (jsonObject.has("transformer")) {
                structureInfo.transformer = (TransformerMulti)context.deserialize(jsonObject.get("transformer"), TransformerMulti.class);
            } else if (jsonObject.has("transformers")) {
                Collections.addAll(structureInfo.transformer.getTransformers(), (Object[])context.deserialize(jsonObject.get("transformers"), Transformer[].class));
            } else if (jsonObject.has("blockTransformers")) {
                Collections.addAll(structureInfo.transformer.getTransformers(), (Object[])context.deserialize(jsonObject.get("blockTransformers"), Transformer[].class));
            }
            Transformer.idRandomizers.pop();
            structureInfo.rotatable = JsonUtils.getBoolean(jsonObject, "rotatable", false);
            structureInfo.mirrorable = JsonUtils.getBoolean(jsonObject, "mirrorable", false);
            structureInfo.blocking = JsonUtils.getBoolean(jsonObject, "blocking", true);
            structureInfo.variableDomain = (GenericVariableDomain)context.deserialize((JsonElement)JsonUtils.getJsonObject(jsonObject, "variableDomain", new JsonObject()), GenericVariableDomain.class);
            if (jsonObject.has("dependencyExpression")) {
                structureInfo.dependencies.setExpression(JsonUtils.getString(jsonObject, "dependencyExpression"));
            } else if (jsonObject.has("dependencies")) {
                structureInfo.dependencies.setExpression(DependencyExpression.ofMods((String[])context.deserialize(jsonObject.get("dependencies"), String[].class)));
            }
            if (jsonObject.has("worldData")) {
                structureInfo.worldDataCompound = (NBTTagCompound)context.deserialize(jsonObject.get("worldData"), NBTTagCompound.class);
            } else if (jsonObject.has("worldDataBase64")) {
                structureInfo.worldDataCompound = NBTToJson.getNBTFromBase64(JsonUtils.getString(jsonObject, "worldDataBase64"));
            }
            if (jsonObject.has("metadata")) {
                structureInfo.metadata = (Metadata)context.deserialize(jsonObject.get("metadata"), Metadata.class);
            }
            structureInfo.customData = JsonUtils.getJsonObject(jsonObject, "customData", new JsonObject());
            return structureInfo;
        }

        public JsonElement serialize(GenericStructure structureInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("version", (Number)3);
            jsonObject.add("generationInfos", context.serialize(structureInfo.generationTypes));
            jsonObject.add("transformer", context.serialize((Object)structureInfo.transformer));
            jsonObject.addProperty("rotatable", Boolean.valueOf(structureInfo.rotatable));
            jsonObject.addProperty("mirrorable", Boolean.valueOf(structureInfo.mirrorable));
            jsonObject.addProperty("blocking", Boolean.valueOf(structureInfo.blocking));
            jsonObject.add("variableDomain", context.serialize((Object)structureInfo.variableDomain));
            jsonObject.add("dependencyExpression", context.serialize((Object)structureInfo.dependencies.getExpression()));
            jsonObject.add("metadata", context.serialize((Object)structureInfo.metadata));
            jsonObject.add("customData", (JsonElement)structureInfo.customData);
            return jsonObject;
        }
    }
}

