/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.IFullGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenBush
implements IFullGenFeature,
IPostGenFeature {
    private IBlockState logState = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    private IBlockState leavesState = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false));
    private IBlockState secondaryLeavesState = null;
    private Predicate<Biome> biomePredicate = i -> true;

    public FeatureGenBush setLogState(IBlockState logState) {
        this.logState = logState;
        return this;
    }

    public FeatureGenBush setLeavesState(IBlockState leavesState) {
        this.leavesState = leavesState;
        return this;
    }

    public FeatureGenBush setSecondaryLeavesState(IBlockState secondaryLeavesState) {
        this.secondaryLeavesState = secondaryLeavesState;
        return this;
    }

    public FeatureGenBush setBiomePredicate(Predicate<Biome> biomePredicate) {
        this.biomePredicate = biomePredicate;
        return this;
    }

    @Override
    public boolean generate(World world, BlockPos rootPos, Species species, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        this.commonGen(world, rootPos, species, random, radius, safeBounds);
        return true;
    }

    @Override
    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (safeBounds != SafeChunkBounds.ANY && this.biomePredicate.test(biome)) {
            this.commonGen(world, rootPos, species, world.field_73012_v, radius, safeBounds);
            return true;
        }
        return false;
    }

    protected void commonGen(World world, BlockPos rootPos, Species species, Random random, int radius, SafeChunkBounds safeBounds) {
        if (radius <= 2) {
            return;
        }
        Vec3d vTree = new Vec3d((Vec3i)rootPos).func_72441_c(0.5, 0.5, 0.5);
        for (int i = 0; i < 2; ++i) {
            int rad = MathHelper.func_76125_a((int)(world.field_73012_v.nextInt(radius - 2) + 2), (int)2, (int)(radius - 1));
            Vec3d v = vTree.func_178787_e(new Vec3d(1.0, 0.0, 0.0).func_186678_a((double)rad).func_178785_b((float)((double)random.nextFloat() * Math.PI * 2.0)));
            BlockPos vPos = new BlockPos(v);
            if (!safeBounds.inBounds(vPos, true)) continue;
            BlockPos pos = CoordUtils.findGround(world, vPos);
            IBlockState soilBlockState = world.func_180495_p(pos);
            if (world.func_180495_p(pos = pos.func_177984_a()).func_185904_a().func_76224_d() || !species.isAcceptableSoil(world, pos, soilBlockState)) continue;
            world.func_175656_a(pos, this.logState);
            SimpleVoxmap leafMap = LeafClusters.bush;
            BlockPos.MutableBlockPos leafPos = new BlockPos.MutableBlockPos();
            for (BlockPos.MutableBlockPos dPos : leafMap.getAllNonZero()) {
                leafPos.func_181079_c(pos.func_177958_n() + dPos.func_177958_n(), pos.func_177956_o() + dPos.func_177956_o(), pos.func_177952_p() + dPos.func_177952_p());
                if (!safeBounds.inBounds((BlockPos)leafPos, true) || FeatureGenBush.coordHashCode((BlockPos)leafPos) % 5 == 0 || !world.func_180495_p((BlockPos)leafPos).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)leafPos)) continue;
                world.func_175656_a((BlockPos)leafPos, this.secondaryLeavesState == null || random.nextInt(4) != 0 ? this.leavesState : this.secondaryLeavesState);
            }
        }
    }

    public static int coordHashCode(BlockPos pos) {
        int hash = (pos.func_177958_n() * 4111 ^ pos.func_177956_o() * 271 ^ pos.func_177952_p() * 3067) >> 1;
        return hash & 0xFFFF;
    }
}

