/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.worldgen;

import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class BiomePropertySelectors {

    public static enum EnumChance {
        OK,
        CANCEL,
        UNHANDLED;

    }

    public static class RandomSpeciesSelector
    implements ISpeciesSelector {
        ArrayList<Entry> decisionTable = new ArrayList();
        int totalWeight;

        public int getSize() {
            return this.decisionTable.size();
        }

        public RandomSpeciesSelector add(@Nonnull Species species, int weight) {
            this.decisionTable.add(new Entry(new SpeciesSelection(species), weight));
            this.totalWeight += weight;
            return this;
        }

        public RandomSpeciesSelector add(int weight) {
            this.decisionTable.add(new Entry(new SpeciesSelection(), weight));
            this.totalWeight += weight;
            return this;
        }

        @Override
        public SpeciesSelection getSpecies(BlockPos pos, IBlockState dirt, Random random) {
            int chance = random.nextInt(this.totalWeight);
            for (Entry entry : this.decisionTable) {
                if (chance < entry.weight) {
                    return entry.decision;
                }
                chance -= entry.weight;
            }
            return this.decisionTable.get((int)(this.decisionTable.size() - 1)).decision;
        }

        private class Entry {
            public SpeciesSelection decision;
            public int weight;

            public Entry(SpeciesSelection d, int w) {
                this.decision = d;
                this.weight = w;
            }
        }
    }

    public static class StaticSpeciesSelector
    implements ISpeciesSelector {
        final SpeciesSelection decision;

        public StaticSpeciesSelector(SpeciesSelection decision) {
            this.decision = decision;
        }

        public StaticSpeciesSelector(@Nonnull Species species) {
            this(new SpeciesSelection(species));
        }

        public StaticSpeciesSelector() {
            this(new SpeciesSelection());
        }

        @Override
        public SpeciesSelection getSpecies(BlockPos pos, IBlockState dirt, Random random) {
            return this.decision;
        }
    }

    public static class SpeciesSelection {
        private final boolean handled;
        private final Species species;

        public SpeciesSelection() {
            this.handled = false;
            this.species = Species.NULLSPECIES;
        }

        public SpeciesSelection(@Nonnull Species species) {
            this.species = species;
            this.handled = true;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public Species getSpecies() {
            return this.species;
        }
    }

    public static interface ISpeciesSelector {
        public SpeciesSelection getSpecies(BlockPos var1, IBlockState var2, Random var3);
    }

    public static interface IDensitySelector {
        public double getDensity(Random var1, double var2);
    }

    public static interface IChanceSelector {
        public EnumChance getChance(Random var1, @Nonnull Species var2, int var3);
    }
}

