/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.network;

import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeCollector;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MapSignal {
    protected ArrayList<INodeInspector> nodeInspectors = new ArrayList();
    public BlockPos root = null;
    public int depth;
    public boolean multiroot = false;
    public boolean destroyLoopedNodes = true;
    public boolean trackVisited = false;
    public EnumFacing localRootDir = null;
    public boolean overflow;
    public boolean found;

    public MapSignal() {
    }

    public MapSignal(INodeInspector ... nis) {
        this();
        Collections.addAll(this.nodeInspectors, nis);
    }

    public boolean run(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        for (INodeInspector inspector : this.nodeInspectors) {
            inspector.run(blockState, world, pos, fromDir);
        }
        return false;
    }

    public boolean returnRun(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        for (INodeInspector inspector : this.nodeInspectors) {
            inspector.returnRun(blockState, world, pos, fromDir);
        }
        return false;
    }

    public ArrayList<INodeInspector> getInspectors() {
        return this.nodeInspectors;
    }

    public boolean doTrackingVisited(BlockPos pos) {
        INodeInspector inspector;
        if (this.nodeInspectors.size() > 0 && (inspector = this.nodeInspectors.get(0)) instanceof NodeCollector) {
            return ((NodeCollector)inspector).contains(pos);
        }
        return false;
    }
}

