/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.events.PopulateDataBaseEvent;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.util.JsonHelper;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBasePopulatorJson;
import com.ferreusveritas.dynamictrees.worldgen.MultiDimensionalPopulator;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import com.ferreusveritas.dynamictrees.worldgen.json.IJsonBiomeApplier;
import com.ferreusveritas.dynamictrees.worldgen.json.IJsonBiomeSelector;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WorldGenRegistry {
    private static final String RESOURCEPATH = "worldgen/default.json";
    private static final String CONFIGPATH = "/dynamictrees";
    private static final String WORLDGENCONFIGPATH = "/dynamictrees/worldgen.json";
    private static final String DIMGENCONFIGPATH = "/dynamictrees/dimensions.json";

    public static boolean isWorldGenEnabled() {
        return ModConfigs.worldGen;
    }

    private static IBiomeDataBasePopulator collectDataBasePopulators() {
        BiomeDataBasePopulatorRegistryEvent event = new BiomeDataBasePopulatorRegistryEvent();
        event.register(new BiomeDataBasePopulatorJson(new ResourceLocation("dynamictrees", RESOURCEPATH)));
        MinecraftForge.EVENT_BUS.post((Event)event);
        WorldGenRegistry.loadCustomDefaultPopulator(event);
        return event.getPopulator();
    }

    private static void loadCustomDefaultPopulator(BiomeDataBasePopulatorRegistryEvent event) {
        File file = new File(ModConfigs.configDirectory.getAbsolutePath() + WORLDGENCONFIGPATH);
        if (!file.exists()) {
            WorldGenRegistry.writeBlankJsonArrayToFile(file);
        } else {
            event.register(new BiomeDataBasePopulatorJson(JsonHelper.load(file)));
        }
    }

    private static void loadMultiDimensionalPopulator(IBiomeDataBasePopulator populator) {
        File file = new File(ModConfigs.configDirectory.getAbsolutePath() + DIMGENCONFIGPATH);
        if (!file.exists()) {
            WorldGenRegistry.writeBlankJsonArrayToFile(file);
        } else {
            new MultiDimensionalPopulator(JsonHelper.load(file), populator);
        }
    }

    private static void writeBlankJsonArrayToFile(File file) {
        try {
            new File(ModConfigs.configDirectory.getAbsolutePath() + CONFIGPATH).mkdirs();
            BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write("[]");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void populateDataBase() {
        if (WorldGenRegistry.isWorldGenEnabled()) {
            BiomeDataBaseJsonCapabilityRegistryEvent capabilityEvent = new BiomeDataBaseJsonCapabilityRegistryEvent();
            BiomeDataBasePopulatorJson.registerJsonCapabilities(capabilityEvent);
            MinecraftForge.EVENT_BUS.post((Event)capabilityEvent);
            TreeGenerator.getTreeGenerator().clearAllBiomeDataBases();
            BiomeDataBase database = TreeGenerator.getTreeGenerator().getDefaultBiomeDataBase();
            IBiomeDataBasePopulator biomePopulator = WorldGenRegistry.collectDataBasePopulators();
            biomePopulator.populate(database);
            MinecraftForge.EVENT_BUS.post((Event)new PopulateDataBaseEvent(database, biomePopulator));
            WorldGenRegistry.loadMultiDimensionalPopulator(biomePopulator);
            ModConfigs.dimensionBlacklist.forEach(d -> TreeGenerator.getTreeGenerator().BlackListDimension((int)d));
            BiomeDataBasePopulatorJson.cleanup();
        }
    }

    public static boolean validateBiomeDataBases() {
        if (WorldGenRegistry.isWorldGenEnabled()) {
            return TreeGenerator.getTreeGenerator().validateBiomeDataBases();
        }
        return true;
    }

    public static class BiomeDataBasePopulatorRegistryEvent
    extends Event {
        private final List<IBiomeDataBasePopulator> biomePopulators = new ArrayList<IBiomeDataBasePopulator>();

        public void register(IBiomeDataBasePopulator populator) {
            this.biomePopulators.add(populator);
        }

        private IBiomeDataBasePopulator getPopulator() {
            return biomeDataBase -> this.biomePopulators.forEach(p -> p.populate(biomeDataBase));
        }
    }

    public static class BiomeDataBaseJsonCapabilityRegistryEvent
    extends Event {
        public void register(String name, IJsonBiomeSelector selector) {
            BiomeDataBasePopulatorJson.addJsonBiomeSelector(name, selector);
        }

        public void register(String name, IJsonBiomeApplier applier) {
            BiomeDataBasePopulatorJson.addJsonBiomeApplier(name, applier);
        }
    }
}

