/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.resource;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.resource.IResourceManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public class AbstractResourceManager
implements IResourceManager {
    private IMod mod;
    private String baseResourceFolder;

    public AbstractResourceManager(IMod mod, String resourceFolder) {
        this.setMod(mod);
        this.setBaseResourceFolder(resourceFolder);
    }

    @Override
    public void buildAndExpose(String jarResourceRootPath, String modID, List<String> locations) {
        GottschCore.logger.debug("resource folder locations -> {}", locations);
        for (String location : locations) {
            GottschCore.logger.debug("buildAndExpose location -> {}", (Object)location);
            this.createFileSystemResourceFolder(modID, location);
            this.exposeResource(jarResourceRootPath, modID, location);
        }
    }

    protected void createFileSystemResourceFolder(String modID, String location) {
        Path folder = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), this.getBaseResourceFolder(), modID, location != null && !location.equals("") ? location + "/" : "").toAbsolutePath();
        if (Files.notExists(folder, new LinkOption[0])) {
            GottschCore.logger.debug("resources folder \"{}\" will be created.", (Object)folder.toString());
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                GottschCore.logger.warn("Unable to create resources folder \"{}\"", (Object)folder.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exposeResource(String jarResourceRootPath, String modID, String location) {
        if (modID == null || modID.isEmpty()) {
            modID = this.getMod().getId();
        }
        location = location != null && !location.equals("") ? location + "/" : "";
        Path folder = null;
        Stream<Path> walk = null;
        GottschCore.logger.debug("resource as file system path -> {},{},{}", (Object)jarResourceRootPath.toString(), (Object)modID, (Object)location);
        FileSystem fs = this.getJarResourceAsFileSystemObject(jarResourceRootPath, modID, location);
        if (fs == null) {
            return;
        }
        try {
            Path resourceBasePath = fs.getPath(jarResourceRootPath, modID, location);
            GottschCore.logger.debug("resource base path -> {}", (Object)resourceBasePath.toString());
            folder = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), this.getBaseResourceFolder(), modID, location).toAbsolutePath();
            boolean isFirst = true;
            walk = Files.walk(resourceBasePath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path resourceFilePath = (Path)it.next();
                if (isFirst) {
                    if (Files.notExists(folder, new LinkOption[0])) {
                        this.createFileSystemResourceFolder(modID, location);
                    }
                } else {
                    Path fileSystemFilePath = Paths.get(folder.toString(), resourceFilePath.getFileName().toString()).toAbsolutePath();
                    GottschCore.logger.debug("file system resource path -> {}", (Object)fileSystemFilePath.toString());
                    if (Files.notExists(fileSystemFilePath, new LinkOption[0])) {
                        InputStream is = this.getMod().getClass().getResourceAsStream(resourceFilePath.toString());
                        try (FileOutputStream fos = new FileOutputStream(fileSystemFilePath.toFile());){
                            int r;
                            byte[] buf = new byte[2048];
                            while ((r = is.read(buf)) != -1) {
                                fos.write(buf, 0, r);
                            }
                        }
                        catch (IOException e) {
                            GottschCore.logger.error("Error exposing resource to file system.", (Throwable)e);
                        }
                    }
                }
                isFirst = false;
            }
        }
        catch (Exception e) {
            GottschCore.logger.error("error:", (Throwable)e);
        }
        finally {
            if (walk != null) {
                walk.close();
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    GottschCore.logger.error("error:", (Throwable)e);
                }
            }
        }
    }

    protected FileSystem getJarResourceAsFileSystemObject(String resourceRootPath, String modID, String location) {
        FileSystem fs = null;
        HashMap env = new HashMap();
        URI uri = null;
        resourceRootPath = "/" + resourceRootPath.replaceAll("^/|/$", "") + "/";
        URL url = this.getMod().getClass().getResource(resourceRootPath + modID + "/" + location);
        if (url == null) {
            GottschCore.logger.error("Unable to locate resource {}", (Object)(resourceRootPath + modID + "/" + location));
            return null;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            GottschCore.logger.error("An error occurred during resource exposing processing:", (Throwable)e);
            return null;
        }
        String[] array = uri.toString().split("!");
        try {
            fs = FileSystems.newFileSystem(URI.create(array[0]), env);
        }
        catch (IOException e) {
            GottschCore.logger.error("An error occurred during resource exposing processing:", (Throwable)e);
            return null;
        }
        return fs;
    }

    protected List<ResourceLocation> getResourceLocations(String modIDIn, String locationIn) {
        String modID = modIDIn == null || modIDIn.isEmpty() ? this.getMod().getId() : modIDIn;
        String location = locationIn != null && !locationIn.equals("") ? locationIn + "/" : "";
        ArrayList<ResourceLocation> locs = new ArrayList<ResourceLocation>();
        Path path = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), this.getBaseResourceFolder(), modID, location).toAbsolutePath();
        GottschCore.logger.debug("Path to custom resource -> {}", (Object)path.toString());
        if (Files.notExists(path, new LinkOption[0])) {
            GottschCore.logger.debug("Unable to locate -> {}", (Object)path.toString());
            return locs;
        }
        try {
            Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                GottschCore.logger.debug("Custom resource file path-> {}", (Object)f.toAbsolutePath().toString());
                ResourceLocation loc = new ResourceLocation(this.getMod().getId() + ":" + this.getBaseResourceFolder() + "/" + modID + "/" + location + f.getFileName().toString());
                GottschCore.logger.debug("Resource location -> {}", (Object)loc);
                locs.add(loc);
            });
        }
        catch (IOException e) {
            GottschCore.logger.error("Error processing custom resource:", (Throwable)e);
        }
        return locs;
    }

    @Override
    public IMod getMod() {
        return this.mod;
    }

    @Override
    public void setMod(IMod mod) {
        this.mod = mod;
    }

    @Override
    public String getBaseResourceFolder() {
        return this.baseResourceFolder;
    }

    @Override
    public void setBaseResourceFolder(String resourceFolder) {
        this.baseResourceFolder = resourceFolder;
    }
}

