/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import com.someguyssoftware.gottschcore.loot.functions.EnchantRandomly;
import com.someguyssoftware.gottschcore.loot.functions.EnchantWithLevels;
import com.someguyssoftware.gottschcore.loot.functions.LootFunction;
import com.someguyssoftware.gottschcore.loot.functions.LootingEnchantBonus;
import com.someguyssoftware.gottschcore.loot.functions.SetAttributes;
import com.someguyssoftware.gottschcore.loot.functions.SetCount;
import com.someguyssoftware.gottschcore.loot.functions.SetDamage;
import com.someguyssoftware.gottschcore.loot.functions.SetMetadata;
import com.someguyssoftware.gottschcore.loot.functions.SetNBT;
import com.someguyssoftware.gottschcore.loot.functions.Smelt;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

@Deprecated
public class LootFunctionManager {
    private static final Map<ResourceLocation, LootFunction.Serializer<?>> NAME_TO_SERIALIZER_MAP = Maps.newHashMap();
    private static final Map<Class<? extends LootFunction>, LootFunction.Serializer<?>> CLASS_TO_SERIALIZER_MAP = Maps.newHashMap();

    public static <T extends LootFunction> void registerFunction(LootFunction.Serializer<? extends T> serializer) {
        ResourceLocation resourcelocation = serializer.getFunctionName();
        Class<T> oclass = serializer.getFunctionClass();
        if (NAME_TO_SERIALIZER_MAP.containsKey(resourcelocation)) {
            throw new IllegalArgumentException("Can't re-register item function name " + resourcelocation);
        }
        if (CLASS_TO_SERIALIZER_MAP.containsKey(oclass)) {
            throw new IllegalArgumentException("Can't re-register item function class " + oclass.getName());
        }
        NAME_TO_SERIALIZER_MAP.put(resourcelocation, serializer);
        CLASS_TO_SERIALIZER_MAP.put(oclass, serializer);
    }

    public static LootFunction.Serializer<?> getSerializerForName(ResourceLocation location) {
        LootFunction.Serializer<?> serializer = NAME_TO_SERIALIZER_MAP.get(location);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown TreasureLoot item function '" + location + "'");
        }
        return serializer;
    }

    public static <T extends LootFunction> LootFunction.Serializer<T> getSerializerFor(T functionClass) {
        LootFunction.Serializer<?> serializer = CLASS_TO_SERIALIZER_MAP.get(functionClass.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown TreasureLoot item function " + functionClass);
        }
        return serializer;
    }

    static {
        LootFunctionManager.registerFunction(new SetCount.Serializer());
        LootFunctionManager.registerFunction(new SetMetadata.Serializer());
        LootFunctionManager.registerFunction(new EnchantWithLevels.Serializer());
        LootFunctionManager.registerFunction(new EnchantRandomly.Serializer());
        LootFunctionManager.registerFunction(new SetNBT.Serializer());
        LootFunctionManager.registerFunction(new Smelt.Serializer());
        LootFunctionManager.registerFunction(new LootingEnchantBonus.Serializer());
        LootFunctionManager.registerFunction(new SetDamage.Serializer());
        LootFunctionManager.registerFunction(new SetAttributes.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<LootFunction>,
    JsonSerializer<LootFunction> {
        public LootFunction deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            LootFunction.Serializer<?> serializer;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"function");
            ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"function"));
            try {
                serializer = LootFunctionManager.getSerializerForName(resourcelocation);
            }
            catch (IllegalArgumentException var8) {
                throw new JsonSyntaxException("Unknown function '" + resourcelocation + "'");
            }
            return serializer.deserialize(jsonobject, p_deserialize_3_, (LootCondition[])JsonUtils.func_188177_a((JsonObject)jsonobject, (String)"conditions", (Object)new LootCondition[0], (JsonDeserializationContext)p_deserialize_3_, LootCondition[].class));
        }

        public JsonElement serialize(LootFunction p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            LootFunction.Serializer<LootFunction> serializer = LootFunctionManager.getSerializerFor(p_serialize_1_);
            JsonObject jsonobject = new JsonObject();
            serializer.serialize(jsonobject, p_serialize_1_, p_serialize_3_);
            jsonobject.addProperty("function", serializer.getFunctionName().toString());
            if (p_serialize_1_.getConditions() != null && p_serialize_1_.getConditions().length > 0) {
                jsonobject.add("conditions", p_serialize_3_.serialize((Object)p_serialize_1_.getConditions()));
            }
            return jsonobject;
        }
    }
}

