/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.net;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketContext;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.client.rendering.ItemToBookHandler;
import org.zeith.improvableskills.client.rendering.OnTopEffects;
import org.zeith.improvableskills.client.rendering.ote.OTEBook;
import org.zeith.improvableskills.client.rendering.ote.OTEItemSkillScroll;
import org.zeith.improvableskills.proxy.SyncSkills;

public class PacketScrollUnlockedSkill
implements IPacket {
    private ResourceLocation[] skills;
    private ItemStack used;
    private int slot;

    public PacketScrollUnlockedSkill(int slot, ItemStack used, ResourceLocation ... skills) {
        this.skills = skills;
        this.used = used;
        this.slot = slot;
    }

    public PacketScrollUnlockedSkill() {
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList tags = new NBTTagList();
        for (ResourceLocation s : this.skills) {
            tags.func_74742_a((NBTBase)new NBTTagString(s.toString()));
        }
        nbt.func_74782_a("s", (NBTBase)tags);
        nbt.func_74768_a("i", this.slot);
        nbt.func_74782_a("u", (NBTBase)this.used.serializeNBT());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList tags = nbt.func_150295_c("s", 8);
        this.skills = new ResourceLocation[tags.func_74745_c()];
        for (int i = 0; i < this.skills.length; ++i) {
            this.skills[i] = new ResourceLocation(tags.func_150307_f(i));
        }
        this.slot = nbt.func_74762_e("i");
        this.used = new ItemStack(nbt.func_74775_l("u"));
    }

    @SideOnly(value=Side.CLIENT)
    public IPacket executeOnClient(PacketContext net) {
        EntityPlayerSP sp = Minecraft.func_71410_x().field_71439_g;
        ArrayList<PlayerSkillBase> base = new ArrayList<PlayerSkillBase>();
        for (ResourceLocation skill : this.skills) {
            PlayerSkillBase sk = (PlayerSkillBase)GameRegistry.findRegistry(PlayerSkillBase.class).getValue(skill);
            base.add(sk);
            sp.func_145747_a((ITextComponent)new TextComponentTranslation("chat.improvableskills.page_unlocked", new Object[]{sk.getLocalizedName(SyncSkills.getData())}));
        }
        Random rand = new Random();
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        Vec2f v = ItemToBookHandler.getPosOfHandSlot(this.slot == -2 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND, sr);
        OTEBook.show(150 + 10 * base.size());
        OnTopEffects.effects.add(new OTEItemSkillScroll(v.field_189982_i, v.field_189983_j, (float)(sr.func_78326_a() - 20 - 48) + rand.nextFloat() * 32.0f, (float)(sr.func_78328_b() - 12 - 24) - rand.nextFloat() * 32.0f, 100, this.used, base.toArray(new PlayerSkillBase[0])));
        return null;
    }

    static {
        IPacket.handle(PacketScrollUnlockedSkill.class, PacketScrollUnlockedSkill::new);
    }
}

