/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.net;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.data.PlayerDataManager;
import org.zeith.improvableskills.net.PacketSyncSkillData;

public class PacketLvlUpSkill
implements IPacket {
    public ResourceLocation skill;

    public PacketLvlUpSkill(PlayerSkillBase skill) {
        this.skill = skill.getRegistryName();
    }

    public PacketLvlUpSkill() {
    }

    public void executeOnServer2(PacketContext net) {
        EntityPlayerMP player = net.getSender();
        PlayerDataManager.handleDataSafely((EntityPlayer)player, data -> {
            PlayerSkillBase skill = (PlayerSkillBase)GameRegistry.findRegistry(PlayerSkillBase.class).getValue(this.skill);
            short lvl = data.getSkillLevel(skill);
            if (skill != null && skill.canUpgrade((PlayerSkillData)data) && lvl < 32766) {
                data.setSkillLevel(skill, lvl + 1);
                skill.onUpgrade(lvl, (short)(lvl + 1), (PlayerSkillData)data);
                player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
                PacketSyncSkillData.sync(player);
            }
        });
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("Skill", this.skill.toString());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.skill = new ResourceLocation(nbt.func_74779_i("Skill"));
    }

    static {
        IPacket.handle(PacketLvlUpSkill.class, PacketLvlUpSkill::new);
    }
}

