/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.items;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.utils.SoundUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.data.PlayerDataManager;
import org.zeith.improvableskills.init.ItemsIS;
import org.zeith.improvableskills.net.PacketScrollUnlockedSkill;
import org.zeith.improvableskills.proxy.SyncSkills;

public class ItemSkillScroll
extends Item {
    private static final Map<String, PlayerSkillBase> SKILL_MAP = new HashMap<String, PlayerSkillBase>();

    public ItemSkillScroll() {
        this.func_77655_b("scroll_normal");
        this.func_77625_d(1);
    }

    @Nullable
    public static PlayerSkillBase getSkillFromScroll(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSkillScroll && stack.func_77942_o() && stack.func_77978_p().func_150297_b("Skill", 8)) {
            String skill = stack.func_77978_p().func_74779_i("Skill");
            if (SKILL_MAP.containsKey(skill)) {
                return SKILL_MAP.get(skill);
            }
            PlayerSkillBase b = (PlayerSkillBase)GameRegistry.findRegistry(PlayerSkillBase.class).getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("Skill")));
            SKILL_MAP.put(skill, b);
            return b;
        }
        return null;
    }

    public static ItemStack of(PlayerSkillBase base) {
        if (base.getScrollState().hasScroll()) {
            ItemStack stack = new ItemStack((Item)ItemsIS.SKILL_SCROLL);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Skill", base.getRegistryName().toString());
            stack.func_77982_d(tag);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static void getItems(NonNullList<ItemStack> items) {
        GameRegistry.findRegistry(PlayerSkillBase.class).getValuesCollection().stream().filter(skill -> skill.getScrollState().hasScroll()).forEach(skill -> items.add((Object)ItemSkillScroll.of(skill)));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemSkillScroll.getItems(items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerSkillBase base = ItemSkillScroll.getSkillFromScroll(stack);
        if (base == null) {
            return;
        }
        tooltip.add(TextFormatting.GRAY + base.getLocalizedName(SyncSkills.getData()));
        if (flagIn.func_194127_a()) {
            tooltip.add(TextFormatting.DARK_GRAY + " - " + base.getRegistryName());
        }
        if (GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_135052_a((String)("recipe." + base.getRegistryName().func_110624_b() + ":skill." + base.getRegistryName().func_110623_a()), (Object[])new Object[0]).replace('&', '\u00a7'));
        } else {
            tooltip.add(I18n.func_135052_a((String)"text.improvableskills:shiftfrecipe", (Object[])new Object[0]).replace('&', '\u00a7'));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            return PlayerDataManager.handleDataSafely(playerIn, data -> {
                PlayerSkillBase base = ItemSkillScroll.getSkillFromScroll(playerIn.func_184586_b(handIn));
                if (!data.stat_scrolls.contains(base.getRegistryName().toString())) {
                    int slot;
                    data.stat_scrolls.add(base.getRegistryName().toString());
                    ItemStack used = playerIn.func_184586_b(handIn).func_77946_l();
                    playerIn.func_184586_b(handIn).func_190918_g(1);
                    HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)handIn);
                    SoundUtil.playSoundEffect((World)worldIn, (String)"block.enchantment_table.use", (BlockPos)playerIn.func_180425_c(), (float)0.5f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                    int n = slot = handIn == EnumHand.OFF_HAND ? -2 : playerIn.field_71071_by.field_70461_c;
                    if (playerIn instanceof EntityPlayerMP) {
                        HCNet.INSTANCE.sendTo((IPacket)new PacketScrollUnlockedSkill(slot, used, base.getRegistryName()), (EntityPlayerMP)playerIn);
                    }
                    data.sync();
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                }
                if (data.getSkillLevel(base) < base.maxLvl) {
                    int slot;
                    data.setSkillLevel(base, data.getSkillLevel(base) + 1);
                    ItemStack used = playerIn.func_184586_b(handIn).func_77946_l();
                    playerIn.func_184586_b(handIn).func_190918_g(1);
                    HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)handIn);
                    SoundUtil.playSoundEffect((World)worldIn, (String)"block.enchantment_table.use", (BlockPos)playerIn.func_180425_c(), (float)0.5f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                    int n = slot = handIn == EnumHand.OFF_HAND ? -2 : playerIn.field_71071_by.field_70461_c;
                    if (playerIn instanceof EntityPlayerMP) {
                        HCNet.INSTANCE.sendTo((IPacket)new PacketScrollUnlockedSkill(slot, used, base.getRegistryName()), (EntityPlayerMP)playerIn);
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                }
                return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
            }, new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn)));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }
}

