/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.items;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.utils.SoundUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.data.PlayerDataManager;
import org.zeith.improvableskills.init.ItemsIS;
import org.zeith.improvableskills.net.PacketScrollUnlockedAbility;
import org.zeith.improvableskills.proxy.SyncSkills;

public class ItemAbilityScroll
extends Item {
    private static final Map<String, PlayerAbilityBase> ABILITY_MAP = new HashMap<String, PlayerAbilityBase>();

    public ItemAbilityScroll() {
        this.func_77655_b("scroll_ability");
        this.func_77625_d(1);
    }

    @Nullable
    public static PlayerAbilityBase getSkillFromScroll(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemAbilityScroll && stack.func_77942_o() && stack.func_77978_p().func_150297_b("Ability", 8)) {
            String skill = stack.func_77978_p().func_74779_i("Ability");
            if (ABILITY_MAP.containsKey(skill)) {
                return ABILITY_MAP.get(skill);
            }
            PlayerAbilityBase b = (PlayerAbilityBase)GameRegistry.findRegistry(PlayerAbilityBase.class).getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("Ability")));
            ABILITY_MAP.put(skill, b);
            return b;
        }
        return null;
    }

    public static ItemStack of(PlayerAbilityBase base) {
        ItemStack stack = new ItemStack((Item)ItemsIS.ABILITY_SCROLL);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Ability", base.getRegistryName().toString());
        stack.func_77982_d(tag);
        return stack;
    }

    public static void getItems(NonNullList<ItemStack> items) {
        GameRegistry.findRegistry(PlayerAbilityBase.class).getValuesCollection().stream().forEach(skill -> items.add((Object)ItemAbilityScroll.of(skill)));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemAbilityScroll.getItems(items);
        }
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerAbilityBase base = ItemAbilityScroll.getSkillFromScroll(stack);
        if (base == null) {
            return;
        }
        tooltip.add(TextFormatting.GRAY + base.getLocalizedName(SyncSkills.getData()));
        if (flagIn.func_194127_a()) {
            tooltip.add(TextFormatting.DARK_GRAY + " - " + base.getRegistryName());
        }
        if (GuiScreen.func_146272_n()) {
            int j;
            int i;
            String ln = I18n.func_135052_a((String)("recipe." + base.getRegistryName().func_110624_b() + ":ability." + base.getRegistryName().func_110623_a()), (Object[])new Object[0]).replace('&', '\u00a7');
            while ((i = ln.indexOf(60)) != -1 && (j = ln.indexOf(62, i + 1)) != -1) {
                String to = ln.substring(i + 1, j);
                Item it = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(to));
                String t = it != null ? it.func_190903_i().func_82833_r() : TextFormatting.DARK_RED + I18n.func_135052_a((String)"text.improvableskills:unresolved_item", (Object[])new Object[0]) + TextFormatting.GRAY;
                ln = ln.replaceAll("<" + to + ">", t);
            }
            tooltip.add(ln);
        } else {
            tooltip.add(I18n.func_135052_a((String)"text.improvableskills:shiftfrecipe", (Object[])new Object[0]).replace('&', '\u00a7'));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            return PlayerDataManager.handleDataSafely(playerIn, data -> {
                PlayerAbilityBase base = ItemAbilityScroll.getSkillFromScroll(playerIn.func_184586_b(handIn));
                if (!data.abilities.contains(base.getRegistryName().toString())) {
                    int slot;
                    data.abilities.add(base.getRegistryName().toString());
                    ItemStack used = playerIn.func_184586_b(handIn).func_77946_l();
                    playerIn.func_184586_b(handIn).func_190918_g(1);
                    HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)handIn);
                    SoundUtil.playSoundEffect((World)worldIn, (String)"block.enchantment_table.use", (BlockPos)playerIn.func_180425_c(), (float)0.5f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                    int n = slot = handIn == EnumHand.OFF_HAND ? -2 : playerIn.field_71071_by.field_70461_c;
                    if (playerIn instanceof EntityPlayerMP) {
                        HCNet.INSTANCE.sendTo((IPacket)new PacketScrollUnlockedAbility(slot, used, base.getRegistryName()), (EntityPlayerMP)playerIn);
                    }
                    data.sync();
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
                }
                return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
            }, new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn)));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }
}

