/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.data;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.zeith.improvableskills.ImprovableSkillsMod;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.proxy.SyncSkills;

@Mod.EventBusSubscriber
public class PlayerDataManager {
    public static final Map<String, PlayerSkillData> DATAS = new HashMap<String, PlayerSkillData>();
    private static ThreadLocal<EntityPlayer> LPLAYER = ThreadLocal.withInitial(() -> null);
    static final List<String> logoff = new ArrayList<String>();

    public static void handleDataSafely(EntityPlayer player, Consumer<PlayerSkillData> acceptor) {
        PlayerSkillData psd = PlayerDataManager.getDataFor(player);
        if (psd != null) {
            acceptor.accept(psd);
        }
    }

    public static <T> T handleDataSafely(EntityPlayer player, Function<PlayerSkillData, T> acceptor, T defaultValue) {
        PlayerSkillData psd = PlayerDataManager.getDataFor(player);
        if (psd != null) {
            return acceptor.apply(psd);
        }
        return defaultValue;
    }

    public static PlayerSkillData getDataFor(EntityPlayer player) {
        if (player == null || player instanceof FakePlayer) {
            return null;
        }
        if (player.field_70170_p.field_72995_K) {
            return SyncSkills.getData();
        }
        LPLAYER.set(player);
        PlayerSkillData psd = PlayerDataManager.getDataFor(player.func_146103_bH());
        if (psd != null && psd.getPlayer() != player) {
            psd = PlayerSkillData.deserialize(player, psd.serialize());
            DATAS.put(player.func_146103_bH().getId().toString(), psd);
        }
        return psd;
    }

    public static PlayerSkillData getDataFor(GameProfile player) {
        if (player == null) {
            return null;
        }
        return PlayerDataManager.getDataFor(player.getId());
    }

    public static PlayerSkillData getDataFor(UUID player) {
        if (player == null) {
            return null;
        }
        String u = player.toString();
        if (DATAS.containsKey(u)) {
            return DATAS.get(u);
        }
        EntityPlayer epl = LPLAYER.get();
        if (epl instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)epl;
        }
        return null;
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        logoff.add(e.player.func_146103_bH().getId().toString());
    }

    @SubscribeEvent
    public static void loadPlayerFromFile(PlayerEvent.LoadFromFile e) {
        NBTTagCompound nbttagcompound = null;
        try {
            File file1 = e.getPlayerFile(".is3.dat");
            if (file1.exists() && file1.isFile()) {
                nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
            }
        }
        catch (Exception var4) {
            ImprovableSkillsMod.LOG.warn("Failed to load player data for {}", (Object)e.getEntityPlayer().func_70005_c_());
        }
        if (nbttagcompound != null) {
            DATAS.put(e.getPlayerUUID(), PlayerSkillData.deserialize(e.getEntityPlayer(), nbttagcompound));
        } else {
            DATAS.put(e.getPlayerUUID(), new PlayerSkillData(e.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public static void savePlayerToFile(PlayerEvent.SaveToFile e) {
        PlayerSkillData data = PlayerDataManager.getDataFor(e.getEntityPlayer());
        if (data == null) {
            return;
        }
        try {
            NBTTagCompound nbttagcompound = data.serialize();
            File file1 = e.getPlayerFile(".is3.dat.tmp");
            File file2 = e.getPlayerFile(".is3.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file1.renameTo(file2);
        }
        catch (Exception var5) {
            ImprovableSkillsMod.LOG.warn("Failed to save player data for {}", (Object)e.getEntityPlayer().func_70005_c_());
        }
    }
}

