/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.custom.skills;

import com.zeitheron.hammercore.utils.ListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.Loader;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;

public class SkillGrowth
extends PlayerSkillBase {
    public static final List<String> blacklist = new ArrayList<String>();

    public SkillGrowth() {
        super(20);
        this.setRegistryName("improvableskills", "growth");
        this.hasScroll = true;
        this.genScroll = true;
        this.getLoot().chance.n = 4;
        this.getLoot().setLootTable(LootTableList.field_186430_l);
        this.xpCalculator.xpValue = 3;
    }

    @Override
    public void tick(PlayerSkillData data) {
        short lvl = data.getSkillLevel(this);
        if (lvl > 0 && data.player.field_70173_aa % ((this.maxLvl - lvl) * 3 + 80) == 0) {
            SkillGrowth.growAround((Entity)data.player, 2 + lvl / 4, lvl / 2 + 2);
        }
    }

    public static void growAround(Entity ent, int rad, int max) {
        World world = ent.field_70170_p;
        ArrayList positions = new ArrayList();
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                for (int y = -rad / 2; y <= rad / 2; ++y) {
                    IGrowable gr;
                    BlockPos pos = ent.func_180425_c().func_177982_a(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    Block b = state.func_177230_c();
                    if (!(b instanceof IGrowable) || blacklist.contains(b.getRegistryName().toString().toLowerCase()) || !(gr = (IGrowable)b).func_176473_a(world, pos, state, world.field_72995_K) || !gr.func_180670_a(world, world.field_73012_v, pos, state)) continue;
                    positions.add(pos);
                }
            }
        }
        positions = ListUtils.randomizeList(positions, (Random)ent.field_70170_p.field_73012_v);
        int co = Math.min(ent.field_70170_p.field_73012_v.nextInt(max), positions.size());
        for (int i = 0; i < co; ++i) {
            BlockPos pos = (BlockPos)positions.remove(0);
            try {
                if (!ItemDye.func_179234_a((ItemStack)ItemStack.field_190927_a, (World)world, (BlockPos)pos)) continue;
                world.func_175718_b(2005, pos, 0);
                continue;
            }
            catch (Throwable e) {
                if (e instanceof IllegalArgumentException && e.getMessage().equalsIgnoreCase("invalid hand null") && Loader.isModLoaded((String)"thebetweenlands")) {
                    try {
                        if (!(world instanceof WorldServer) || !ItemDye.applyBonemeal((ItemStack)ItemStack.field_190927_a, (World)world, (BlockPos)pos, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)), (EnumHand)EnumHand.MAIN_HAND)) continue;
                        world.func_175718_b(2005, pos, 0);
                    }
                    catch (Throwable err) {
                        err.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
            }
        }
    }
}

