/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.client.rendering.ote;

import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.opengl.GL11;
import org.zeith.improvableskills.client.gui.GuiXPBank;
import org.zeith.improvableskills.client.rendering.OTEffect;
import org.zeith.improvableskills.utils.Trajectory;

public class OTEXpOrb
extends OTEffect {
    private double tx;
    private double ty;
    private int totTime;
    private int prevTime;
    private int time;
    public double[] xPoints;
    public double[] yPoints;

    public OTEXpOrb(double x, double y, double tx, double ty, int time) {
        this.renderHud = false;
        this.totTime = time;
        this.x = this.prevX = x;
        this.y = this.prevY = y;
        this.tx = tx;
        this.ty = ty;
        double[][] path = Trajectory.makeBroken2DTrajectory(x, y, tx, ty, time, Math.abs((float)this.hashCode() / 25.0f));
        this.xPoints = path[0];
        this.yPoints = path[1];
    }

    @Override
    public void resize(ScaledResolution prev, ScaledResolution nev) {
        super.resize(prev, nev);
        this.tx = OTEXpOrb.handleResizeXd(this.tx, prev, nev);
        this.ty = OTEXpOrb.handleResizeYd(this.ty, prev, nev);
        this.xPoints = OTEXpOrb.handleResizeXdv(this.xPoints, prev, nev);
        this.yPoints = OTEXpOrb.handleResizeYdv(this.yPoints, prev, nev);
    }

    @Override
    public void update() {
        super.update();
        this.prevTime = this.time;
        int tt = this.xPoints.length;
        int cframe = Math.round((float)this.time / (float)this.totTime * (float)tt);
        this.x = this.xPoints[cframe];
        this.y = this.yPoints[cframe];
        ++this.time;
        if (this.time >= this.totTime) {
            this.setExpired();
        }
    }

    @Override
    public void render(float partialTime) {
        if (!(this.currentGui instanceof GuiXPBank)) {
            return;
        }
        double cx = this.prevX + (this.x - this.prevX) * (double)partialTime;
        double cy = this.prevY + (this.y - this.prevY) * (double)partialTime;
        float t = (float)this.prevTime + partialTime;
        float r = (float)((System.currentTimeMillis() + (long)Math.abs(this.hashCode())) % 2000L) / 2000.0f;
        r = r > 0.5f ? 1.0f - r : r;
        r += 0.45f;
        UtilsFX.bindTexture((String)"minecraft", (String)"textures/entity/experience_orb.png");
        int tx = 64 * (this.hashCode() % 3);
        GlStateManager.func_179141_d();
        RenderHelper.func_74518_a();
        float scale = 0.125f;
        if (t < 5.0f) {
            scale *= t / 5.0f;
        }
        if (t >= (float)(this.totTime - 5)) {
            scale *= 1.0f - (t - (float)this.totTime + 5.0f) / 5.0f;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)r, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)(cx - (double)(64.0f * scale / 2.0f)), (double)(cy - (double)(64.0f * scale / 2.0f)), (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (double)tx, (double)0.0, (double)64.0, (double)64.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

