/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.client.rendering.ote;

import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.opengl.GL11;
import org.zeith.improvableskills.client.rendering.OTEffect;
import org.zeith.improvableskills.utils.Trajectory;

public class OTESparkle
extends OTEffect {
    private int color;
    private double tx;
    private double ty;
    private int totTime;
    private int prevTime;
    private int time;
    public double[] xPoints;
    public double[] yPoints;
    Class<? extends GuiScreen> screen;

    public OTESparkle(double x, double y, double tx, double ty, int time, int color) {
        this.renderHud = false;
        this.totTime = time;
        this.x = this.prevX = x;
        this.y = this.prevY = y;
        this.tx = tx;
        this.ty = ty;
        this.color = color;
        double[][] path = Trajectory.makeBroken2DTrajectory(x, y, tx, ty, time, Math.abs((float)this.hashCode() / 25.0f));
        this.xPoints = path[0];
        this.yPoints = path[1];
        this.screen = Minecraft.func_71410_x().field_71462_r != null ? Minecraft.func_71410_x().field_71462_r.getClass() : null;
    }

    @Override
    public void resize(ScaledResolution prev, ScaledResolution nev) {
        super.resize(prev, nev);
        this.tx = OTESparkle.handleResizeXd(this.tx, prev, nev);
        this.ty = OTESparkle.handleResizeYd(this.ty, prev, nev);
        this.xPoints = OTESparkle.handleResizeXdv(this.xPoints, prev, nev);
        this.yPoints = OTESparkle.handleResizeYdv(this.yPoints, prev, nev);
    }

    @Override
    public void update() {
        super.update();
        this.prevTime = this.time;
        int tt = this.xPoints.length;
        int cframe = Math.round((float)this.time / (float)this.totTime * (float)tt);
        this.x = this.xPoints[cframe];
        this.y = this.yPoints[cframe];
        ++this.time;
        if (this.time >= this.totTime) {
            this.setExpired();
        }
    }

    @Override
    public void render(float partialTime) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null && this.screen == null || this.screen != null && gui != null && this.screen.isAssignableFrom(gui.getClass())) {
            double cx = this.prevX + (this.x - this.prevX) * (double)partialTime;
            double cy = this.prevY + (this.y - this.prevY) * (double)partialTime;
            float t = (float)this.prevTime + partialTime;
            float r = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
            r = r > 0.5f ? 1.0f - r : r;
            r += 0.45f;
            UtilsFX.bindTexture((String)"improvableskills", (String)"textures/particles/sparkle.png");
            int tx = 64 * (int)((float)this.time / (float)this.totTime * 3.0f);
            GlStateManager.func_179141_d();
            GL11.glEnable((int)3042);
            RenderHelper.func_74518_a();
            float scale = 0.125f;
            if (t < 5.0f) {
                scale *= t / 5.0f;
            }
            if (t >= (float)(this.totTime - 5)) {
                scale *= 1.0f - (t - (float)this.totTime + 5.0f) / 5.0f;
            }
            GL11.glColor4f((float)ColorHelper.getRed((int)this.color), (float)ColorHelper.getGreen((int)this.color), (float)ColorHelper.getBlue((int)this.color), (float)(0.9f * ColorHelper.getAlpha((int)this.color)));
            for (int i = 0; i < 3; ++i) {
                float ps = i == 0 ? scale : (i == 2 ? (float)((Math.sin((float)(this.hashCode() % 90) + t / 2.0f) + 1.0) / 2.5 * (double)scale) : scale / 2.0f);
                GL11.glPushMatrix();
                GL11.glBlendFunc((int)770, (int)(i == 0 ? 771 : 772));
                GL11.glTranslated((double)(cx - (double)(64.0f * ps / 2.0f)), (double)(cy - (double)(64.0f * ps / 2.0f)), (double)5.0);
                GL11.glScaled((double)ps, (double)ps, (double)ps);
                RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (double)tx, (double)0.0, (double)64.0, (double)64.0);
                GL11.glPopMatrix();
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
        }
    }
}

