/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.client.rendering.ote;

import com.zeitheron.hammercore.client.utils.TexturePixelGetter;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.client.rendering.OTEffect;
import org.zeith.improvableskills.client.rendering.OnTopEffects;
import org.zeith.improvableskills.client.rendering.ote.OTEAbility;
import org.zeith.improvableskills.client.rendering.ote.OTESkillSparkle;
import org.zeith.improvableskills.utils.Trajectory;

public class OTEItemAbilityScroll
extends OTEffect {
    public ItemStack item;
    private double tx;
    private double ty;
    private int totTime;
    private int prevTime;
    private int time;
    public double[] xPoints;
    public double[] yPoints;
    public PlayerAbilityBase[] abilities;

    public OTEItemAbilityScroll(double x, double y, double tx, double ty, int time, ItemStack item, PlayerAbilityBase ... skills) {
        this.renderGui = false;
        this.abilities = skills;
        this.totTime = time;
        this.x = this.prevX = x;
        this.y = this.prevY = y;
        this.tx = tx;
        this.ty = ty;
        this.item = item;
        double[][] path = Trajectory.makeBroken2DTrajectory(x, y, tx, ty, time, (float)(System.currentTimeMillis() % 1000000L) / 90.0f);
        this.xPoints = path[0];
        this.yPoints = path[1];
    }

    @Override
    public void resize(ScaledResolution prev, ScaledResolution nev) {
        super.resize(prev, nev);
        this.tx = OTEItemAbilityScroll.handleResizeXd(this.tx, prev, nev);
        this.ty = OTEItemAbilityScroll.handleResizeYd(this.ty, prev, nev);
        this.xPoints = OTEItemAbilityScroll.handleResizeXdv(this.xPoints, prev, nev);
        this.yPoints = OTEItemAbilityScroll.handleResizeYdv(this.yPoints, prev, nev);
    }

    @Override
    public void update() {
        super.update();
        this.prevTime = this.time;
        int tt = this.xPoints.length;
        int cframe = Math.min(Math.round((float)this.time / (float)this.totTime * (float)tt), this.xPoints.length - 1);
        this.x = this.xPoints[cframe];
        this.y = this.yPoints[cframe];
        ++this.time;
        int spawnTime = 10 * this.abilities.length;
        if (this.time >= this.totTime) {
            int cur = (this.time - this.totTime) / 10;
            if ((this.time - this.totTime) % 10 == 0 && cur < this.abilities.length) {
                Minecraft mc = Minecraft.func_71410_x();
                ScaledResolution sr = new ScaledResolution(mc);
                OnTopEffects.effects.add(new OTEAbility(this.x, this.y, sr.func_78326_a() - 12, sr.func_78328_b() - 12, 40, this.abilities[cur]));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_190021_aL, (float)1.0f));
            }
        } else {
            int[] rgbs;
            int lcf = Math.max(cframe - 10, 0);
            Random r = new Random();
            if (r.nextBoolean() && (rgbs = TexturePixelGetter.getAllColors((String)(this.abilities[r.nextInt((int)this.abilities.length)].tex.toUV((boolean)true).path + ""))).length > 0) {
                int col = rgbs[r.nextInt(rgbs.length)];
                double tx = this.xPoints[lcf] + (double)((float)(r.nextInt(16) - r.nextInt(16)) / 2.0f);
                double ty = this.yPoints[cframe] + (double)((float)(r.nextInt(16) - r.nextInt(16)) / 2.0f);
                OnTopEffects.effects.add(new OTESkillSparkle(this.x - (double)r.nextInt(8) + (double)r.nextInt(8), this.y - (double)r.nextInt(8) + (double)r.nextInt(8), tx, ty, 20, col));
            }
        }
        if (this.time >= this.totTime + spawnTime) {
            this.setExpired();
        }
    }

    @Override
    public void render(float partialTime) {
        double cx = this.prevX + (this.x - this.prevX) * (double)partialTime;
        double cy = this.prevY + (this.y - this.prevY) * (double)partialTime;
        float t = (float)this.prevTime + partialTime;
        int tx = 64 * (int)((float)this.time / (float)this.totTime * 3.0f);
        GlStateManager.func_179141_d();
        RenderHelper.func_74518_a();
        float scale = 1.0f;
        if (t >= (float)(this.totTime + 10 * this.abilities.length - 5)) {
            scale *= 1.0f - (t - (float)this.totTime + 5.0f - (float)(10 * this.abilities.length)) / 5.0f;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)(cx - (double)(16.0f * scale / 2.0f)), (double)(cy - (double)(16.0f * scale / 2.0f)), (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(this.item, 0, 0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

