/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.client.rendering.ote;

import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.opengl.GL11;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.client.rendering.OTEffect;
import org.zeith.improvableskills.utils.Trajectory;

public class OTEAbility
extends OTEffect {
    public PlayerAbilityBase item;
    private double tx;
    private double ty;
    private int totTime;
    private int prevTime;
    private int time;
    public double[] xPoints;
    public double[] yPoints;

    public OTEAbility(double x, double y, double tx, double ty, int time, PlayerAbilityBase item) {
        this.renderGui = false;
        this.totTime = time + 5;
        this.x = this.prevX = x;
        this.y = this.prevY = y;
        this.tx = tx;
        this.ty = ty;
        this.item = item;
        double[][] path = Trajectory.makeBroken2DTrajectory(x, y, tx, ty, time, (float)(System.currentTimeMillis() % 1000000L) / 100.0f, 5.0f);
        this.xPoints = path[0];
        this.yPoints = path[1];
        x = this.xPoints[0];
        y = this.yPoints[0];
    }

    @Override
    public void resize(ScaledResolution prev, ScaledResolution nev) {
        super.resize(prev, nev);
        this.tx = OTEAbility.handleResizeXd(this.tx, prev, nev);
        this.ty = OTEAbility.handleResizeYd(this.ty, prev, nev);
        this.xPoints = OTEAbility.handleResizeXdv(this.xPoints, prev, nev);
        this.yPoints = OTEAbility.handleResizeYdv(this.yPoints, prev, nev);
    }

    @Override
    public void update() {
        super.update();
        this.prevTime = this.time;
        int tt = this.xPoints.length;
        if (this.time > 5) {
            int cframe = Math.round((float)(this.time - 5) / (float)(this.totTime - 5) * (float)tt);
            this.x = this.xPoints[cframe];
            this.y = this.yPoints[cframe];
        }
        ++this.time;
        if (this.time >= this.totTime) {
            this.setExpired();
        }
    }

    @Override
    public void render(float partialTime) {
        double cx = this.prevX + (this.x - this.prevX) * (double)partialTime;
        double cy = this.prevY + (this.y - this.prevY) * (double)partialTime;
        float t = (float)this.prevTime + partialTime;
        GlStateManager.func_179141_d();
        RenderHelper.func_74518_a();
        float scale = 1.0f;
        if (t < 5.0f) {
            scale *= t / 5.0f;
        }
        if (t >= (float)(this.totTime - 5)) {
            scale *= 1.0f - (t - (float)this.totTime + 5.0f) / 5.0f;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.item.tex.toUV(false).render(this.x - (double)((scale *= 16.0f) / 2.0f), this.y - (double)(scale / 2.0f), (double)scale, (double)scale);
        GL11.glPopMatrix();
    }
}

