/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.client.rendering;

import com.zeitheron.hammercore.lib.zlib.tuple.TwoTuple;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.zeith.improvableskills.api.registry.PageletBase;
import org.zeith.improvableskills.client.gui.base.GuiTabbable;
import org.zeith.improvableskills.client.rendering.OTEffect;

@SideOnly(value=Side.CLIENT)
public class OnTopEffects {
    public static List<OTEffect> effects = new ArrayList<OTEffect>();
    public ScaledResolution resolution;

    @SubscribeEvent
    public void renderScreen(RenderGameOverlayEvent e) {
        if (!(e instanceof RenderGameOverlayEvent.Post)) {
            return;
        }
        if (e.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        float pt = Minecraft.func_71410_x().func_184121_ak();
        for (int i = 0; i < effects.size(); ++i) {
            OTEffect eff = effects.get(i);
            if (eff.expired || !eff.renderHud) continue;
            eff.render(pt);
        }
    }

    @SubscribeEvent
    public void renderOnTop(GuiScreenEvent.DrawScreenEvent.Post e) {
        GuiScreen gs = e.getGui();
        int mx = e.getMouseX();
        int my = e.getMouseY();
        float pt = Minecraft.func_71410_x().func_184121_ak();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        for (int i = 0; i < effects.size(); ++i) {
            OTEffect eff = effects.get(i);
            if (eff.expired || !eff.renderGui) continue;
            eff.currentGui = gs;
            eff.mouseX = mx;
            eff.mouseY = my;
            eff.render(pt);
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            for (int i = 0; i < effects.size(); ++i) {
                OTEffect eff = effects.get(i);
                if (eff.expired) {
                    effects.remove(i);
                    continue;
                }
                eff.update();
            }
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            if (this.resolution == null) {
                this.resolution = sr;
            }
            if (sr.func_78328_b() != this.resolution.func_78328_b() || sr.func_78326_a() != this.resolution.func_78326_a()) {
                for (int i = 0; i < effects.size(); ++i) {
                    OTEffect eff = effects.get(i);
                    eff.resize(this.resolution, sr);
                }
            }
            this.resolution = sr;
            IForgeRegistry pagelets = GameRegistry.findRegistry(PageletBase.class);
            for (ResourceLocation key : GuiTabbable.EXTENSIONS.keySet()) {
                TwoTuple.Atomic<Float, Float> val = GuiTabbable.EXTENSIONS.get(key);
                Float target = (Float)val.get1();
                Float current = (Float)val.get2();
                float dif = Math.max(-0.125f, Math.min(0.125f, target.floatValue() - current.floatValue()));
                val.set2((Object)Float.valueOf(current.floatValue() + dif));
                PageletBase base = (PageletBase)pagelets.getValue(key);
                if (!((double)target.floatValue() < 0.5) || base == null || !base.doesPop()) continue;
                float v = (float)((System.currentTimeMillis() + (long)Math.abs(key.hashCode())) % 5000L) / 5000.0f;
                if (!(current.floatValue() < v)) continue;
                val.set2((Object)Float.valueOf(v));
            }
        }
    }
}

