/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api.treasures.drops;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.zeith.improvableskills.api.treasures.TreasureContext;
import org.zeith.improvableskills.api.treasures.TreasureDropBase;
import org.zeith.improvableskills.api.treasures.drops.Stackable;

public class TreasureSandDropItem
extends TreasureDropBase {
    public NonNullList<Stackable> items = NonNullList.func_191196_a();
    public int minLvl;

    public TreasureSandDropItem() {
    }

    public TreasureSandDropItem(int lvl, Stackable ... items) {
        this.minLvl = lvl;
        for (Stackable s : items) {
            this.items.add((Object)s);
        }
    }

    public TreasureSandDropItem(int lvl, Object ... items) {
        this.minLvl = lvl;
        for (int i = 0; i < items.length; ++i) {
            Object o = items[i];
            if (o == null) {
                throw new NullPointerException("Item at index " + i + " is null.");
            }
            if (o instanceof Item) {
                this.items.add((Object)Stackable.of(new ItemStack((Item)o)));
                continue;
            }
            if (o instanceof Block) {
                this.items.add((Object)Stackable.of(new ItemStack((Block)o)));
                continue;
            }
            if (o instanceof ItemStack) {
                this.items.add((Object)Stackable.of(((ItemStack)o).func_77946_l()));
                continue;
            }
            if (o instanceof Stackable) {
                this.items.add((Object)((Stackable)o));
                continue;
            }
            throw new IllegalArgumentException("Item at index " + i + " is not supported!");
        }
    }

    @Override
    public void drop(TreasureContext ctx, List<ItemStack> drops) {
        for (Stackable s : this.items) {
            if (s == null) continue;
            drops.add(s.transform(ctx.getRNG()));
        }
    }

    @Override
    public TreasureDropBase copy() {
        TreasureSandDropItem l = (TreasureSandDropItem)super.copy();
        l.items = NonNullList.func_191196_a();
        l.minLvl = this.minLvl;
        l.items.addAll(this.items);
        return this;
    }

    @Override
    public boolean canDrop(TreasureContext ctx) {
        return ctx.getCaller() != null && ctx.getCaller().getRegistryName().toString().equals("improvableskills:treasure_sands") && ctx.getData().getSkillLevel(ctx.getCaller()) >= this.minLvl;
    }
}

