/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api.treasures;

import com.zeitheron.hammercore.utils.WorldLocation;
import java.util.Random;
import javax.annotation.Nonnull;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;

public class TreasureContext {
    private PlayerSkillBase caller;
    private PlayerSkillData data;
    private WorldLocation loc;
    private Random rand;

    private TreasureContext() {
    }

    public PlayerSkillBase getCaller() {
        return this.caller;
    }

    public PlayerSkillData getData() {
        return this.data;
    }

    public WorldLocation getLocation() {
        return this.loc;
    }

    @Nonnull
    public Random getRNG() {
        if (this.rand == null) {
            this.rand = new Random();
        }
        return this.rand;
    }

    public static class Builder {
        private PlayerSkillBase base;
        private PlayerSkillData data;
        private WorldLocation loc;
        private Random rng;

        public Builder withCaller(PlayerSkillBase base) {
            this.base = base;
            return this;
        }

        public Builder withData(PlayerSkillData data) {
            this.data = data;
            return this;
        }

        public Builder withLocation(WorldLocation loc) {
            this.loc = loc;
            return this;
        }

        public Builder withRNG(Random rng) {
            this.rng = rng;
            return this;
        }

        public TreasureContext build() {
            if (this.data == null) {
                throw new IllegalStateException("Context must have data about caller!");
            }
            TreasureContext c = new TreasureContext();
            c.caller = this.base;
            c.data = this.data;
            c.loc = this.loc;
            c.rand = this.rng;
            return c;
        }
    }
}

