/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api.treasures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.zeith.improvableskills.api.treasures.TreasureContext;
import org.zeith.improvableskills.api.treasures.TreasureDropBase;
import org.zeith.improvableskills.api.treasures.TreasureRegistry;

public class DropUtil {
    public static Random RANDOM = new Random();

    public static TreasureDropBase chooseDrop(TreasureContext ctx) {
        RANDOM = ctx.getRNG();
        return DropUtil.chooseDrop(TreasureRegistry.allDrops(), ctx);
    }

    public static TreasureDropBase chooseDrop(List<TreasureDropBase> allDrops, TreasureContext ctx) {
        ArrayList<TreasureDropBase> preDrops = new ArrayList<TreasureDropBase>();
        boolean lowestLuck = false;
        for (TreasureDropBase d : allDrops) {
            if (!d.canDrop(ctx)) continue;
            preDrops.add(d.copy());
        }
        float levelIncrease = 129.87013f;
        float weightTotal = 0.0f;
        ArrayList<Float> weightPoints = new ArrayList<Float>();
        weightPoints.add(Float.valueOf(0.0f));
        for (TreasureDropBase drop : preDrops) {
            weightPoints.add(Float.valueOf(weightTotal += drop.getChance() * 100.0f));
        }
        float randomIndex = RANDOM.nextFloat() * weightTotal;
        TreasureDropBase chosenDrop = DropUtil.getDropByWeight(preDrops, weightPoints, randomIndex);
        return chosenDrop;
    }

    private static TreasureDropBase getDropByWeight(List<TreasureDropBase> drops, ArrayList<Float> weightPoints, float randomIndex) {
        for (int a = 0; a < drops.size(); ++a) {
            if (!(randomIndex >= weightPoints.get(a).floatValue()) || !(randomIndex < weightPoints.get(a + 1).floatValue())) continue;
            return drops.get(a);
        }
        return null;
    }
}

