/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api.registry;

import com.zeitheron.hammercore.utils.XPUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.api.SkillCostConfig;
import org.zeith.improvableskills.api.SkillTex;
import org.zeith.improvableskills.api.loot.SkillLoot;

public class PlayerSkillBase
extends IForgeRegistryEntry.Impl<PlayerSkillBase> {
    private SkillLoot loot;
    public SkillCostConfig xpCalculator = new SkillCostConfig(1);
    public SkillTex<PlayerSkillBase> tex = new SkillTex<PlayerSkillBase>(this);
    public int maxLvl;
    protected boolean hasScroll;
    protected boolean genScroll;

    public PlayerSkillBase(int maxLvl) {
        this.maxLvl = maxLvl;
    }

    public void tick(PlayerSkillData data) {
    }

    public String getUnlocalizedName() {
        return "skill." + this.getRegistryName().toString();
    }

    public String getUnlocalizedName(PlayerSkillData data) {
        return this.getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName(PlayerSkillData data) {
        return I18n.func_135052_a((String)(this.getUnlocalizedName(data) + ".name"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)(this.getUnlocalizedName() + ".name"), (Object[])new Object[0]);
    }

    public String getUnlocalizedDesc(PlayerSkillData data) {
        return "skill." + this.getRegistryName().toString();
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedDesc(PlayerSkillData data) {
        return I18n.func_135052_a((String)(this.getUnlocalizedDesc(data) + ".desc"), (Object[])new Object[0]);
    }

    public int getXPToUpgrade(PlayerSkillData data, short targetLvl) {
        return this.xpCalculator.getXPToUpgrade(data, targetLvl);
    }

    public boolean canUpgrade(PlayerSkillData data) {
        short clvl = data.getSkillLevel(this);
        return clvl < this.maxLvl && (XPUtil.getXPTotal((EntityPlayer)data.player) >= this.getXPToUpgrade(data, (short)(clvl + 1)) || data.player.field_71075_bZ.field_75098_d);
    }

    public void onUpgrade(short oldLvl, short newLvl, PlayerSkillData data) {
        if (oldLvl > newLvl) {
            XPUtil.setPlayersExpTo((EntityPlayer)data.player, (int)(XPUtil.getXPTotal((EntityPlayer)data.player) + this.getXPToDowngrade(data, newLvl)));
        } else {
            XPUtil.setPlayersExpTo((EntityPlayer)data.player, (int)(XPUtil.getXPTotal((EntityPlayer)data.player) - this.getXPToUpgrade(data, newLvl)));
        }
    }

    public boolean isDowngradable(PlayerSkillData data) {
        return true;
    }

    public int getXPToDowngrade(PlayerSkillData data, short to) {
        return this.getXPToUpgrade(data, to);
    }

    public void onDowngrade(PlayerSkillData data, short from) {
    }

    public EnumScrollState getScrollState() {
        return this.hasScroll ? (this.maxLvl == 1 ? EnumScrollState.SPECIAL : EnumScrollState.NORMAL) : EnumScrollState.NONE;
    }

    public SkillLoot getLoot() {
        SkillLoot skillLoot = this.hasScroll && this.genScroll ? (this.loot == null ? (this.loot = new SkillLoot(this)) : this.loot) : null;
        return skillLoot;
    }

    public boolean isVisible(PlayerSkillData data) {
        return !this.hasScroll || data.stat_scrolls.contains(this.getRegistryName().toString());
    }

    public int getColor() {
        return this.getRegistryName().toString().hashCode();
    }

    public static enum EnumScrollState {
        NONE,
        NORMAL,
        SPECIAL;


        public boolean hasScroll() {
            return this.ordinal() > 0;
        }
    }
}

