/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api.loot;

import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import org.zeith.improvableskills.ImprovableSkillsMod;
import org.zeith.improvableskills.api.loot.RandomBoolean;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.items.ItemSkillScroll;
import org.zeith.improvableskills.utils.loot.LootConditionSkillScroll;
import org.zeith.improvableskills.utils.loot.LootEntryItemStack;

public class SkillLoot {
    public final PlayerSkillBase skill;
    public Predicate<ResourceLocation> lootTableChecker = r -> false;
    public RandomBoolean chance = new RandomBoolean();

    public SkillLoot(PlayerSkillBase skill) {
        this.skill = skill;
    }

    public void setLootTable(ResourceLocation rl) {
        this.lootTableChecker = r -> r.equals((Object)rl);
    }

    public void addLootTable(ResourceLocation rl) {
        this.lootTableChecker = this.lootTableChecker.or(r -> rl.equals(r));
    }

    public void apply(LootTableLoadEvent table) {
        if (this.lootTableChecker != null && this.lootTableChecker.test(table.getName())) {
            ImprovableSkillsMod.LOG.info("Injecting scroll for skill '" + this.skill.getRegistryName().toString() + "' into LootTable '" + table.getName() + "'!");
            LootEntryItemStack entry = new LootEntryItemStack(ItemSkillScroll.of(this.skill), 2, 60, new LootFunction[0], new LootCondition[0], "improvableskills:" + this.skill.getRegistryName().toString() + "_scroll");
            LootPool pool1 = new LootPool(new LootEntry[]{entry}, new LootCondition[]{new LootConditionSkillScroll(this.skill, this.chance)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), this.skill.getRegistryName().toString() + "_skill_scroll");
            try {
                table.getTable().addPool(pool1);
            }
            catch (Throwable err) {
                ImprovableSkillsMod.LOG.error("Failed to inject scroll for skill '" + this.skill.getRegistryName().toString() + "' into LootTable '" + table.getName() + "'!!!");
                err.printStackTrace();
            }
        }
    }
}

