/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api;

import com.zeitheron.hammercore.cfg.file1132.io.ConfigEntryCategory;
import com.zeitheron.hammercore.utils.math.ExpressionEvaluator;
import com.zeitheron.hammercore.utils.math.functions.ExpressionFunction;
import net.minecraft.nbt.NBTTagCompound;
import org.zeith.improvableskills.api.PlayerSkillData;

public class SkillCostConfig
extends ExpressionFunction {
    public static final String DEF_FORMULA = "(%lvl%+1)^%xpv%";
    public String baseFormula = "(%lvl%+1)^%xpv%";
    public String formula = "(%lvl%+1)^%xpv%";
    public int xpValue;
    public String clientFormula;

    public SkillCostConfig(int xpValue) {
        super("skill");
        this.xpValue = xpValue;
    }

    public void load(ConfigEntryCategory cfg) {
        this.formula = cfg.getStringEntry("formula", this.baseFormula).setDescription("Cost calculator for this skill.\nAvailable variables:\n- %lvl% = the level we want to calculate XP value for.\n- %xpv% preset value (" + this.xpValue + ") for current skill.").getValue();
    }

    public void writeServerNBT(NBTTagCompound nbt) {
        if (this.formula != null) {
            nbt.func_74778_a("Formula", this.formula);
        }
    }

    public void readClientNBT(NBTTagCompound nbt) {
        this.resetClient();
        if (nbt.func_150297_b("Formula", 8)) {
            this.clientFormula = nbt.func_74779_i("Formula");
        }
    }

    public void resetClient() {
        this.clientFormula = null;
    }

    public int getXPToUpgrade(PlayerSkillData data, short targetLvl) {
        if (this.clientFormula != null) {
            String formula = this.clientFormula.replaceAll("%lvl%", Short.toString(targetLvl)).replaceAll("%xpv%", Integer.toString(this.xpValue));
            return (int)Math.ceil(ExpressionEvaluator.evaluateDouble((String)formula, (ExpressionFunction[])new ExpressionFunction[]{this}));
        }
        if (this.formula != null) {
            String formula = this.formula.replaceAll("%lvl%", Short.toString(targetLvl)).replaceAll("%xpv%", Integer.toString(this.xpValue));
            return (int)Math.ceil(ExpressionEvaluator.evaluateDouble((String)formula, (ExpressionFunction[])new ExpressionFunction[]{this}));
        }
        return (int)Math.pow(targetLvl + 1, this.xpValue);
    }
}

