/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api;

import com.zeitheron.hammercore.HammerCore;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.improvableskills.ImprovableSkillsMod;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.net.PacketSyncSkillData;
import org.zeith.improvableskills.proxy.SyncSkills;

public class PlayerSkillData {
    public static final Logger LOG = LogManager.getLogger((String)"ImprovableSkills-IO");
    public BigInteger storageXp = BigInteger.ZERO;
    public EntityPlayer player;
    public NBTTagCompound persistedData = new NBTTagCompound();
    public List<String> stat_scrolls = new ArrayList<String>();
    public List<String> abilities = new ArrayList<String>();
    public boolean hasCraftedSkillBook = false;
    private boolean hcsbPrev = false;
    public Map<String, Short> stats = new HashMap<String, Short>();
    public float enchantPower = 0.0f;
    private boolean isInIO = false;
    public int prevDim;

    public EntityPlayer getPlayer() {
        if (this == SyncSkills.CLIENT_DATA) {
            return HammerCore.renderProxy.getClientPlayer();
        }
        return this.player;
    }

    public PlayerSkillData toCurrent(EntityPlayer playerReference) {
        if (this.player != playerReference) {
            this.player = playerReference;
        }
        return this;
    }

    public PlayerSkillData(EntityPlayer player) {
        this.player = player;
    }

    public short getSkillLevel(PlayerSkillBase stat) {
        return this.stats.getOrDefault(stat.getRegistryName().toString(), (short)0);
    }

    public void handleTick() {
        long start = System.currentTimeMillis();
        if (this.player == null) {
            return;
        }
        HashMap<String, Long> updates = new HashMap<String, Long>();
        List skills = GameRegistry.findRegistry(PlayerSkillBase.class).getValues();
        for (int i = 0; i < skills.size(); ++i) {
            long start0 = System.currentTimeMillis();
            ((PlayerSkillBase)((Object)skills.get(i))).tick(this);
            updates.put(((PlayerSkillBase)((Object)skills.get(i))).getRegistryName().toString(), System.currentTimeMillis() - start0);
        }
        if (!this.player.field_70170_p.field_72995_K && this.prevDim != this.player.field_70170_p.field_73011_w.getDimension()) {
            this.prevDim = this.player.field_70170_p.field_73011_w.getDimension();
            this.sync();
        }
        if (!this.player.field_70170_p.field_72995_K && this.hcsbPrev != this.hasCraftedSkillBook && !this.hcsbPrev) {
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.improvableskills.guide", new Object[0]));
            this.hcsbPrev = true;
            this.sync();
        }
        this.hcsbPrev = this.hasCraftedSkillBook;
        long end = System.currentTimeMillis();
        if (end - start > 100L) {
            ImprovableSkillsMod.LOG.warn("Skill tick took too long! (" + (end - start) + "ms, expected <100 ms!). Time map: " + updates);
        }
    }

    public void sync() {
        if (!this.isInIO && this.player instanceof EntityPlayerMP && !this.player.field_70170_p.field_72995_K) {
            PacketSyncSkillData.sync((EntityPlayerMP)this.player);
        }
    }

    public void setSkillLevel(PlayerSkillBase stat, Number lvl) {
        this.stats.put(stat.getRegistryName().toString(), lvl.shortValue());
        this.sync();
    }

    public boolean hasCraftedSkillsBook() {
        return this.hasCraftedSkillBook;
    }

    public static PlayerSkillData deserialize(EntityPlayer player, NBTTagCompound nbt) {
        int i;
        PlayerSkillData data = new PlayerSkillData(player);
        data.isInIO = true;
        IForgeRegistry reg = GameRegistry.findRegistry(PlayerSkillBase.class);
        NBTTagList lvls = nbt.func_150295_c("Levels", 10);
        for (int i2 = 0; i2 < lvls.func_74745_c(); ++i2) {
            NBTTagCompound tag = lvls.func_150305_b(i2);
            String sstat = tag.func_74779_i("Id");
            PlayerSkillBase stat = (PlayerSkillBase)reg.getValue(new ResourceLocation(sstat));
            if (stat == null) {
                LOG.warn("[LOAD] Skill '" + sstat + "' wasn't found. Maybe you removed the addon? Skipping unregistered skill.");
                continue;
            }
            data.setSkillLevel(stat, tag.func_74765_d("Lvl"));
        }
        NBTTagList list = nbt.func_150295_c("Scrolls", 8);
        for (i = 0; i < list.func_74745_c(); ++i) {
            data.stat_scrolls.add(list.func_150307_f(i));
        }
        list = nbt.func_150295_c("Abilities", 8);
        for (i = 0; i < list.func_74745_c(); ++i) {
            data.abilities.add(list.func_150307_f(i));
        }
        data.enchantPower = nbt.func_74760_g("EnchantPower");
        data.persistedData = nbt.func_74775_l("Persisted");
        if (data.persistedData.func_150297_b("BankXP", 8)) {
            try {
                data.storageXp = new BigInteger(data.persistedData.func_74779_i("BankXP"), 36);
            }
            catch (Throwable err) {
                data.storageXp = BigInteger.ZERO;
            }
        }
        data.hasCraftedSkillBook = data.persistedData.func_74767_n("SkillBookCrafted");
        data.hcsbPrev = data.persistedData.func_74767_n("PrevSkillBookCrafted");
        data.isInIO = false;
        return data;
    }

    public NBTTagCompound serialize() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.persistedData.func_74778_a("BankXP", this.storageXp.toString(36));
        this.persistedData.func_74757_a("SkillBookCrafted", this.hasCraftedSkillBook);
        this.persistedData.func_74757_a("PrevSkillBookCrafted", this.hcsbPrev);
        IForgeRegistry reg = GameRegistry.findRegistry(PlayerSkillBase.class);
        nbt.func_74782_a("Persisted", (NBTBase)this.persistedData);
        nbt.func_74776_a("EnchantPower", this.enchantPower);
        NBTTagList list = new NBTTagList();
        for (String sstat : this.stats.keySet()) {
            PlayerSkillBase stat = (PlayerSkillBase)reg.getValue(new ResourceLocation(sstat));
            if (stat == null) {
                LOG.warn("[SAVE] Skill '" + sstat + "' wasn't found. Maybe you removed the addon? Skipping unregistered skill.");
                continue;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Id", stat.getRegistryName().toString());
            tag.func_74777_a("Lvl", this.getSkillLevel(stat));
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Levels", (NBTBase)list);
        list = new NBTTagList();
        for (String scroll : this.stat_scrolls) {
            list.func_74742_a((NBTBase)new NBTTagString(scroll));
        }
        nbt.func_74782_a("Scrolls", (NBTBase)list);
        list = new NBTTagList();
        for (String scroll : this.abilities) {
            list.func_74742_a((NBTBase)new NBTTagString(scroll));
        }
        nbt.func_74782_a("Abilities", (NBTBase)list);
        return nbt;
    }
}

