/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api;

import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.util.DamageSource;

public class DamageSourceProcessor {
    @Nullable
    public static EntityPlayer getAttackerAsPlayer(DamageSource src) {
        return (EntityPlayer)WorldUtil.cast((Object)(src != null ? src.func_76346_g() : src), EntityPlayer.class);
    }

    @Nonnull
    public static DamageType getDamageType(DamageSource src) {
        if (src == null) {
            return DamageType.UNKNOWN;
        }
        for (DamageType t : DamageType.TYPES) {
            if (!t.isThisType(src)) continue;
            return t;
        }
        return DamageType.UNKNOWN;
    }

    public static boolean isMinionEntity(Entity ent) {
        return DamageSourceProcessor.getMinionOwner(ent) != null;
    }

    public static boolean isAlchemicalEntity(Entity ent) {
        return DamageSourceProcessor.getAlchemicalOwner(ent) != null;
    }

    public static boolean isRangedDamage(DamageSource src) {
        return DamageSourceProcessor.getRangedOwner(src) != null;
    }

    public static EntityPlayer getMinionOwner(Entity ent) {
        if (ent instanceof IEntityOwnable && ((IEntityOwnable)ent).func_70902_q() instanceof EntityPlayer) {
            return (EntityPlayer)((IEntityOwnable)ent).func_70902_q();
        }
        return null;
    }

    public static EntityPlayer getAlchemicalOwner(Entity ent) {
        if (ent instanceof EntityPotion && ((EntityPotion)ent).func_85052_h() instanceof EntityPlayer) {
            return (EntityPlayer)((EntityPotion)ent).func_85052_h();
        }
        return null;
    }

    public static EntityPlayer getRangedOwner(DamageSource ds) {
        if (DamageSourceProcessor.getAlchemicalOwner(ds.func_76364_f()) != null) {
            return null;
        }
        if (ds.func_76364_f() instanceof IProjectile && ds.func_76346_g() instanceof EntityPlayer) {
            return (EntityPlayer)ds.func_76346_g();
        }
        return null;
    }

    public static EntityPlayer getMeleeAttacker(DamageSource ds) {
        if (DamageSourceProcessor.getDamageType(ds) == DamageType.MELEE) {
            return (EntityPlayer)WorldUtil.cast((Object)ds.func_76346_g(), EntityPlayer.class);
        }
        return null;
    }

    public static class DamageType {
        private static final List<DamageType> TYPES = new ArrayList<DamageType>();
        private static DamageType[] arTypes;
        public static final DamageType MELEE;
        public static final DamageType RANGED;
        public static final DamageType MINION;
        public static final DamageType MAGIC;
        public static final DamageType ALCHEMICAL;
        public static final DamageType UNKNOWN;
        private final Predicate<DamageSource> test;

        public DamageType(Predicate<DamageSource> test) {
            TYPES.add(this);
            arTypes = TYPES.toArray(new DamageType[TYPES.size()]);
            this.test = test;
        }

        public boolean isThisType(DamageSource src) {
            return this.test.test(src);
        }

        public static DamageType[] getTypes() {
            return arTypes;
        }

        static {
            MELEE = new DamageType(d -> d.func_76346_g() == d.func_76364_f() && d.func_76346_g() instanceof EntityPlayer);
            RANGED = new DamageType(d -> DamageSourceProcessor.isRangedDamage(d));
            MINION = new DamageType(d -> DamageSourceProcessor.isMinionEntity(d.func_76346_g()));
            MAGIC = new DamageType(d -> !DamageSourceProcessor.isAlchemicalEntity(d.func_76364_f()) && d.func_82725_o());
            ALCHEMICAL = new DamageType(d -> DamageSourceProcessor.isAlchemicalEntity(d.func_76364_f()));
            UNKNOWN = new DamageType(d -> false);
        }
    }
}

