/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills;

import com.google.common.base.Predicates;
import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.lib.zlib.tuple.OneTuple;
import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.zeith.improvableskills.ImprovableSkillsMod;
import org.zeith.improvableskills.api.DamageSourceProcessor;
import org.zeith.improvableskills.api.IDigSpeedAffectorSkill;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.data.PlayerDataManager;
import org.zeith.improvableskills.init.SkillsIS;
import org.zeith.improvableskills.items.ItemSkillsBook;
import org.zeith.improvableskills.net.PacketSyncSkillData;
import org.zeith.improvableskills.proxy.SyncSkills;

@MCFBus
public class SkillEvents {
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            PlayerDataManager.handleDataSafely(e.player, PlayerSkillData::handleTick);
        }
    }

    @SubscribeEvent
    public void crafting(PlayerEvent.ItemCraftedEvent e) {
        if (e.player instanceof EntityPlayerMP && !e.player.field_70170_p.field_72995_K && !e.crafting.func_190926_b() && e.crafting.func_77973_b() instanceof ItemSkillsBook) {
            PlayerSkillData data = PlayerDataManager.getDataFor(e.player);
            if (data == null) {
                return;
            }
            data.hasCraftedSkillBook = true;
            PacketSyncSkillData.sync((EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            PlayerSkillData data;
            EntityPlayer p = (EntityPlayer)e.getEntityLiving();
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data == null || data.player == null) {
                return;
            }
            ItemStack item = p.func_184614_ca();
            OneTuple.Atomic tot = new OneTuple.Atomic((Object)Float.valueOf(1.0f));
            ImprovableSkillsMod.getSkills().getValuesCollection().stream().map(s -> (IDigSpeedAffectorSkill)WorldUtil.cast((Object)s, IDigSpeedAffectorSkill.class)).filter((Predicate<IDigSpeedAffectorSkill>)Predicates.notNull()).forEach(d -> tot.set((Object)Float.valueOf(((Float)tot.get()).floatValue() + d.getDigMultiplier(item, e.getPos(), data))));
            e.setNewSpeed(e.getNewSpeed() * ((Float)tot.get()).floatValue());
        }
    }

    @SubscribeEvent
    public void fall(LivingFallEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            PlayerSkillData data;
            EntityPlayer p = (EntityPlayer)e.getEntityLiving();
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data == null) {
                return;
            }
            short softLandingStatLevel = data.getSkillLevel(SkillsIS.SOFT_LANDING);
            float reduce = Math.min(0.5f, Math.max(0.25f, (float)softLandingStatLevel / (float)SkillsIS.SOFT_LANDING.maxLvl));
            reduce = 1.0f - reduce;
            if (softLandingStatLevel > 0) {
                e.setDistance(e.getDistance() * reduce);
                p.field_70143_R *= reduce;
                e.setDamageMultiplier(e.getDamageMultiplier() * reduce);
                return;
            }
        }
    }

    @SubscribeEvent
    public void jump(LivingEvent.LivingJumpEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            PlayerSkillData data;
            EntityPlayer p = (EntityPlayer)e.getEntityLiving();
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data == null) {
                return;
            }
            short leaper = data.getSkillLevel(SkillsIS.LEAPER);
            if (leaper > 0) {
                p.field_70181_x *= (double)(1.0f + (float)leaper / (float)SkillsIS.LEAPER.maxLvl * 0.75f);
            }
        }
    }

    @SubscribeEvent
    public void blockBroken(BlockEvent.BreakEvent e) {
        PlayerSkillData data;
        EntityPlayer p = e.getPlayer();
        float xp = e.getExpToDrop();
        PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
        if (data == null || xp <= 0.0f) {
            return;
        }
        float xpp = (float)data.getSkillLevel(SkillsIS.XP_PLUS) / (float)SkillsIS.XP_PLUS.maxLvl;
        e.setExpToDrop(MathHelper.func_76141_d((float)(xp + p.field_70170_p.field_73012_v.nextFloat() * xp * xpp)));
    }

    @SubscribeEvent
    public void killEntity(LivingExperienceDropEvent e) {
        PlayerSkillData data;
        EntityLivingBase die = e.getEntityLiving();
        float xp = e.getDroppedExperience();
        if (die instanceof EntityPlayer || xp <= 0.0f) {
            return;
        }
        EntityPlayer p = e.getAttackingPlayer();
        if (p == null) {
            return;
        }
        PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
        if (data == null) {
            return;
        }
        float xpp = (float)data.getSkillLevel(SkillsIS.XP_PLUS) / (float)SkillsIS.XP_PLUS.maxLvl;
        e.setDroppedExperience(MathHelper.func_76141_d((float)(xp + p.field_70170_p.field_73012_v.nextFloat() * xp * xpp)));
    }

    @SubscribeEvent
    public void babyEntitySpawn(BabyEntitySpawnEvent e) {
        PlayerSkillData data;
        EntityPlayer p = e.getCausedByPlayer();
        if (e.getChild() instanceof EntityVillager || p == null || p instanceof FakePlayer) {
            return;
        }
        PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
        if (data == null) {
            return;
        }
        short xpp = data.getSkillLevel(SkillsIS.XP_PLUS);
        if (xpp > 0) {
            int x = p.field_70170_p.field_73012_v.nextInt(xpp + 1);
            if (x == 0) {
                return;
            }
            EntityLiving c = e.getParentA();
            c.field_70170_p.func_72838_d((Entity)new EntityXPOrb(c.field_70170_p, c.field_70165_t, c.field_70163_u, c.field_70161_v, x));
        }
    }

    @SubscribeEvent
    public void itemFished(ItemFishedEvent e) {
        PlayerSkillData data;
        EntityPlayer p = e.getEntityPlayer();
        NonNullList drops = e.getDrops();
        if (p == null || p instanceof FakePlayer) {
            return;
        }
        PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
        if (data == null) {
            return;
        }
        short xpp = data.getSkillLevel(SkillsIS.XP_PLUS);
        if (xpp > 0) {
            for (ItemStack drop : drops) {
                int x = p.field_70170_p.field_73012_v.nextInt(xpp + 1);
                if (x == 0) continue;
                p.field_70170_p.func_72838_d((Entity)new EntityXPOrb(p.field_70170_p, p.field_70165_t, p.field_70163_u, p.field_70161_v, x));
            }
        }
    }

    @SubscribeEvent
    public void dropsEvent(BlockEvent.HarvestDropsEvent e) {
        EntityPlayer p = e.getHarvester();
        BlockPos pos = e.getPos();
        World w = e.getWorld();
        List drops = e.getDrops();
        SkillsIS.TREASURE_OF_SANDS.handleDropAdd(e, PlayerDataManager.getDataFor(p), drops);
    }

    @SubscribeEvent
    public void attackHook(LivingHurtEvent e) {
        float pp;
        short melee;
        PlayerSkillData data;
        EntityPlayer p;
        DamageSource ds = e.getSource();
        if (e.getEntityLiving() instanceof EntityPlayer && ds == DamageSource.field_76379_h) {
            p = (EntityPlayer)e.getEntityLiving();
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data != null && data.getSkillLevel(SkillsIS.SOFT_LANDING) >= SkillsIS.SOFT_LANDING.maxLvl && e.getAmount() >= p.func_110143_aJ()) {
                e.setAmount(p.func_110143_aJ() - 1.0f);
            }
        }
        if (ds != null && ds.func_76347_k() && e.getEntity() instanceof EntityPlayer) {
            p = (EntityPlayer)e.getEntity();
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data != null) {
                short obsSkin = data.getSkillLevel(SkillsIS.OBSIDIAN_SKIN);
                e.setAmount(e.getAmount() * (1.0f - (float)obsSkin / (float)SkillsIS.OBSIDIAN_SKIN.maxLvl + 0.2f));
            }
        }
        if (DamageSourceProcessor.getDamageType(ds) == DamageSourceProcessor.DamageType.MELEE && (p = DamageSourceProcessor.getMeleeAttacker(ds)) != null) {
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data != null) {
                melee = data.getSkillLevel(SkillsIS.DAMAGE_MELEE);
                pp = (float)melee / (float)SkillsIS.DAMAGE_MELEE.maxLvl;
                e.setAmount(e.getAmount() + e.getAmount() * pp / 2.0f + pp * 7.0f);
            }
        }
        if (DamageSourceProcessor.getDamageType(ds) == DamageSourceProcessor.DamageType.RANGED && (p = DamageSourceProcessor.getRangedOwner(ds)) != null) {
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data != null) {
                melee = data.getSkillLevel(SkillsIS.DAMAGE_RANGED);
                pp = (float)melee / (float)SkillsIS.DAMAGE_RANGED.maxLvl;
                e.setAmount(e.getAmount() + e.getAmount() * pp + (float)melee / 2.0f);
            }
        }
        if (DamageSourceProcessor.getDamageType(ds) == DamageSourceProcessor.DamageType.ALCHEMICAL) {
            EntityPlayer src = DamageSourceProcessor.getAlchemicalOwner(ds.func_76364_f());
            Entity hurt = e.getEntity();
            if (src != null) {
                PlayerSkillData dat;
                PlayerSkillData playerSkillData = dat = hurt.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(src);
                if (dat != null) {
                    short pp2 = dat.getSkillLevel(SkillsIS.ENDER_MANIPULATOR);
                }
            }
        }
        if (ds != null && e.getEntityLiving() instanceof EntityPlayer) {
            p = (EntityPlayer)e.getEntityLiving();
            PlayerSkillData playerSkillData = data = p.field_70170_p.field_72995_K ? SyncSkills.CLIENT_DATA : PlayerDataManager.getDataFor(p);
            if (data == null) {
                return;
            }
            short melee2 = data.getSkillLevel(SkillsIS.PVP);
            float pp3 = 1.0f - (float)melee2 / (float)SkillsIS.PVP.maxLvl;
            e.setAmount(e.getAmount() * Math.min(1.0f, 0.75f + pp3 / 4.0f));
        }
    }

    @SubscribeEvent
    public void enchLvl(EnchantmentLevelSetEvent e) {
        List players = e.getWorld().func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(e.getPos()).func_186662_g(9.0));
        for (EntityPlayerMP p : players) {
            if (!(p.field_71070_bA instanceof ContainerEnchantment)) continue;
            ContainerEnchantment enc = (ContainerEnchantment)p.field_71070_bA;
            if (e.getItem() != enc.field_75168_e.func_70301_a(0)) continue;
            int enchanter = ((Number)PlayerDataManager.handleDataSafely((EntityPlayer)p, data -> data.getSkillLevel(SkillsIS.ENCHANTER), 0)).intValue();
            if (enchanter > 0 && e.getLevel() != 0) {
                e.setLevel(Math.max(1, e.getLevel() - enchanter / 4));
            }
            return;
        }
    }

    @SubscribeEvent
    public void enderPort(EnderTeleportEvent e) {
        int lvl;
        EntityPlayerMP p = (EntityPlayerMP)WorldUtil.cast((Object)e.getEntityLiving(), EntityPlayerMP.class);
        if (p != null && (lvl = ((Number)PlayerDataManager.handleDataSafely((EntityPlayer)p, data -> data.getSkillLevel(SkillsIS.ENDER_MANIPULATOR), 0)).intValue()) > 0) {
            float prog = (float)lvl / (float)(SkillsIS.ENDER_MANIPULATOR.maxLvl - 1);
            if (prog > 1.0f) {
                e.setAttackDamage(e.getAttackDamage() / 10.0f);
                p.func_70691_i(1.0f);
            } else {
                e.setAttackDamage(e.getAttackDamage() * (1.0f - prog * 0.8f));
            }
        }
    }

    @SubscribeEvent
    public void respawn(PlayerEvent.PlayerRespawnEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)e.player;
            PacketSyncSkillData.sync(mp);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent e) {
        MinecraftServer mcs;
        if (e.phase == TickEvent.Phase.END && (mcs = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            PlayerDataManager.DATAS.keySet().removeIf(uuid -> {
                EntityPlayerMP mp = mcs.func_184103_al().func_177451_a(UUID.fromString(uuid));
                PlayerSkillData data = PlayerDataManager.DATAS.get(uuid);
                if (mp == null) {
                    return true;
                }
                data.player = mp;
                return false;
            });
        }
    }
}

