/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.gui.IGuiCallback;
import com.zeitheron.hammercore.event.PlayerLoadReadyEvent;
import com.zeitheron.hammercore.internal.GuiManager;
import com.zeitheron.hammercore.internal.SimpleRegistration;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.improvableskills.api.RecipesParchmentFragment;
import org.zeith.improvableskills.api.loot.RandomBoolean;
import org.zeith.improvableskills.api.registry.PageletBase;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.cfg.SkillsConfigs;
import org.zeith.improvableskills.cmd.CommandImprovableSkills;
import org.zeith.improvableskills.init.AbilitiesIS;
import org.zeith.improvableskills.init.GuiHooksIS;
import org.zeith.improvableskills.init.ItemsIS;
import org.zeith.improvableskills.init.PageletsIS;
import org.zeith.improvableskills.init.SkillsIS;
import org.zeith.improvableskills.init.SoundsIS;
import org.zeith.improvableskills.init.TreasuresIS;
import org.zeith.improvableskills.items.ItemAbilityScroll;
import org.zeith.improvableskills.net.NetSkillCalculator;
import org.zeith.improvableskills.net.PacketSyncSkillData;
import org.zeith.improvableskills.proxy.CommonProxy;
import org.zeith.improvableskills.utils.loot.LootConditionRandom;
import org.zeith.improvableskills.utils.loot.LootEntryItemStack;

@Mod(modid="improvableskills", name="Improvable Skills", version="12.4.68", dependencies="required-after:hammercore@[2.0.6.32,)", certificateFingerprint="9f5e2a811a8332a842b34f6967b7db0ac4f24856", updateJSON="http://dccg.herokuapp.com/api/fmluc/252902", acceptedMinecraftVersions="[1.12.2]")
public class ImprovableSkillsMod {
    @Mod.Instance
    public static ImprovableSkillsMod instance;
    @SidedProxy(clientSide="org.zeith.improvableskills.proxy.ClientProxy", serverSide="org.zeith.improvableskills.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs TAB;
    public static final Logger LOG;
    private static IForgeRegistry<PlayerAbilityBase> abilities;
    private static IForgeRegistry<PlayerSkillBase> skills;
    private static IForgeRegistry<PageletBase> pagelets;

    @Mod.EventHandler
    public void certificateViolation(FMLFingerprintViolationEvent e) {
        LOG.warn("*****************************");
        LOG.warn("WARNING: Somebody has been tampering with ImprovableSkills jar!");
        LOG.warn("It is highly recommended that you redownload mod from https://www.curseforge.com/projects/252902 !");
        LOG.warn("*****************************");
        HammerCore.invalidCertificates.put("improvableskills", "https://www.curseforge.com/projects/252902");
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        SimpleRegistration.registerFieldItemsFrom(ItemsIS.class, (String)"improvableskills", (CreativeTabs)TAB);
        evt.getModMetadata().autogenerated = false;
        evt.getModMetadata().authorList = HammerCore.getHCAuthorsArray();
        GuiManager.registerGuiCallback((IGuiCallback)GuiHooksIS.ENCHANTMENT);
        GuiManager.registerGuiCallback((IGuiCallback)GuiHooksIS.CRAFTING);
        GuiManager.registerGuiCallback((IGuiCallback)GuiHooksIS.ANVIL);
        GuiManager.registerGuiCallback((IGuiCallback)GuiHooksIS.ENCH_POWER_BOOK_IO);
        File cfg = evt.getSuggestedConfigurationFile();
        cfg = new File(cfg.getAbsolutePath().substring(0, cfg.getAbsolutePath().lastIndexOf(46)));
        if (!cfg.isDirectory()) {
            cfg.mkdirs();
        }
        SkillsConfigs.setConfigFile(new File(cfg, "costs.hcfg"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init();
        TreasuresIS.register();
        SkillsConfigs.reloadSkillConfigs();
        RecipesParchmentFragment.register(ItemAbilityScroll.of(AbilitiesIS.ENCHANTING), Blocks.field_150381_bn, Blocks.field_150342_X, Items.field_151079_bi);
        RecipesParchmentFragment.register(ItemAbilityScroll.of(AbilitiesIS.CRAFTER), Blocks.field_150462_ai, Items.field_151042_j, Items.field_151079_bi);
        RecipesParchmentFragment.register(ItemAbilityScroll.of(AbilitiesIS.ANVIL), Blocks.field_150467_bQ, Items.field_151166_bC, Items.field_151079_bi);
    }

    @Mod.EventHandler
    public void starting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandImprovableSkills());
    }

    @SubscribeEvent
    public void addRegistries(RegistryEvent.NewRegistry e) {
        abilities = new RegistryBuilder().setName(new ResourceLocation("improvableskills", "abilities")).setType(PlayerAbilityBase.class).create();
        skills = new RegistryBuilder().setName(new ResourceLocation("improvableskills", "stats")).setType(PlayerSkillBase.class).create();
        pagelets = new RegistryBuilder().setName(new ResourceLocation("improvableskills", "pagelets")).setType(PageletBase.class).create();
    }

    public static IForgeRegistry<PlayerAbilityBase> getAbilities() {
        return abilities;
    }

    public static IForgeRegistry<PageletBase> getPagelets() {
        return pagelets;
    }

    public static IForgeRegistry<PlayerSkillBase> getSkills() {
        return skills;
    }

    @SubscribeEvent
    public void addRecipes(RegistryEvent.Register<IRecipe> e) {
        IForgeRegistry reg = e.getRegistry();
        LOG.info("RegistryEvent.Register<IRecipe>");
        reg.register(SimpleRegistration.parseShapedRecipe((ItemStack)new ItemStack((Item)ItemsIS.SKILLS_BOOK), (Object[])new Object[]{"lbl", "pgp", "lbl", Character.valueOf('l'), "leather", Character.valueOf('b'), Items.field_151122_aG, Character.valueOf('p'), "paper", Character.valueOf('g'), "ingotGold"}).setRegistryName("improvableskills", "skills_book"));
    }

    @SubscribeEvent
    public void addSounds(RegistryEvent.Register<SoundEvent> e) {
        IForgeRegistry reg = e.getRegistry();
        LOG.info("RegistryEvent.Register<SoundEvent>");
        SoundsIS.register((IForgeRegistry<SoundEvent>)reg);
    }

    @SubscribeEvent
    public void addStats(RegistryEvent.Register<PlayerSkillBase> e) {
        LOG.info("RegistryEvent.Register<PlayerSkillBase>");
        SkillsIS.register((IForgeRegistry<PlayerSkillBase>)e.getRegistry());
    }

    @SubscribeEvent
    public void addPagelet(RegistryEvent.Register<PageletBase> e) {
        PageletsIS.register((IForgeRegistry<PageletBase>)e.getRegistry());
    }

    @SubscribeEvent
    public void addAbilities(RegistryEvent.Register<PlayerAbilityBase> e) {
        LOG.info("RegistryEvent.Register<PlayerAbilityBase>");
        AbilitiesIS.register((IForgeRegistry<PlayerAbilityBase>)e.getRegistry());
    }

    @SubscribeEvent
    public void playerReady(PlayerLoadReadyEvent e) {
        if (!e.getEntityPlayer().field_70170_p.field_72995_K && e.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)e.getEntityPlayer();
            PacketSyncSkillData.sync(mp);
            NetSkillCalculator.pack().build().sendTo(mp);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void lootLoad(LootTableLoadEvent e) {
        GameRegistry.findRegistry(PlayerSkillBase.class).getValuesCollection().stream().filter(s -> s.getLoot() != null).forEach(s -> s.getLoot().apply(e));
        if (e.getName().toString().toLowerCase().contains("chests/")) {
            RandomBoolean bool = new RandomBoolean();
            bool.n = 5;
            LOG.info("Injecting parchment into LootTable '" + e.getName() + "'!");
            LootEntryItemStack entry = new LootEntryItemStack(new ItemStack((Item)ItemsIS.PARCHMENT_FRAGMENT), 2, 60, new LootFunction[0], new LootCondition[0], ItemsIS.PARCHMENT_FRAGMENT.getRegistryName().toString());
            LootPool pool1 = new LootPool(new LootEntry[]{entry}, new LootCondition[]{new LootConditionRandom(bool)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), ItemsIS.PARCHMENT_FRAGMENT.getRegistryName().func_110623_a());
            try {
                e.getTable().addPool(pool1);
            }
            catch (Throwable err) {
                LOG.error("Failed to inject parchment into LootTable '" + e.getName() + "'!!!");
                err.printStackTrace();
            }
        }
    }

    static {
        TAB = new CreativeTabs("improvableskills"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ItemsIS.SKILLS_BOOK);
            }
        };
        LOG = LogManager.getLogger((String)"improvableskills");
    }
}

