/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestconstruct.worldgen;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.awt.geom.Ellipse2D;
import java.util.Optional;
import java.util.Random;
import maxhyper.dynamictreestconstruct.ModContent;
import maxhyper.dynamictreestconstruct.worldgen.DynamicSlimeTreeGenerator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeVine;
import slimeknights.tconstruct.world.worldgen.SlimeIslandData;
import slimeknights.tconstruct.world.worldgen.SlimeLakeGenerator;
import slimeknights.tconstruct.world.worldgen.SlimePlantGenerator;

public class DynamicSlimeIslandGenerator
implements IWorldGenerator {
    public static DynamicSlimeIslandGenerator INSTANCE = new DynamicSlimeIslandGenerator();
    protected static final int RANDOMNESS = 1;
    protected SlimeLakeGenerator lakeGenGreen;
    protected SlimeLakeGenerator lakeGenBlue;
    protected SlimeLakeGenerator lakeGenPurple;
    protected SlimePlantGenerator plantGenBlue;
    protected SlimePlantGenerator plantGenPurple;
    protected DynamicSlimeTreeGenerator treeGenBlue;
    protected DynamicSlimeTreeGenerator treeGenPurple;
    protected IBlockState air;
    protected TIntObjectHashMap<SlimeIslandData> islandData = new TIntObjectHashMap();

    public DynamicSlimeIslandGenerator() {
        this.air = Blocks.field_150350_a.func_176223_P();
        IBlockState slimeGreen = TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a((IProperty)BlockSlime.TYPE, (Comparable)BlockSlime.SlimeType.GREEN);
        IBlockState slimeBlue = TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a((IProperty)BlockSlime.TYPE, (Comparable)BlockSlime.SlimeType.BLUE);
        IBlockState slimePurple = TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a((IProperty)BlockSlime.TYPE, (Comparable)BlockSlime.SlimeType.PURPLE);
        IBlockState leaves = TinkerWorld.slimeLeaves.func_176223_P();
        IBlockState slimeFLuidBlue = Blocks.field_150355_j.func_176223_P();
        IBlockState slimeFLuidPurple = Blocks.field_150355_j.func_176223_P();
        if (TinkerFluids.blueslime != null) {
            slimeFLuidPurple = slimeFLuidBlue = TinkerFluids.blueslime.getBlock().func_176223_P();
        }
        if (TinkerFluids.purpleSlime != null) {
            slimeFLuidPurple = TinkerFluids.purpleSlime.getBlock().func_176223_P();
        }
        this.lakeGenGreen = new SlimeLakeGenerator(slimeFLuidBlue, slimeGreen, new IBlockState[]{slimeGreen, slimeBlue});
        this.lakeGenBlue = new SlimeLakeGenerator(slimeFLuidBlue, slimeBlue, new IBlockState[]{slimeGreen, slimeBlue});
        this.lakeGenPurple = new SlimeLakeGenerator(slimeFLuidPurple, slimePurple, new IBlockState[]{slimePurple});
        this.treeGenBlue = new DynamicSlimeTreeGenerator(DynamicSlimeTreeGenerator.slimeType.BLUE, 1);
        this.treeGenPurple = new DynamicSlimeTreeGenerator(DynamicSlimeTreeGenerator.slimeType.PURPLE, 1);
        this.plantGenBlue = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.BLUE, false);
        this.plantGenPurple = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.PURPLE, false);
    }

    public boolean isSlimeIslandAt(World world, BlockPos pos) {
        for (StructureBoundingBox data : this.getIslandData(world).getIslands()) {
            if (!data.func_175898_b((Vec3i)pos)) continue;
            return true;
        }
        return false;
    }

    protected String getDataName() {
        return "SlimeIslandsDynamic";
    }

    protected SlimeIslandData getIslandData(World world) {
        int dimensionId = world.field_73011_w.getDimension();
        if (!this.islandData.containsKey(dimensionId)) {
            SlimeIslandData data = (SlimeIslandData)world.getPerWorldStorage().func_75742_a(SlimeIslandData.class, this.getDataName());
            if (data == null) {
                data = new SlimeIslandData(this.getDataName());
                world.getPerWorldStorage().func_75745_a(this.getDataName(), (WorldSavedData)data);
            }
            this.islandData.put(dimensionId, (Object)data);
        }
        return (SlimeIslandData)this.islandData.get(dimensionId);
    }

    protected boolean shouldGenerateInDimension(int id) {
        for (int dim : Config.slimeIslandBlacklist) {
            if (dim != id) continue;
            return false;
        }
        return true;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ModContent.genSlimeIslands) {
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c && !Config.genIslandsInSuperflat) {
            return;
        }
        if (!Config.slimeIslandsOnlyGenerateInSurfaceWorlds && !world.field_73011_w.func_76569_d()) {
            return;
        }
        if (!this.shouldGenerateInDimension(world.field_73011_w.getDimension())) {
            return;
        }
        this.markChunkForIslandGenerationAndGenerateMarked(random, chunkX, chunkZ, world, chunkProvider);
    }

    protected void markChunkForIslandGenerationAndGenerateMarked(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkProvider) {
        long generationSeed = random.nextLong();
        if (random.nextInt(this.getGenerationChance()) > 0) {
            SlimeIslandData slimeIslandData = this.getIslandData(world);
            for (int x = chunkX - 1; x <= chunkX + 1; ++x) {
                for (int z = chunkZ - 1; z <= chunkZ + 1; ++z) {
                    Optional optionalGenerationSeed = slimeIslandData.getSeedForChunkToGenerate(x, z);
                    if (!optionalGenerationSeed.isPresent() || !this.areSurroundingChunksLoaded(x, z, chunkProvider)) continue;
                    this.generateIslandInChunk((Long)optionalGenerationSeed.get(), world, x, z);
                    slimeIslandData.markChunkAsGenerated(x, z);
                }
            }
            return;
        }
        if (!this.areSurroundingChunksLoaded(chunkX, chunkZ, chunkProvider)) {
            this.getIslandData(world).markChunkForGeneration(chunkX, chunkZ, generationSeed);
            return;
        }
        this.generateIslandInChunk(generationSeed, world, chunkX, chunkZ);
    }

    protected int getGenerationChance() {
        return Config.slimeIslandsRate;
    }

    protected void generateIslandInChunk(long seed, World world, int chunkX, int chunkZ) {
        Random random = new Random(seed);
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.BLUE;
        BlockSlimeDirt.DirtType dirt = BlockSlimeDirt.DirtType.BLUE;
        SlimeLakeGenerator lakeGen = this.lakeGenBlue;
        SlimePlantGenerator plantGen = this.plantGenPurple;
        DynamicSlimeTreeGenerator treeGen = this.treeGenPurple;
        IBlockState vine = TinkerWorld.slimeVineBlue1.func_176223_P();
        int rnr = random.nextInt(10);
        if (rnr <= 1) {
            grass = BlockSlimeGrass.FoliageType.PURPLE;
            dirt = BlockSlimeDirt.DirtType.PURPLE;
            lakeGen = this.lakeGenPurple;
            treeGen = this.treeGenBlue;
            plantGen = this.plantGenBlue;
            vine = TinkerWorld.slimeVinePurple1.func_176223_P();
        } else if (rnr < 6) {
            dirt = BlockSlimeDirt.DirtType.GREEN;
            lakeGen = this.lakeGenGreen;
        }
        IBlockState dirtState = TinkerWorld.slimeDirt.func_176223_P().func_177226_a((IProperty)BlockSlimeDirt.TYPE, (Comparable)dirt);
        IBlockState grassState = TinkerWorld.slimeGrass.getStateFromDirt(dirtState).func_177226_a((IProperty)BlockSlimeGrass.FOLIAGE, (Comparable)grass);
        int x = chunkX * 16 + 4 + random.nextInt(8);
        int z = chunkZ * 16 + 4 + random.nextInt(8);
        int y = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o() + 50 + random.nextInt(50) + 11;
        this.generateIsland(random, world, x, z, y, dirtState, grassState, vine, lakeGen, treeGen, plantGen);
    }

    public void generateIsland(Random random, World world, int xPos, int zPos, int ySurfacePos, IBlockState dirt, IBlockState grass, IBlockState vine, SlimeLakeGenerator lakeGenerator, DynamicSlimeTreeGenerator treeGenerator, SlimePlantGenerator plantGen) {
        int i;
        BlockPos pos2;
        BlockPos pos1;
        int y;
        int z;
        int x;
        int yRange;
        int xRange = 20 + random.nextInt(13);
        int zRange = 20 + random.nextInt(13);
        int height = yRange = 11 + random.nextInt(3);
        int yBottom = ySurfacePos - yRange;
        BlockPos center = new BlockPos(xPos, yBottom + height, zPos);
        BlockPos start = new BlockPos(xPos - xRange / 2, yBottom, zPos - zRange / 2);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, xRange, zRange);
        for (int x2 = 0; x2 <= xRange; ++x2) {
            for (int z2 = 0; z2 <= zRange; ++z2) {
                for (int y2 = 0; y2 <= yRange; ++y2) {
                    if (!ellipse.contains(x2, z2)) continue;
                    world.func_180501_a(start.func_177982_a(x2, y2, z2), dirt, 2);
                }
            }
        }
        int erode_height = 8;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= erode_height; ++y) {
                    pos1 = start.func_177982_a(x, erode_height - y, z);
                    pos2 = start.func_177982_a(xRange - x, erode_height - y, zRange - z);
                    for (BlockPos pos : new BlockPos[]{pos1, pos2}) {
                        if (world.func_180495_p(pos) != dirt || world.func_180495_p(pos.func_177982_a(-1, 1, 0)) == dirt && world.func_180495_p(pos.func_177982_a(1, 1, 0)) == dirt && world.func_180495_p(pos.func_177982_a(0, 1, -1)) == dirt && world.func_180495_p(pos.func_177982_a(-1, 1, 1)) == dirt && random.nextInt(100) > 1) continue;
                        world.func_180501_a(pos, this.air, 2);
                    }
                }
            }
        }
        erode_height = 2;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= erode_height; ++y) {
                    pos1 = start.func_177982_a(x, y + height - erode_height + 2, z);
                    pos2 = start.func_177982_a(xRange - x, y + height - erode_height + 2, zRange - z);
                    for (BlockPos pos : new BlockPos[]{pos1, pos2}) {
                        BlockPos below = pos.func_177977_b();
                        if (world.func_180495_p(pos) != dirt && world.func_180495_p(pos) != grass || world.func_180495_p(below.func_177978_c()) == dirt && world.func_180495_p(below.func_177974_f()) == dirt && world.func_180495_p(below.func_177968_d()) == dirt && world.func_180495_p(below.func_177976_e()) == dirt) continue;
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }
        for (x = 0; x <= xRange; ++x) {
            block12: for (z = 0; z <= zRange; ++z) {
                BlockPos top = start.func_177982_a(x, height, z);
                for (int y3 = 0; y3 <= height; ++y3) {
                    BlockPos pos = top.func_177979_c(y3);
                    if (world.func_180495_p(pos) != dirt || !world.func_175623_d(pos.func_177984_a())) continue;
                    world.func_180501_a(pos, grass, 2);
                    continue block12;
                }
            }
        }
        if (lakeGenerator != null) {
            lakeGenerator.generateLake(random, world, center);
        }
        if (plantGen != null) {
            plantGen.generatePlants(random, world, start.func_177981_b(height + 1), start.func_177982_a(xRange, height - 3, zRange), 128);
        }
        if (treeGenerator != null) {
            for (i = 0; i < 3; ++i) {
                BlockPos pos = start.func_177982_a(random.nextInt(xRange), height, random.nextInt(zRange));
                treeGenerator.generateTree(random, world, pos);
            }
        }
        if (vine != null) {
            for (i = 0; i < 30; ++i) {
                BlockPos pos = start.func_177982_a(-1 + random.nextInt(xRange + 2), 0, -1 + random.nextInt(zRange + 2));
                this.tryPlacingVine(random, world, pos, height, vine);
            }
        }
        SlimeIslandData data = this.getIslandData(world);
        data.getIslands().add(new StructureBoundingBox(start.func_177958_n(), start.func_177956_o(), start.func_177952_p(), start.func_177958_n() + xRange, start.func_177956_o() + yRange, start.func_177952_p() + zRange));
        data.func_76185_a();
    }

    public void tryPlacingVine(Random random, World world, BlockPos below, int limit, IBlockState vine) {
        BlockPos pos = below;
        BlockPos candidate = null;
        for (int i = 0; i < limit; ++i) {
            if ((vine.func_177230_c().func_176198_a(world, pos, EnumFacing.NORTH) || vine.func_177230_c().func_176198_a(world, pos, EnumFacing.EAST) || vine.func_177230_c().func_176198_a(world, pos, EnumFacing.SOUTH) || vine.func_177230_c().func_176198_a(world, pos, EnumFacing.WEST)) && (candidate == null || random.nextInt(10) == 0)) {
                candidate = pos;
            }
            pos = pos.func_177984_a();
        }
        if (candidate != null) {
            world.func_180501_a(candidate, vine.func_177230_c().getStateForPlacement(world, candidate, EnumFacing.UP, 0.0f, 0.0f, 0.0f, 0, null, null), 2);
            pos = candidate;
            for (int size = random.nextInt(8); size >= 0 && world.func_180495_p(pos).func_177230_c() instanceof BlockSlimeVine; ++size) {
                ((BlockSlimeVine)world.func_180495_p(pos).func_177230_c()).grow(world, random, pos, world.func_180495_p(pos));
                pos = pos.func_177977_b();
            }
        }
    }

    protected boolean areSurroundingChunksLoaded(int chunkX, int chunkZ, IChunkProvider chunkprovider) {
        for (int x = chunkX - 1; x <= chunkX + 1; ++x) {
            for (int z = chunkZ - 1; z <= chunkZ + 1; ++z) {
                if (chunkprovider.func_186026_b(x, z) != null) continue;
                return false;
            }
        }
        return true;
    }
}

