/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestconstruct.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreestconstruct.ModConfigs;
import maxhyper.dynamictreestconstruct.ModContent;
import maxhyper.dynamictreestconstruct.genfeatures.FeatureGenSlimeVines;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.world.TinkerWorld;

public class TreeSlimeBlue
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"tconstruct:slime_leaves");
    public static Block logBlock = Block.func_149684_b((String)"tconstruct:slime_congealed");
    public static Block saplingBlock = Block.func_149684_b((String)"tconstruct:slime_sapling");
    public static float taperingDefaultSlime = 0.25f;
    public static float energyDefaultSlime = 12.0f;
    public static int upProbabilityDefaultSlime = 1;
    public static int lowestBranchHeightDefaultSlime = 5;
    public static float growthRateDefaultSlime = 0.9f;

    public TreeSlimeBlue() {
        this(new ResourceLocation("dynamictreestconstruct", "slimeBlue"));
        this.setDynamicBranch(ModContent.slimeBlueBranch);
        ModContent.blueSlimeLeavesProperties.setTree((TreeFamily)this);
    }

    public TreeSlimeBlue(ResourceLocation resourceLocation) {
        super(resourceLocation);
        this.setPrimitiveLog(logBlock.func_176223_P().func_177226_a((IProperty)BlockSlime.TYPE, (Comparable)BlockSlime.SlimeType.GREEN));
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, 0);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesBlueSlime(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public class SpeciesBlueSlime
    extends Species {
        SpeciesBlueSlime(TreeFamily treeFamily) {
            super(new ResourceLocation("dynamictreestconstruct", "slimeBlue"), treeFamily, ModContent.blueSlimeLeavesProperties);
            this.setBasicGrowingParameters(taperingDefaultSlime, energyDefaultSlime, upProbabilityDefaultSlime, lowestBranchHeightDefaultSlime, growthRateDefaultSlime);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"slime"));
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.1f);
            this.envFactor(BiomeDictionary.Type.WET, 1.75f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            TreeSlimeBlue.this.setStick(ItemStack.field_190927_a);
            this.addGenFeature((IGenFeature)new FeatureGenSlimeVines((Block)TinkerWorld.slimeVineBlue3));
            if (ModConfigs.greenSlimeBallsInBlueTrees) {
                ModContent.blockGreenSlime.setSpecies((Species)this);
                this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.blockGreenSlime).setRayDistance(4.0f));
            }
            if (ModConfigs.blueSlimeBallsInBlueTrees) {
                ModContent.blockBlueSlime.setSpecies((Species)this);
                this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.blockBlueSlime).setRayDistance(4.0f));
            }
            this.clearAcceptableSoils();
            this.addAcceptableSoils(new String[]{"slimelike"});
        }

        public float seasonalFruitProductionFactor(World world, BlockPos pos) {
            return 1.0f;
        }

        public BlockRooty getRootyBlock(World world, BlockPos pos) {
            return ModContent.rootySlimyDirt;
        }
    }
}

