/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestconstruct;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import maxhyper.dynamictreestconstruct.blocks.BlockDynamicBranchSlime;
import maxhyper.dynamictreestconstruct.blocks.BlockRootySlimyDirt;
import maxhyper.dynamictreestconstruct.trees.TreeSlimeBlue;
import maxhyper.dynamictreestconstruct.trees.TreeSlimeMagma;
import maxhyper.dynamictreestconstruct.trees.TreeSlimePurple;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;

@Mod.EventBusSubscriber(modid="dynamictreestconstruct")
@GameRegistry.ObjectHolder(value="dynamictreestconstruct")
public class ModContent {
    public static BlockBranch slimeBlueBranch;
    public static BlockBranch slimePurpleBranch;
    public static BlockBranch slimeMagmaBranch;
    public static BlockRooty rootySlimyDirt;
    public static BlockFruit blockGreenSlime;
    public static BlockFruit blockBlueSlime;
    public static BlockFruit blockPurpleSlime;
    public static BlockFruit blockMagmaSlime;
    public static ILeavesProperties blueSlimeLeavesProperties;
    public static ILeavesProperties purpleSlimeLeavesProperties;
    public static ILeavesProperties magmaSlimeLeavesProperties;
    public static ArrayList<TreeFamily> trees;
    static boolean messageSent;
    public static boolean genSlimeIslands;

    @SubscribeEvent
    public static void onEvent(EntityJoinWorldEvent event) {
        if (!messageSent && event.getEntity() instanceof EntityPlayer && !TConstruct.pulseManager.isPulseLoaded("TinkerWorld")) {
            event.getEntity().func_145747_a((ITextComponent)new TextComponentString("Dynamic Trees for Tinkers' Construct: Failed to load. Tinker World module is disabled in Tinkers' Construct Config."));
            messageSent = true;
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerWorld")) {
            return;
        }
        IForgeRegistry registry = event.getRegistry();
        blockGreenSlime = new BlockFruit("fruitgreenslime");
        registry.register((IForgeRegistryEntry)blockGreenSlime);
        blockBlueSlime = new BlockFruit("fruitblueslime");
        registry.register((IForgeRegistryEntry)blockBlueSlime);
        blockPurpleSlime = new BlockFruit("fruitpurpleslime");
        registry.register((IForgeRegistryEntry)blockPurpleSlime);
        blockMagmaSlime = new BlockFruit("fruitmagmaslime");
        registry.register((IForgeRegistryEntry)blockMagmaSlime);
        slimeBlueBranch = new BlockDynamicBranchSlime("slimebluebranch");
        slimePurpleBranch = new BlockDynamicBranchSlime("slimepurplebranch");
        slimeMagmaBranch = new BlockDynamicBranchSlime("slimemagmabranch");
        rootySlimyDirt = new BlockRootySlimyDirt(false);
        registry.register((IForgeRegistryEntry)rootySlimyDirt);
        blueSlimeLeavesProperties = new LeavesProperties(TreeSlimeBlue.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockSlimeGrass.FOLIAGE, (Comparable)BlockSlimeGrass.FoliageType.BLUE), new ItemStack(TreeSlimeBlue.leavesBlock, 1, 0), TreeRegistry.findCellKit((String)"conifer")){

            public int getSmotherLeavesMax() {
                return 8;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(TreeSlimeBlue.leavesBlock, 1, 0);
            }

            public int getFlammability() {
                return 0;
            }

            public int getFireSpreadSpeed() {
                return 0;
            }
        };
        purpleSlimeLeavesProperties = new LeavesProperties(TreeSlimeBlue.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockSlimeGrass.FOLIAGE, (Comparable)BlockSlimeGrass.FoliageType.PURPLE), new ItemStack(TreeSlimeBlue.leavesBlock, 1, 1), TreeRegistry.findCellKit((String)"conifer")){

            public int getSmotherLeavesMax() {
                return 8;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(TreeSlimePurple.leavesBlock, 1, 1);
            }

            public int getFlammability() {
                return 0;
            }

            public int getFireSpreadSpeed() {
                return 0;
            }
        };
        magmaSlimeLeavesProperties = new LeavesProperties(TreeSlimeMagma.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockSlimeGrass.FOLIAGE, (Comparable)BlockSlimeGrass.FoliageType.ORANGE), new ItemStack(TreeSlimeMagma.leavesBlock, 1, 2), TreeRegistry.findCellKit((String)"conifer")){

            public int getLightRequirement() {
                return 0;
            }

            public int getSmotherLeavesMax() {
                return 8;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(TreeSlimeMagma.leavesBlock, 1, 2);
            }

            public int getFlammability() {
                return 0;
            }

            public int getFireSpreadSpeed() {
                return 0;
            }
        };
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreestconstruct", (int)0, (ILeavesProperties)blueSlimeLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreestconstruct", (int)1, (ILeavesProperties)purpleSlimeLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dynamictreestconstruct", (int)2, (ILeavesProperties)magmaSlimeLeavesProperties);
        TreeSlimeBlue blueSlimeTree = new TreeSlimeBlue();
        TreeSlimePurple purpleSlimeTree = new TreeSlimePurple();
        TreeSlimeMagma magmaSlimeTree = new TreeSlimeMagma();
        Collections.addAll(trees, new TreeFamily[]{blueSlimeTree, purpleSlimeTree, magmaSlimeTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreestconstruct").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[0]));
        DirtHelper.registerSoil((Block)TinkerWorld.slimeGrass, (String)"slimelike");
        DirtHelper.registerSoil((Block)TinkerWorld.slimeGrass, (String)"dirtlike");
        DirtHelper.registerSoil((Block)TinkerWorld.slimeDirt, (String)"slimelike");
        DirtHelper.registerSoil((Block)TinkerWorld.slimeDirt, (String)"dirtlike");
        DirtHelper.registerSoil((Block)rootySlimyDirt, (String)"slimelike");
        DirtHelper.registerSoil((Block)rootySlimyDirt, (String)"dirtlike");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerWorld")) {
            return;
        }
        IForgeRegistry registry = event.getRegistry();
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerWorld")) {
            return;
        }
        ModContent.setUpSeedRecipes("slimeBlue", new ItemStack(TreeSlimeBlue.saplingBlock, 1, 0));
        ModContent.setUpSeedRecipes("slimePurple", new ItemStack(TreeSlimePurple.saplingBlock, 1, 1));
        ModContent.setUpSeedRecipes("slimeMagma", new ItemStack(TreeSlimeMagma.saplingBlock, 1, 2));
    }

    public static void setUpSeedRecipes(String name, ItemStack treeSapling) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestconstruct", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)treeSapling, (ItemStack)treeSeed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerWorld")) {
            return;
        }
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        LeavesPaging.getLeavesMapForModId((String)"dynamictreestconstruct").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
        ModelLoader.setCustomStateMapper((Block)rootySlimyDirt, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
    }

    static {
        trees = new ArrayList();
        messageSent = false;
    }
}

