/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.playerwatching;

import com.ishland.vmp.common.maps.AreaMap;
import com.ishland.vmp.common.playerwatching.EntityTrackerExtension;
import com.ishland.vmp.common.playerwatching.ServerPlayerEntityExtension;
import com.ishland.vmp.common.playerwatching.compat.EntityPositionTransformer;
import com.ishland.vmp.common.util.SimpleObjectPool;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorageEntityTracker;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4076;

public class NearbyEntityTracking {
    private static final EntityPositionTransformer[] transformers;
    private final SimpleObjectPool<ReferenceLinkedOpenHashSet<?>> pooledHashSets = new SimpleObjectPool<ReferenceLinkedOpenHashSet>(unused -> new ReferenceLinkedOpenHashSet(), ReferenceLinkedOpenHashSet::clear, ts -> {
        ts.clear();
        ts.trim(4);
    }, 8192);
    private final AreaMap<class_3898.class_3208> areaMap = new AreaMap<class_3898.class_3208>((object, x, z) -> {}, (object, x, z) -> {}, false);
    private final Reference2ReferenceLinkedOpenHashMap<class_3222, ReferenceLinkedOpenHashSet<class_3898.class_3208>> playerTrackers = new Reference2ReferenceLinkedOpenHashMap();
    private final Reference2LongOpenHashMap<class_3898.class_3208> tracker2ChunkPos = new Reference2LongOpenHashMap();
    private final ReferenceLinkedOpenHashSet<class_3898.class_3208> trackerTickList = new ReferenceLinkedOpenHashSet<class_3898.class_3208>(){

        protected void rehash(int newN) {
            if (this.n < newN) {
                super.rehash(newN);
            }
        }
    };

    public static void init() {
    }

    public void addEntityTracker(class_3898.class_3208 tracker) {
        class_1923 pos = NearbyEntityTracking.getEntityChunkPos(((IThreadedAnvilChunkStorageEntityTracker)tracker).getEntity());
        this.areaMap.add(tracker, pos.field_9181, pos.field_9180, this.getChunkViewDistance(tracker));
        this.tracker2ChunkPos.put((Object)tracker, pos.method_8324());
    }

    public void removeEntityTracker(class_3898.class_3208 tracker) {
        this.areaMap.remove(tracker);
        this.tracker2ChunkPos.removeLong((Object)tracker);
    }

    public void addPlayer(class_3222 player) {
        this.playerTrackers.put((Object)player, this.pooledHashSets.alloc());
    }

    public void removePlayer(class_3222 player) {
        ReferenceLinkedOpenHashSet originalTrackers = (ReferenceLinkedOpenHashSet)this.playerTrackers.remove((Object)player);
        if (originalTrackers != null) {
            for (class_3898.class_3208 tracker : originalTrackers) {
                tracker.method_18733(player);
            }
            this.pooledHashSets.release(originalTrackers);
        }
    }

    private static class_1923 getEntityChunkPos(class_1297 entity) {
        class_243 pos = entity.method_19538();
        for (EntityPositionTransformer transformer : transformers) {
            pos = transformer.transform(entity, pos);
        }
        return new class_1923(class_4076.method_32204((double)pos.field_1352), class_4076.method_32204((double)pos.field_1350));
    }

    public void tick(class_3898.class_3216 ticketManager) {
        for (Object entry : this.tracker2ChunkPos.reference2LongEntrySet()) {
            class_1923 pos = NearbyEntityTracking.getEntityChunkPos(((IThreadedAnvilChunkStorageEntityTracker)entry.getKey()).getEntity());
            if (pos.method_8324() == entry.getLongValue()) continue;
            this.areaMap.update((class_3898.class_3208)entry.getKey(), pos.field_9181, pos.field_9180, this.getChunkViewDistance((class_3898.class_3208)entry.getKey()));
            entry.setValue(pos.method_8324());
        }
        this.trackerTickList.clear();
        for (Object entry : this.playerTrackers.entrySet()) {
            class_3222 player = (class_3222)entry.getKey();
            Set<class_3898.class_3208> currentTrackers = this.areaMap.getObjectsInRange(NearbyEntityTracking.getEntityChunkPos((class_1297)player).method_8324());
            boolean isPlayerPositionUpdated = ((ServerPlayerEntityExtension)player).vmpTracking$isPositionUpdated();
            ((ServerPlayerEntityExtension)player).vmpTracking$updatePosition();
            ReferenceLinkedOpenHashSet trackers = (ReferenceLinkedOpenHashSet)entry.getValue();
            ObjectListIterator iterator = trackers.iterator();
            while (iterator.hasNext()) {
                class_3898.class_3208 entityTracker = (class_3898.class_3208)iterator.next();
                if (currentTrackers.contains(entityTracker)) {
                    this.handleTracker(ticketManager, player, isPlayerPositionUpdated, entityTracker);
                    continue;
                }
                entityTracker.method_18733(player);
                iterator.remove();
            }
            for (class_3898.class_3208 entityTracker : currentTrackers) {
                if (trackers.contains((Object)entityTracker)) continue;
                this.handleTracker(ticketManager, player, isPlayerPositionUpdated, entityTracker);
                trackers.add((Object)entityTracker);
            }
        }
        for (class_3898.class_3208 entityTracker : this.trackerTickList) {
            ((EntityTrackerExtension)entityTracker).updatePosition();
        }
    }

    private void handleTracker(class_3898.class_3216 ticketManager, class_3222 player, boolean isPlayerPositionUpdated, class_3898.class_3208 entityTracker) {
        class_4076 trackedPos = ((IThreadedAnvilChunkStorageEntityTracker)entityTracker).getTrackedSection();
        if (this.trackerTickList.add((Object)entityTracker) && ticketManager.method_38630(class_1923.method_8331((int)trackedPos.method_18674(), (int)trackedPos.method_18687()))) {
            NearbyEntityTracking.tryTickTracker(entityTracker);
        }
        if (isPlayerPositionUpdated || ((EntityTrackerExtension)entityTracker).isPositionUpdated()) {
            NearbyEntityTracking.tryUpdateTracker(entityTracker, player);
        }
    }

    private static void tryUpdateTracker(class_3898.class_3208 entityTracker, class_3222 player) {
        entityTracker.method_18736(player);
    }

    private static void tryTickTracker(class_3898.class_3208 entityTracker) {
        ((EntityTrackerExtension)entityTracker).tryTick();
    }

    private int getChunkViewDistance(class_3898.class_3208 tracker) {
        return (int)Math.ceil((double)((IThreadedAnvilChunkStorageEntityTracker)tracker).invokeGetMaxTrackDistance() / 16.0) + 1;
    }

    static {
        ArrayList<EntityPositionTransformer> list = new ArrayList<EntityPositionTransformer>();
        if (FabricLoader.getInstance().isModLoaded("valkyrienskies")) {
            System.out.println("ValkyrienSkies detected, applying compatibility patch");
            try {
                list.add((EntityPositionTransformer)Class.forName("com.ishland.vmp.common.playerwatching.compat.ValkyrienSkies2ShipPositionTransformer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        transformers = (EntityPositionTransformer[])list.toArray(EntityPositionTransformer[]::new);
    }
}

