/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.chunk.sending;

import com.google.common.util.concurrent.RateLimiter;
import com.ishland.vmp.common.chunkwatching.PlayerClientVDTracking;
import com.ishland.vmp.common.config.Config;
import com.ishland.vmp.common.maps.AreaMap;
import com.ishland.vmp.common.util.SimpleObjectPool;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.Collection;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1923;
import net.minecraft.class_2672;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerChunkSendingSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerChunkSendingSystem");
    public static final boolean ENABLED = true;
    private final Reference2ReferenceLinkedOpenHashMap<class_3222, PlayerState> players = new Reference2ReferenceLinkedOpenHashMap();
    private final AreaMap<class_3222> areaMap = new AreaMap<class_3222>((player, x, z) -> {
        PlayerState state = (PlayerState)this.players.computeIfAbsent(player, x$0 -> new PlayerState((class_3222)x$0));
        state.sendQueue.add(new class_1923(x, z));
    }, (player, x, z) -> {
        PlayerState state = (PlayerState)this.players.get(player);
        if (state != null) {
            state.unloadChunk(x, z);
        }
    }, false);
    private final class_3898 tacs;
    private final Object2LongOpenHashMap<class_3222> positions = new Object2LongOpenHashMap();
    private final SimpleObjectPool<MutableObject<class_2672>> pool = new SimpleObjectPool<MutableObject>(pool -> new MutableObject(), mutableObject -> mutableObject.setValue(null), mutableObject -> mutableObject.setValue(null), 8192);
    private final Long2ObjectFunction<MutableObject<class_2672>> allocFunction = unused -> this.pool.alloc();
    private final Long2ObjectOpenHashMap<MutableObject<class_2672>> cache = new Long2ObjectOpenHashMap();
    private int watchDistance = 5;

    public PlayerChunkSendingSystem(class_3898 tacs) {
        this.tacs = tacs;
    }

    public void tick() {
        for (PlayerState state : this.players.values()) {
            state.tick(this.cache);
        }
        for (MutableObject value : this.cache.values()) {
            this.pool.release((MutableObject<class_2672>)value);
        }
        this.cache.clear();
        this.cache.trim(64);
    }

    public void onChunkLoaded(long pos) {
        for (Object _player : this.areaMap.getObjectsInRangeArray(pos)) {
            if (!(_player instanceof class_3222)) continue;
            class_3222 player = (class_3222)_player;
            PlayerState state = (PlayerState)this.players.get((Object)player);
            state.sendQueue.add(new class_1923(pos));
        }
    }

    public void setWatchDistance(int watchDistance) {
        this.watchDistance = Math.max(3, watchDistance);
        for (Object2LongMap.Entry entry : this.positions.object2LongEntrySet()) {
            this.areaMap.update((class_3222)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), this.getActualWatchDistance((class_3222)entry.getKey()));
        }
    }

    public void add(class_3222 player, int x, int z) {
        this.areaMap.add(player, x, z, this.getActualWatchDistance(player));
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
    }

    public void remove(class_3222 player) {
        this.areaMap.remove(player);
        this.players.remove((Object)player);
        this.positions.removeLong((Object)player);
    }

    public void movePlayer(class_3222 player, long currentPos) {
        int x = class_1923.method_8325((long)currentPos);
        int z = class_1923.method_8332((long)currentPos);
        this.areaMap.update(player, x, z, this.getActualWatchDistance(player));
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
        PlayerState state = (PlayerState)this.players.get((Object)player);
        if (state != null) {
            state.updateQueue();
        }
    }

    private int getActualWatchDistance(class_3222 player) {
        PlayerClientVDTracking tracking;
        return player instanceof PlayerClientVDTracking && (tracking = (PlayerClientVDTracking)player).getClientViewDistance() != -1 ? Math.min(tracking.getClientViewDistance() + 1, this.watchDistance) : this.watchDistance;
    }

    private void sendChunk(class_3222 player, class_1923 pos, MutableObject<class_2672> mutableObject) {
        ((IThreadedAnvilChunkStorage)this.tacs).invokeSendWatchPackets(player, pos, mutableObject, false, true);
    }

    private void unloadChunk(class_3222 player, class_1923 pos) {
        ((IThreadedAnvilChunkStorage)this.tacs).invokeSendWatchPackets(player, pos, null, true, false);
    }

    private class PlayerState {
        private final ObjectArrayList<class_1923> tmp = new ObjectArrayList();
        private final PriorityBlockingQueue<class_1923> sendQueue = new PriorityBlockingQueue(441, this::compare);
        private final LongOpenHashSet sentChunks = new LongOpenHashSet();
        private final RateLimiter rateLimiter = Config.TARGET_CHUNK_SEND_RATE > 0 ? RateLimiter.create((double)Config.TARGET_CHUNK_SEND_RATE, (long)1L, (TimeUnit)TimeUnit.SECONDS) : null;
        private final class_3222 player;
        private class_1923 center;

        public PlayerState(class_3222 player) {
            this.player = player;
            this.center = player.method_31476();
        }

        public void tick(Long2ObjectOpenHashMap<MutableObject<class_2672>> cachedPackets) {
            class_1923 pos;
            PlayerClientVDTracking tracking;
            class_3222 class_32222 = this.player;
            if (class_32222 instanceof PlayerClientVDTracking && (tracking = (PlayerClientVDTracking)class_32222).isClientViewDistanceChanged() && PlayerChunkSendingSystem.this.positions.containsKey((Object)this.player)) {
                PlayerChunkSendingSystem.this.movePlayer(this.player, PlayerChunkSendingSystem.this.positions.getLong((Object)this.player));
            }
            while ((pos = this.sendQueue.peek()) != null && (this.rateLimiter == null || this.rateLimiter.tryAcquire())) {
                PlayerChunkSendingSystem.this.sendChunk(this.player, pos, (MutableObject<class_2672>)((MutableObject)cachedPackets.computeIfAbsent(pos.method_8324(), PlayerChunkSendingSystem.this.allocFunction)));
                this.sendQueue.poll();
            }
        }

        public void unloadChunk(int x, int z) {
            long coordinateKey = MCUtil.getCoordinateKey(x, z);
            class_1923 pos = new class_1923(x, z);
            this.sendQueue.remove(pos);
            PlayerChunkSendingSystem.this.unloadChunk(this.player, pos);
        }

        public void updateQueue() {
            this.tmp.clear();
            this.sendQueue.drainTo((Collection<class_1923>)this.tmp);
            this.center = this.player.method_31476();
            this.sendQueue.addAll((Collection<class_1923>)this.tmp);
            this.tmp.clear();
        }

        private int compare(class_1923 a, class_1923 b) {
            return Integer.compare(this.chebyshevDistance(a), this.chebyshevDistance(b));
        }

        private int chebyshevDistance(class_1923 pos) {
            return Math.max(Math.abs(pos.field_9181 - this.center.field_9181), Math.abs(pos.field_9180 - this.center.field_9180));
        }
    }

    public static interface ChunkUnloadingHandle {
        public void unloadChunk(class_3222 var1, class_1923 var2);
    }

    public static interface ChunkSendingHandle {
        public void sendChunk(class_3222 var1, class_1923 var2);
    }
}

