/*
 * Decompiled with CFR 0.152.
 */
package me.wolfii.mixin;

import me.wolfii.Config;
import me.wolfii.ScrollMath;
import net.minecraft.class_332;
import net.minecraft.class_350;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_350.class})
public abstract class EntryListWidgetMixin {
    @Shadow
    private double field_22749;
    @Shadow
    protected int field_19086;
    @Unique
    private double animationTimer = 0.0;
    @Unique
    private double scrollStartVelocity = 0.0;
    @Unique
    private boolean renderSmooth = false;

    @Shadow
    public abstract int method_25331();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void manipulateScrollAmount(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.renderSmooth = true;
        this.checkOutOfBounds(delta);
        if (Math.abs(ScrollMath.scrollbarVelocity(this.animationTimer, this.scrollStartVelocity)) < 1.0) {
            return;
        }
        this.applyMotion(delta);
    }

    @Unique
    private void applyMotion(float delta) {
        this.field_22749 += ScrollMath.scrollbarVelocity(this.animationTimer, this.scrollStartVelocity) * (double)delta;
        this.animationTimer += (double)(delta * 10.0f) / Config.animationDuration;
    }

    @Unique
    private void checkOutOfBounds(float delta) {
        if (this.field_22749 < 0.0) {
            this.field_22749 += ScrollMath.pushBackStrength(Math.abs(this.field_22749), delta);
            if (this.field_22749 > -0.2) {
                this.field_22749 = 0.0;
            }
        }
        if (this.field_22749 > (double)this.method_25331()) {
            this.field_22749 -= ScrollMath.pushBackStrength(this.field_22749 - (double)this.method_25331(), delta);
            if (this.field_22749 < (double)this.method_25331() + 0.2) {
                this.field_22749 = this.method_25331();
            }
        }
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/EntryListWidget;setScrollAmount(D)V"))
    private void setVelocity(class_350<?> instance, double amount) {
        if (!this.renderSmooth) {
            instance.method_25307(amount);
            return;
        }
        double diff = amount - this.field_22749;
        diff = Math.signum(diff) * Math.min(Math.abs(diff), 10.0);
        if (Math.signum(diff *= Config.scrollSpeed) != Math.signum(this.scrollStartVelocity)) {
            diff *= 2.5;
        }
        this.animationTimer *= 0.5;
        this.scrollStartVelocity = ScrollMath.scrollbarVelocity(this.animationTimer, this.scrollStartVelocity) + diff;
        this.animationTimer = 0.0;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V", ordinal=1))
    private void modifyScrollbar(class_332 instance, int x1, int y1, int x2, int y2, int color) {
        int height = y2 - y1;
        if (this.field_22749 < 0.0) {
            y2 -= ScrollMath.dampenSquish(Math.abs(this.field_22749), height);
        }
        if (y1 + height > this.field_19086) {
            y2 = this.field_19086;
            y1 = this.field_19086 - height;
        }
        if (this.field_22749 > (double)this.method_25331()) {
            int squish = ScrollMath.dampenSquish(this.field_22749 - (double)this.method_25331(), height);
            y1 += squish;
        }
        instance.method_25294(x1, y1, x2, y2, color);
        instance.method_25294(x1, y1, x2 - 1, y2 - 1, -4144960);
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V", ordinal=2))
    private void cancelScrollbarForeground(class_332 instance, int x1, int y1, int x2, int y2, int color) {
    }
}

