/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp.events;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.infernalstudios.shieldexp.events.ShieldExpansionEvents;
import org.infernalstudios.shieldexp.init.Config;

@Mod.EventBusSubscriber(modid="shieldexp", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TooltipEvents {
    @SubscribeEvent
    public void onTooltipCreate(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        Player player = event.getEntity();
        if (player != null && Config.isShield(item).booleanValue()) {
            event.getToolTip().add(Component.m_237115_((String)" "));
            event.getToolTip().add(Component.m_237115_((String)"shieldexp.tooltip.attribute").m_130940_(ChatFormatting.GRAY));
            this.tooltip(event, item, "cooldownTicks");
            this.tooltip(event, item, "stamina");
            this.tooltip(event, item, "speedFactor");
            this.tooltip(event, item, "parryDamage");
            this.tooltip(event, item, "parryTicks");
            this.tooltip(event, item, "blastResistance");
            event.getToolTip().add(Component.m_237115_((String)" "));
            if (Screen.m_96638_()) {
                event.getToolTip().add(Component.m_237115_((String)"shieldexp.tooltip.instructions.parry").m_130940_(ChatFormatting.YELLOW));
            } else {
                event.getToolTip().add(Component.m_237115_((String)"shieldexp.tooltip.instructions").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    private void tooltip(ItemTooltipEvent event, Item item, String attribute) {
        if (this.validate(item, attribute).booleanValue()) {
            Double value = ShieldExpansionEvents.getShieldValue(item, attribute);
            String fullKey = "shieldexp.tooltip.attribute." + attribute.replaceAll("(?<!^)([A-Z])", "_$1").toLowerCase().trim();
            if (attribute.equals("speedFactor")) {
                event.getToolTip().add(Component.m_237115_((String)(value < 0.6 ? fullKey + "_slow" : fullKey + "_fast")).m_130940_(ChatFormatting.DARK_GREEN));
            } else {
                if (attribute.equals("parryTicks") && Config.lenientParryEnabled().booleanValue() || attribute.equals("stamina") && Config.lenientStaminaEnabled().booleanValue()) {
                    value = value * 2.0;
                }
                List list = event.getToolTip();
                Object[] objectArray = new Object[1];
                objectArray[0] = switch (attribute) {
                    case "cooldownTicks", "parryTicks" -> String.valueOf(value / 20.0);
                    case "stamina" -> String.valueOf(value.intValue());
                    case "parryDamage", "flatDamage" -> ShieldExpansionEvents.getShieldValue(item, "flatDamage").intValue() + " + " + value * 100.0 + "%";
                    case "blastResistance" -> value * 100.0 + "%";
                    default -> "";
                };
                list.add(Component.m_237110_((String)fullKey, (Object[])objectArray).m_130940_(ChatFormatting.DARK_GREEN));
            }
        }
    }

    private Boolean validate(Item item, String attribute) {
        if (Config.isShield(item).booleanValue()) {
            return switch (attribute) {
                case "cooldownTicks", "stamina" -> Config.cooldownDisabled() == false && ShieldExpansionEvents.getShieldValue(item, attribute) != 0.0;
                case "blastResistance" -> ShieldExpansionEvents.getShieldValue(item, attribute) != 0.0;
                case "parryDamage" -> ShieldExpansionEvents.getShieldValue(item, attribute) != 0.0 && ShieldExpansionEvents.getShieldValue(item, "flatDamage") != 0.0;
                case "speedFactor" -> Config.speedModifierDisabled() == false;
                default -> true;
            };
        }
        return false;
    }
}

