/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="dungeonsweaponry")
public class PoisonCloudSpawner {
    public static final float BASE_DAMAGE_PER_SECOND = 2.0f;
    public static final int CLOUD_RADIUS = 4;
    public static final int CLOUD_HEIGHT = 4;
    public static List<PoisonCloudInfo> poison_clouds = new ArrayList<PoisonCloudInfo>();

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        for (PoisonCloudInfo poison_cloud : poison_clouds) {
            if (poison_cloud.respawn_tick >= 40) {
                PoisonCloudSpawner.sendCloudParticles(poison_cloud.serverLevel, poison_cloud.position);
                poison_cloud.respawn_tick = 0;
                --poison_cloud.spawn_repeats;
            }
            ++poison_cloud.respawn_tick;
            ++poison_cloud.tickCount;
            if (poison_cloud.tickCount % 20 != 0) continue;
            List<Entity> entitiesFound = poison_cloud.serverLevel.m_6443_(Entity.class, new AABB(poison_cloud.position.m_82520_(-4.0, -2.0, -4.0), poison_cloud.position.m_82520_(4.0, 2.0, 4.0)), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(poison_cloud.position))).toList();
            for (Entity entityiterator : entitiesFound) {
                if (!(entityiterator instanceof LivingEntity)) continue;
                LivingEntity _entity = (LivingEntity)entityiterator;
                if (entityiterator == poison_cloud.entity) continue;
                _entity.m_6469_(_entity.m_269291_().m_269425_(), 2.0f * (float)poison_cloud.damage_level);
            }
        }
        poison_clouds.removeIf(poisonCloudInfo -> poisonCloudInfo.spawn_repeats == 0);
    }

    public static void sendCloudParticles(ServerLevel level, Vec3 position) {
        float PARTICLE_SIZE = 30.0f;
        Vector3f PARTICLE_COLOR = new Vector3f(0.0f, 255.0f, 0.0f);
        int NUMBER_OF_PARTICLES = 200;
        List<Vec3> cloudPositions = PoisonCloudSpawner.generateParticlePositions(NUMBER_OF_PARTICLES, 4.0, 4.0, position);
        for (Vec3 vec3 : cloudPositions) {
            DustParticleOptions dustParticleOptions = new DustParticleOptions(PARTICLE_COLOR.normalize(), PARTICLE_SIZE);
            level.m_8767_((ParticleOptions)dustParticleOptions, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnPoisonCloud(Vec3 vec3, ServerLevel level, int damage_level, Entity entity) {
        PoisonCloudSpawner.sendCloudParticles(level, vec3);
        poison_clouds.add(new PoisonCloudInfo(vec3, level, 3, damage_level, entity));
    }

    public static List<Vec3> generateParticlePositions(int numParticles, double cloudRadius, double cloudHeight, Vec3 centralPosition) {
        Random random = new Random();
        ArrayList<Vec3> particlePositions = new ArrayList<Vec3>();
        for (int i = 0; i < numParticles; ++i) {
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double phi = random.nextDouble() * Math.PI;
            double x = cloudRadius * Math.sin(phi) * Math.cos(theta);
            double z = cloudRadius * Math.sin(phi) * Math.sin(theta);
            double y = cloudHeight * (random.nextDouble() - 0.5);
            x += (double)new Random().nextFloat(-1.0f, 1.0f);
            z += (double)new Random().nextFloat(-1.0f, 1.0f);
            y += (double)new Random().nextFloat(-1.0f, 1.0f);
            particlePositions.add(new Vec3(x += centralPosition.f_82479_, y += centralPosition.f_82480_, z += centralPosition.f_82481_));
        }
        return particlePositions;
    }

    public static class PoisonCloudInfo {
        public Vec3 position;
        public ServerLevel serverLevel;
        public int spawn_repeats;
        public int respawn_tick = 0;
        public int tickCount = 0;
        public int damage_level;
        public Entity entity;

        PoisonCloudInfo(Vec3 vec3, ServerLevel serverLevel, int spawn_repeats, int damage_level, Entity entity) {
            this.position = vec3;
            this.serverLevel = serverLevel;
            this.spawn_repeats = spawn_repeats;
            this.damage_level = damage_level;
            this.entity = entity;
        }
    }
}

