/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.items.bows;

import com.jeremyseq.DungeonsWeaponry.items.bows.DungeonArrow;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.jetbrains.annotations.NotNull;

public class DungeonArrowRenderer
extends ArrowRenderer<DungeonArrow> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("dungeonsweaponry", "textures/entity/arrow.png");
    public static final ResourceLocation GROWING = new ResourceLocation("dungeonsweaponry", "textures/entity/growing_arrow.png");
    public static final ResourceLocation GROWING_1 = new ResourceLocation("dungeonsweaponry", "textures/entity/growing_arrow2.png");
    public static final ResourceLocation GROWING_2 = new ResourceLocation("dungeonsweaponry", "textures/entity/growing_arrow3.png");
    public static final ResourceLocation GROWING_3 = new ResourceLocation("dungeonsweaponry", "textures/entity/growing_arrow4.png");
    public static final ResourceLocation GROWING_4 = new ResourceLocation("dungeonsweaponry", "textures/entity/growing_arrow5.png");

    public DungeonArrowRenderer(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(DungeonArrow entity, float entityYaw, float partialTicks, PoseStack posestack, MultiBufferSource buffer, int packedLight) {
        if (entity.getGrowingLevel() > 0) {
            posestack.m_85836_();
            float scale = 1.0f + (float)(entity.getInAirTick() + entity.getInAirTick() * entity.getGrowingLevel() / 4) / 15.0f;
            posestack.m_85841_(scale, scale, scale);
            super.m_7392_((AbstractArrow)entity, entityYaw, partialTicks, posestack, buffer, packedLight);
            posestack.m_85849_();
        } else {
            super.m_7392_((AbstractArrow)entity, entityYaw, partialTicks, posestack, buffer, packedLight);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(DungeonArrow arrow) {
        if (arrow.getGrowingLevel() > 0) {
            int i = arrow.f_19797_ % 20;
            if (i < 4) {
                return GROWING;
            }
            if (i < 8) {
                return GROWING_1;
            }
            if (i < 12) {
                return GROWING_2;
            }
            if (i < 16) {
                return GROWING_3;
            }
            return GROWING_4;
        }
        return TEXTURE;
    }
}

