/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.items.bows;

import com.jeremyseq.DungeonsWeaponry.items.bows.BaseBow;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class DungeonArrow
extends Arrow {
    public Entity shooter;
    public BaseBow BOW_CLASS;
    private int inAirTick = 0;
    private boolean inAir = true;
    public ItemStack bow;
    public static final float GROWING_DAMAGE_PER_TICK = 0.45f;
    public static final float GROWING_MAX_DAMAGE = 6.0f;
    public static final EntityDataAccessor<Integer> GROWING_LEVEL = SynchedEntityData.m_135353_(DungeonArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DungeonArrow(EntityType<? extends Arrow> pEntityType, Level pLevel, Entity shooter, BaseBow bow, ItemStack stack) {
        super(pEntityType, pLevel);
        this.BOW_CLASS = bow;
        this.shooter = shooter;
        this.bow = stack;
    }

    public void m_8119_() {
        if (this.inAir) {
            ++this.inAirTick;
        }
        super.m_8119_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GROWING_LEVEL, (Object)0);
    }

    public void setBow(BaseBow bow) {
        this.BOW_CLASS = bow;
    }

    public DungeonArrow(EntityType<? extends Arrow> dungeonArrowEntityType, Level level) {
        super(dungeonArrowEntityType, level);
        this.BOW_CLASS = null;
        this.shooter = null;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_, 1);
    }

    public void m_5790_(EntityHitResult pResult) {
        if (this.m_9236_() instanceof ServerLevel) {
            this.BOW_CLASS.onHitEntity(pResult.m_82443_().m_9236_(), pResult.m_82443_(), this.shooter);
        }
        super.m_5790_(pResult);
        if (pResult.m_82443_().m_6084_() && this.getGrowingLevel() > 0) {
            pResult.m_82443_().m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, this.shooter), (float)Math.min((double)this.inAirTick * (double)0.45f * (double)this.getGrowingLevel(), 6.0));
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.inAir = false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setGrowingLevel(int growing_level) {
        this.f_19804_.m_135381_(GROWING_LEVEL, (Object)growing_level);
    }

    public int getGrowingLevel() {
        return (Integer)this.f_19804_.m_135370_(GROWING_LEVEL);
    }

    public int getInAirTick() {
        return this.inAirTick;
    }

    protected boolean m_142470_(Player player) {
        if (this.BOW_CLASS == null) {
            return false;
        }
        if (this.BOW_CLASS.getEnchantmentLevel(this.bow, Enchantments.f_44952_) > 0) {
            return false;
        }
        return this.shooter instanceof Player;
    }
}

