/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.items;

import com.jeremyseq.DungeonsWeaponry.items.ModItems;
import com.jeremyseq.DungeonsWeaponry.items.WeaponRarity;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class DungeonsWeapon {
    private final WeaponRarity rarity;
    private final int emerald_cost;
    private int itemstack_count;
    private final int villager_sell_level;
    private RegistryObject<Item> item;

    public DungeonsWeapon(WeaponRarity rarity, int emerald_cost, int villager_sell_level) {
        this.rarity = rarity;
        this.emerald_cost = emerald_cost;
        this.itemstack_count = 1;
        this.villager_sell_level = villager_sell_level;
    }

    public DungeonsWeapon setItemstackCount(int itemstack_count) {
        this.itemstack_count = itemstack_count;
        return this;
    }

    public WeaponRarity getRarity() {
        return this.rarity;
    }

    public int getEmeraldCost() {
        return this.emerald_cost;
    }

    public int getItemstackCount() {
        return this.itemstack_count;
    }

    public int getVillagerSellLevel() {
        return this.villager_sell_level;
    }

    public DungeonsWeapon setItem(RegistryObject<Item> item) {
        this.item = item;
        return this;
    }

    public RegistryObject<Item> getItem() {
        return this.item;
    }

    public static ItemStack getWeaponDrop() {
        TreeMap<Integer, DungeonsWeapon> weighedMap = new TreeMap<Integer, DungeonsWeapon>();
        int totalWeight = 0;
        for (DungeonsWeapon dungeonsWeapon : ModItems.DUNGEONS_WEAPONS) {
            weighedMap.put(totalWeight += DungeonsWeapon.rarityToChance(dungeonsWeapon.getRarity()), dungeonsWeapon);
        }
        Random rnd = new Random();
        int pick = rnd.nextInt(totalWeight);
        DungeonsWeapon obj = (DungeonsWeapon)weighedMap.higherEntry(pick).getValue();
        int count = obj.getItemstackCount();
        return new ItemStack((ItemLike)obj.getItem().get(), count);
    }

    public static int rarityToChance(WeaponRarity rarity) {
        int chance = 0;
        if (rarity == WeaponRarity.COMMON) {
            chance = 3;
        } else if (rarity == WeaponRarity.RARE) {
            chance = 2;
        } else if (rarity == WeaponRarity.LEGENDARY) {
            chance = 1;
        }
        return chance;
    }
}

