/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.custom;

import com.jeremyseq.DungeonsWeaponry.entity.EntityUtil;
import com.jeremyseq.DungeonsWeaponry.network.PacketHandler;
import com.jeremyseq.DungeonsWeaponry.network.S2CPackets.PlayWildfireShockwaveAnimS2CPacket;
import com.jeremyseq.DungeonsWeaponry.util.ModSoundEvents;
import com.jeremyseq.DungeonsWeaponry.util.ParticleShapes;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WildfireEntity
extends Monster
implements GeoEntity,
RangedAttackMob {
    public static final int MAX_SHIELD = 100;
    public static final int REGEN_TIME = 120;
    private int regenTime = 120;
    public static final EntityDataAccessor<Integer> SHIELD = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SHOCKWAVE = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_SHOCKWAVE = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float allowedHeightOffset = 0.5f;
    public static final int RETREAT_TIME = 60;
    private boolean runAway = false;
    private int runTimer = 60;
    public static final int SHOCKWAVE_RADIUS = 5;
    private int shockwave_countdown;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int fireball_countdown;
    private int fireball_num;
    public static final int FIREBALL_SUCCESSION_TIME = 5;

    public WildfireEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getShockwave()) {
            if (this.getStartShockwave()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartShockwave(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.wildfire.shockwave." + this.getNumberOfShields(), Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setShockwave(false);
            }
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.wildfire.spin." + this.getNumberOfShields(), Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_8107_() {
        LivingEntity livingentity;
        if (this.runAway) {
            livingentity = this.m_5448_();
            if (livingentity != null) {
                this.m_20256_(this.m_20182_().m_82546_(livingentity.m_20182_()).m_82541_().m_82542_(0.1, 0.0, 0.1));
            }
            --this.runTimer;
            if (this.runTimer == 0) {
                this.runAway = false;
                this.runTimer = 60;
            }
        }
        if (this.regenTime <= 0) {
            this.setShield(this.getShield() + this.getHealthPerShield());
            this.regenTime = 120;
        }
        --this.regenTime;
        livingentity = this.m_5448_();
        if (livingentity != null) {
            this.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
        }
        if (livingentity != null && livingentity.m_20270_((Entity)this) < 3.0f) {
            if (new Random().nextInt(0, 10) <= 7) {
                if (this.shockwave_countdown <= 0) {
                    List nearbyEntities = this.m_9236_().m_45971_(Player.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(5.0, 5.0, 5.0));
                    for (Player player : nearbyEntities) {
                        PacketHandler.sendToPlayer(new PlayWildfireShockwaveAnimS2CPacket(this.m_19879_()), (ServerPlayer)player);
                    }
                    this.setShockwave(true);
                    this.setStartShockwave(true);
                    this.shockwave_countdown = 25;
                }
            } else {
                this.runAway = true;
            }
        }
        if (livingentity != null && this.m_6779_(livingentity)) {
            if (livingentity.m_20188_() > this.m_20188_() + (double)this.allowedHeightOffset) {
                vec3 = this.m_20184_();
                this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
            } else {
                vec3 = this.m_20184_();
                this.m_20256_(this.m_20184_().m_82520_(0.0, -((double)0.3f + vec3.f_82480_) * (double)0.3f, 0.0));
            }
        }
        if (this.shockwave_countdown != 0) {
            if (this.shockwave_countdown <= 1) {
                this.performShockwaveAttack();
                this.shockwave_countdown = 0;
            } else {
                --this.shockwave_countdown;
            }
        }
        if (new Random().nextInt(200) == 1 && livingentity != null) {
            this.summon();
        }
        if (this.fireball_countdown != 0) {
            if (this.fireball_countdown <= 1) {
                this.performRangedAttackSuccession(this.m_5448_());
                this.fireball_countdown = this.fireball_num == 0 ? 0 : 5;
            } else {
                --this.fireball_countdown;
            }
        }
        super.m_8107_();
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42585_, 2 * new Random().nextInt(1, pLooting + 2)));
        EntityUtil.spawnWeaponLoot((Mob)this, 15, pLooting);
        EntityUtil.spawnEmeraldLoot((Mob)this, 5, 20, pLooting);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource == this.m_269291_().m_268989_() || pSource == this.m_269291_().m_269549_() || pSource == this.m_269291_().m_269387_() || pSource == this.m_269291_().m_269233_()) {
            return false;
        }
        this.regenTime = 120;
        if (this.getShield() > 0) {
            int start = this.getNumberOfShields();
            this.setShield((int)((float)this.getShield() - pAmount));
            if (this.getNumberOfShields() < start) {
                this.m_216990_((SoundEvent)ModSoundEvents.WILDFIRE_SHIELDBREAK.get());
            }
            return super.m_6469_(pSource, 0.0f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void performRangedAttackSuccession(LivingEntity pTarget) {
        --this.fireball_num;
        if (pTarget != null) {
            this.m_216990_((SoundEvent)ModSoundEvents.WILDFIRE_SHOOT.get());
            double d0 = this.m_20280_((Entity)pTarget);
            double d1 = pTarget.m_20185_() - this.m_20185_();
            double d2 = pTarget.m_20227_(0.5) - this.m_20227_(0.5);
            double d3 = pTarget.m_20189_() - this.m_20189_();
            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
            SmallFireball smallfireball = new SmallFireball(this.m_9236_(), (LivingEntity)this, this.m_217043_().m_216328_(d1, 2.297 * d4), d2, this.m_217043_().m_216328_(d3, 2.297 * d4));
            smallfireball.m_6034_(smallfireball.m_20185_(), this.m_20227_(0.5) + 0.5, smallfireball.m_20189_());
            this.m_9236_().m_7967_((Entity)smallfireball);
        }
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        this.fireball_countdown = 5;
        this.fireball_num = 3;
        this.performRangedAttackSuccession(pTarget);
    }

    public void performShockwaveAttack() {
        this.m_216990_((SoundEvent)ModSoundEvents.WILDFIRE_SHOCKWAVE.get());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleShapes.createCircle(serverLevel, 90, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0, ParticleTypes.f_123744_);
            List nearbyEntities = serverLevel.m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this, this.m_20191_().m_82377_(10.0, 10.0, 10.0));
            for (LivingEntity entity : nearbyEntities) {
                if (entity instanceof Blaze || entity instanceof WildfireEntity || !(entity.m_20270_((Entity)this) <= 5.0f)) continue;
                entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22115_());
                entity.m_20256_(entity.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82542_(2.0, 2.0, 2.0));
            }
        }
    }

    public void summon() {
        Blaze toSpawn = new Blaze(EntityType.f_20551_, this.m_9236_());
        Vec3 pos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        pos = pos.m_82549_(this.m_20156_());
        toSpawn.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.m_9236_().m_7967_((Entity)toSpawn);
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELD, (Object)100);
        this.f_19804_.m_135372_(SHOCKWAVE, (Object)false);
        this.f_19804_.m_135372_(START_SHOCKWAVE, (Object)false);
    }

    public void setShield(int state) {
        this.f_19804_.m_135381_(SHIELD, (Object)Math.min(state, 100));
    }

    public int getShield() {
        return (Integer)this.f_19804_.m_135370_(SHIELD);
    }

    public int getNumberOfShields() {
        if (this.getShield() > 75) {
            return 4;
        }
        if (this.getShield() > 50) {
            return 3;
        }
        if (this.getShield() > 25) {
            return 2;
        }
        if (this.getShield() > 0) {
            return 1;
        }
        return 0;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.WILDFIRE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.WILDFIRE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.WILDFIRE_DEATH.get();
    }

    public int getHealthPerShield() {
        return 25;
    }

    public void setShockwave(boolean state) {
        this.f_19804_.m_135381_(SHOCKWAVE, (Object)state);
    }

    public boolean getShockwave() {
        return (Boolean)this.f_19804_.m_135370_(SHOCKWAVE);
    }

    public void setStartShockwave(boolean state) {
        this.f_19804_.m_135381_(START_SHOCKWAVE, (Object)state);
    }

    public boolean getStartShockwave() {
        return (Boolean)this.f_19804_.m_135370_(START_SHOCKWAVE);
    }
}

