/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.custom;

import com.jeremyseq.DungeonsWeaponry.entity.EntityUtil;
import com.jeremyseq.DungeonsWeaponry.init.ModEntities;
import com.jeremyseq.DungeonsWeaponry.items.ModItems;
import com.jeremyseq.DungeonsWeaponry.util.ModSoundEvents;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class VanguardEntity
extends Monster
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(VanguardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_ATTACK = SynchedEntityData.m_135353_(VanguardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHIELD = SynchedEntityData.m_135353_(VanguardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LOSE_SHIELD = SynchedEntityData.m_135353_(VanguardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_LOSE_SHIELD = SynchedEntityData.m_135353_(VanguardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attack_countdown;
    private LivingEntity enemy;

    public VanguardEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public VanguardEntity(Level pLevel) {
        super((EntityType)ModEntities.VANGUARD.get(), pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.VANGUARD_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.VANGUARD_HURT.get();
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getLoseShield()) {
            if (this.getStartLoseShield()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartLoseShield(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.skeleton_vanguard.shield_breaking", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setLoseShield(false);
            }
            return PlayState.CONTINUE;
        }
        if (this.getAttack()) {
            if (this.getStartAttack()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartAttack(false);
            }
            if (this.getShield()) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.skeleton_vanguard.attack", Animation.LoopType.PLAY_ONCE));
            } else {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.skeleton_vanguard.attack_no_shield", Animation.LoopType.PLAY_ONCE));
            }
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setAttack(false);
            }
            return PlayState.CONTINUE;
        }
        if (tAnimationState.isMoving()) {
            if (this.getShield()) {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.skeleton_vanguard.walk", Animation.LoopType.LOOP));
            } else {
                tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.skeleton_vanguard.walk_no_shield", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        if (this.getShield()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.skeleton_vanguard.idle", Animation.LoopType.LOOP));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.skeleton_vanguard.idle_no_shield", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void m_6674_(InteractionHand pHand) {
        this.m_216990_((SoundEvent)ModSoundEvents.VANGUARD_ATTACK.get());
        this.setAttack(true);
        this.setStartAttack(true);
        this.attack_countdown = 20;
    }

    public void m_8107_() {
        if (this.attack_countdown != 0) {
            if (this.attack_countdown <= 1) {
                super.m_6674_(InteractionHand.MAIN_HAND);
                this.attack_countdown = 0;
            } else {
                --this.attack_countdown;
            }
        }
        super.m_8107_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.getShield()) {
            this.destroyShield();
            this.m_216990_((SoundEvent)ModSoundEvents.VANGUARD_SHIELD_BREAKING.get());
            return super.m_6469_(pSource, 0.0f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    private SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.VANGUARD_WALK.get();
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42500_, new Random().nextInt(1, pLooting + 2)));
        EntityUtil.spawnWeaponLoot((Mob)this, 40, pLooting);
        int random = new Random().nextInt(1, 3);
        if (random == 1) {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.GLAIVE.get());
            int damage = ((Item)ModItems.GLAIVE.get()).getMaxDamage(itemStack);
            damage = new Random().nextInt(1, damage);
            itemStack.m_41721_(damage);
            this.m_19983_(itemStack);
        }
        EntityUtil.spawnEmeraldLoot((Mob)this, 0, 2, pLooting);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(START_ATTACK, (Object)false);
        this.f_19804_.m_135372_(LOSE_SHIELD, (Object)false);
        this.f_19804_.m_135372_(START_LOSE_SHIELD, (Object)false);
        this.f_19804_.m_135372_(SHIELD, (Object)true);
    }

    public void setAttack(boolean state) {
        this.f_19804_.m_135381_(ATTACK, (Object)state);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setStartAttack(boolean state) {
        this.f_19804_.m_135381_(START_ATTACK, (Object)state);
    }

    public boolean getStartAttack() {
        return (Boolean)this.f_19804_.m_135370_(START_ATTACK);
    }

    public void destroyShield() {
        this.f_19804_.m_135381_(START_LOSE_SHIELD, (Object)true);
        this.f_19804_.m_135381_(LOSE_SHIELD, (Object)true);
        this.f_19804_.m_135381_(SHIELD, (Object)false);
    }

    public boolean getShield() {
        return (Boolean)this.f_19804_.m_135370_(SHIELD);
    }

    public void setLoseShield(boolean state) {
        this.f_19804_.m_135381_(LOSE_SHIELD, (Object)state);
    }

    public boolean getLoseShield() {
        return (Boolean)this.f_19804_.m_135370_(LOSE_SHIELD);
    }

    public void setStartLoseShield(boolean state) {
        this.f_19804_.m_135381_(START_LOSE_SHIELD, (Object)state);
    }

    public boolean getStartLoseShield() {
        return (Boolean)this.f_19804_.m_135370_(START_LOSE_SHIELD);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

