/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.DungeonsWeaponry.entity.custom;

import com.jeremyseq.DungeonsWeaponry.entity.EntityUtil;
import com.jeremyseq.DungeonsWeaponry.util.ModSoundEvents;
import com.jeremyseq.DungeonsWeaponry.util.ParticleShapes;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NecromancerEntity
extends Monster
implements GeoEntity,
RangedAttackMob {
    public static final EntityDataAccessor<Boolean> SUMMON = SynchedEntityData.m_135353_(NecromancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_SUMMON = SynchedEntityData.m_135353_(NecromancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(NecromancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_ATTACK = SynchedEntityData.m_135353_(NecromancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HURT = SynchedEntityData.m_135353_(NecromancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> START_HURT = SynchedEntityData.m_135353_(NecromancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int tick;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private List<LivingEntity> enemyList;
    private int summon_countdown;
    private int attack_countdown;

    public NecromancerEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.getSummonState()) {
            if (this.getStartSummonState()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartSummonState(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.necromancer.summon", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setSummonState(false);
            }
            return PlayState.CONTINUE;
        }
        if (this.getHurt()) {
            if (this.getStartHurt()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartHurt(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.necromancer.hurt", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setHurt(false);
            }
            return PlayState.CONTINUE;
        }
        if (this.getAttack()) {
            if (this.getStartAttack()) {
                tAnimationState.getController().forceAnimationReset();
                this.setStartAttack(false);
            }
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.necromancer.attack", Animation.LoopType.PLAY_ONCE));
            if (tAnimationState.getController().hasAnimationFinished()) {
                this.setAttack(false);
            }
            return PlayState.CONTINUE;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.necromancer.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.necromancer.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    private SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.setHurt(true);
        this.setStartHurt(true);
        return super.m_6469_(pSource, pAmount);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42500_, 3 * new Random().nextInt(1, pLooting + 2)));
        EntityUtil.spawnWeaponLoot((Mob)this, 20, pLooting);
        EntityUtil.spawnEmeraldLoot((Mob)this, 0, 4, pLooting);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMON, (Object)false);
        this.f_19804_.m_135372_(START_SUMMON, (Object)false);
        this.f_19804_.m_135372_(HURT, (Object)false);
        this.f_19804_.m_135372_(START_HURT, (Object)false);
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(START_ATTACK, (Object)false);
    }

    public void m_8107_() {
        Predicate<LivingEntity> ENEMY_SELECTOR = p_31504_ -> p_31504_ instanceof Player && p_31504_.m_5789_();
        TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(20.0).m_26888_(ENEMY_SELECTOR);
        this.enemyList = this.m_9236_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82377_(20.0, 8.0, 20.0));
        if (this.enemyList.size() > 0) {
            ++this.tick;
            if (this.tick >= 100) {
                this.setSummonState(true);
                this.setStartSummonState(true);
                this.summon_countdown = 30;
                this.tick = 0;
            } else if (this.tick == 50) {
                this.setAttack(true);
                this.setStartAttack(true);
                this.attack_countdown = 20;
            }
        }
        if (this.summon_countdown != 0) {
            if (this.summon_countdown <= 1) {
                this.summon();
                this.summon_countdown = 0;
            } else {
                --this.summon_countdown;
            }
        }
        if (this.attack_countdown != 0) {
            if (this.attack_countdown <= 1) {
                this.attack();
                this.attack_countdown = 0;
            } else {
                --this.attack_countdown;
            }
        }
        super.m_8107_();
    }

    public void summon() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_247517_(null, this.m_20183_(), (SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get(), SoundSource.HOSTILE);
            for (int i = 0; i < 3; ++i) {
                Zombie toSpawn;
                if (i < 2) {
                    toSpawn = new Zombie((Level)serverLevel);
                } else {
                    toSpawn = new Skeleton(EntityType.f_20524_, (Level)serverLevel);
                    toSpawn.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
                }
                Vec3 pos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                pos = pos.m_82549_(this.m_20156_());
                toSpawn.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                serverLevel.m_7967_((Entity)toSpawn);
                ItemParticleOption particleOption = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42329_));
                ParticleShapes.createCircle(serverLevel, 20, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, particleOption);
            }
        }
    }

    public void attack() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.enemyList.isEmpty()) {
                serverLevel.m_247517_(null, this.m_20183_(), (SoundEvent)ModSoundEvents.NECROMANCER_ATTACK.get(), SoundSource.HOSTILE);
                LivingEntity target = this.enemyList.get(0);
                if (target != null) {
                    Vec3 origin = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
                    origin = origin.m_82549_(this.m_20156_());
                    ParticleShapes.createLine(serverLevel, origin.f_82479_, origin.f_82480_, origin.f_82481_, target.m_20185_(), target.m_20186_(), target.m_20189_(), 50, ParticleTypes.f_123745_);
                    target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22115_());
                }
            }
        }
    }

    public void setSummonState(boolean state) {
        this.f_19804_.m_135381_(SUMMON, (Object)state);
    }

    public boolean getSummonState() {
        return (Boolean)this.f_19804_.m_135370_(SUMMON);
    }

    public void setStartSummonState(boolean state) {
        this.f_19804_.m_135381_(START_SUMMON, (Object)state);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state) {
                serverLevel.m_247517_(null, this.m_20183_(), (SoundEvent)ModSoundEvents.NECROMANCER_PREPARE_SUMMON.get(), SoundSource.HOSTILE);
            }
        }
    }

    public boolean getStartSummonState() {
        return (Boolean)this.f_19804_.m_135370_(START_SUMMON);
    }

    public void setHurt(boolean state) {
        this.f_19804_.m_135381_(HURT, (Object)state);
    }

    public boolean getHurt() {
        return (Boolean)this.f_19804_.m_135370_(HURT);
    }

    public void setStartHurt(boolean state) {
        this.f_19804_.m_135381_(START_HURT, (Object)state);
    }

    public boolean getStartHurt() {
        return (Boolean)this.f_19804_.m_135370_(START_HURT);
    }

    public void setStartAttack(boolean state) {
        this.f_19804_.m_135381_(START_ATTACK, (Object)state);
    }

    public boolean getStartAttack() {
        return (Boolean)this.f_19804_.m_135370_(START_ATTACK);
    }

    public void setAttack(boolean state) {
        this.f_19804_.m_135381_(ATTACK, (Object)state);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }
}

